/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.camel.CamelContext;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.service.CamelContextRegistryService;

public final class ModuleClassLoaderAssociationHandler
implements ContextCreateHandler {
    @Override
    public void setup(CamelContext camelctx) {
        Module tcm;
        ClassLoader tccl;
        Module contextModule = null;
        ClassLoader applicationClassLoader = camelctx.getApplicationContextClassLoader();
        if (applicationClassLoader instanceof ModuleClassLoader) {
            contextModule = ((ModuleClassLoader)applicationClassLoader).getModule();
        }
        if (contextModule == null) {
            ClassLoader thiscl = CamelContextRegistryService.class.getClassLoader();
            ClassLoader tccl2 = Thread.currentThread().getContextClassLoader();
            if (tccl2 == thiscl) {
                contextModule = ((ModuleClassLoader)thiscl).getModule();
            }
        }
        if (contextModule == null && (tccl = Thread.currentThread().getContextClassLoader()) instanceof ModuleClassLoader && (tcm = ((ModuleClassLoader)tccl).getModule()).getIdentifier().getName().startsWith("deployment.")) {
            contextModule = tcm;
        }
        if (contextModule == null) {
            Class<?> callingClass = CallerContext.getCallingClass();
            contextModule = ((ModuleClassLoader)callingClass.getClassLoader()).getModule();
        }
        IllegalStateAssertion.assertNotNull((Object)contextModule, (String)("Cannot obtain module for: " + camelctx));
        ModuleClassLoader moduleClassLoader = contextModule.getClassLoader();
        camelctx.setApplicationContextClassLoader((ClassLoader)moduleClassLoader);
    }

    static final class CallerContext {
        private static Hack hack = AccessController.doPrivileged(new PrivilegedAction<Hack>(){

            @Override
            public Hack run() {
                return new Hack();
            }
        });

        private CallerContext() {
        }

        static Class<?> getCallingClass() {
            Class<?>[] stack = hack.getClassContext();
            int i = 3;
            while (stack[i] == stack[2]) {
                if (++i < stack.length) continue;
                return null;
            }
            Class<?> result = stack[i];
            while (CallerContext.ignoreCaller(result.getName())) {
                result = stack[++i];
            }
            return result;
        }

        private static boolean ignoreCaller(String caller) {
            boolean result = caller.startsWith("org.wildfly.extension.camel");
            result |= caller.startsWith("org.springframework");
            return result |= caller.startsWith("org.apache.camel");
        }

        private static final class Hack
        extends SecurityManager {
            private Hack() {
            }

            @Override
            protected Class<?>[] getClassContext() {
                return super.getClassContext();
            }
        }
    }
}

