/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.camel.parser.CamelContextResource;
import org.wildfly.extension.camel.parser.SubsystemState;

final class CamelContextAdd
extends AbstractAddStepHandler {
    private final SubsystemState subsystemState;

    CamelContextAdd(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CamelContextResource.VALUE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String propName = operation.get("address").asObject().get("context").asString();
        String propValue = CamelContextResource.VALUE.resolveModelAttribute(context, model).asString();
        this.subsystemState.putContextDefinition(propName, propValue.trim());
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String propName = operation.get("address").asObject().get("context").asString();
        this.subsystemState.removeContextDefinition(propName);
    }
}

