/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.camel.deployment.CamelContextActivationProcessor;
import org.wildfly.extension.camel.deployment.CamelContextCreateProcessor;
import org.wildfly.extension.camel.deployment.CamelDependenciesProcessor;
import org.wildfly.extension.camel.deployment.CamelIntegrationParser;
import org.wildfly.extension.camel.deployment.CamelIntegrationProcessor;
import org.wildfly.extension.camel.deployment.PackageScanResolverProcessor;
import org.wildfly.extension.camel.deployment.RepositoryContentInstallProcessor;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.CamelBootstrapService;
import org.wildfly.extension.camel.service.CamelContextFactoryBindingService;
import org.wildfly.extension.camel.service.CamelContextFactoryService;
import org.wildfly.extension.camel.service.CamelContextRegistryBindingService;
import org.wildfly.extension.camel.service.CamelContextRegistryService;
import org.wildfly.extension.camel.service.ContextCreateHandlerRegistryService;
import org.wildfly.extension.gravia.parser.GraviaSubsystemBootstrap;

final class CamelSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final int STRUCTURE_REGISTER_CAMEL_INTEGRATION = 2783;
    public static final int PARSE_CAMEL_INTEGRATION_PROVIDER = 14337;
    public static final int DEPENDENCIES_CAMEL = 7425;
    public static final int POST_MODULE_PACKAGE_SCAN_RESOLVER = 7681;
    public static final int POST_MODULE_CAMEL_CONTEXT_CREATE = 7682;
    public static final int INSTALL_REPOSITORY_CONTENT = 8257;
    public static final int INSTALL_CAMEL_CONTEXT_ACTIVATION = 8258;
    private final SubsystemState subsystemState;

    public CamelSubsystemAdd(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        final GraviaSubsystemBootstrap graviaSubsystem = new GraviaSubsystemBootstrap();
        final JBossAllXmlParserRegisteringProcessor parser = new JBossAllXmlParserRegisteringProcessor(CamelIntegrationParser.ROOT_ELEMENT, CamelIntegrationParser.ATTACHMENT_KEY, (JBossAllXMLParser)new CamelIntegrationParser());
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                newControllers.addAll(graviaSubsystem.getSubsystemServices(context, verificationHandler));
                newControllers.add(CamelBootstrapService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelContextFactoryService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelContextFactoryBindingService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(CamelContextRegistryService.addService(context.getServiceTarget(), CamelSubsystemAdd.this.subsystemState, verificationHandler));
                newControllers.add(CamelContextRegistryBindingService.addService(context.getServiceTarget(), verificationHandler));
                newControllers.add(ContextCreateHandlerRegistryService.addService(context.getServiceTarget(), verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                graviaSubsystem.addDeploymentUnitProcessors(processorTarget);
                processorTarget.addDeploymentProcessor("camel", Phase.STRUCTURE, 2783, (DeploymentUnitProcessor)parser);
                processorTarget.addDeploymentProcessor("camel", Phase.PARSE, 2783, (DeploymentUnitProcessor)new CamelIntegrationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.DEPENDENCIES, 7425, (DeploymentUnitProcessor)new CamelDependenciesProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.POST_MODULE, 7682, (DeploymentUnitProcessor)new CamelContextCreateProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.POST_MODULE, 7681, (DeploymentUnitProcessor)new PackageScanResolverProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 8258, (DeploymentUnitProcessor)new CamelContextActivationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 8257, (DeploymentUnitProcessor)new RepositoryContentInstallProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

