/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.constants.PosixBracket;
import org.jcodings.exception.CharacterPropertyException;

abstract class AbstractEncoding
extends Encoding {
    private final short[] CTypeTable;
    protected static final CaseFoldCodeItem[] EMPTY_FOLD_CODES = new CaseFoldCodeItem[0];

    protected AbstractEncoding(String name2, int minLength, int maxLength, short[] CTypeTable) {
        super(name2, minLength, maxLength);
        this.CTypeTable = CTypeTable;
    }

    protected AbstractEncoding(String name2, int minLength, int maxLength, short[] CTypeTable, boolean isDummy) {
        super(name2, minLength, maxLength, isDummy);
        this.CTypeTable = CTypeTable;
    }

    private static int CTypeToBit(int ctype) {
        return 1 << ctype;
    }

    protected final boolean isCodeCTypeInternal(int code, int ctype) {
        return (this.CTypeTable[code] & AbstractEncoding.CTypeToBit(ctype)) != 0;
    }

    public boolean isNewLine(byte[] bytes2, int p2, int end2) {
        return p2 < end2 ? bytes2[p2] == 10 : false;
    }

    protected final int asciiMbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] lower) {
        lower[0] = AsciiTables.ToLowerCaseTable[bytes2[pp.value] & 0xFF];
        ++pp.value;
        return 1;
    }

    public int mbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] lower) {
        return this.asciiMbcCaseFold(flag, bytes2, pp, end2, lower);
    }

    protected final void asciiApplyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg2) {
        int[] code = new int[]{0};
        for (int i2 = 0; i2 < AsciiTables.LowerMap.length; ++i2) {
            code[0] = AsciiTables.LowerMap[i2][1];
            fun.apply(AsciiTables.LowerMap[i2][0], code, 1, arg2);
            code[0] = AsciiTables.LowerMap[i2][0];
            fun.apply(AsciiTables.LowerMap[i2][1], code, 1, arg2);
        }
    }

    public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg2) {
        this.asciiApplyAllCaseFold(flag, fun, arg2);
    }

    protected final CaseFoldCodeItem[] asciiCaseFoldCodesByString(int flag, byte[] bytes2, int p2, int end2) {
        int b = bytes2[p2] & 0xFF;
        if (65 <= b && b <= 90) {
            return new CaseFoldCodeItem[]{new CaseFoldCodeItem(1, 1, new int[]{b + 32})};
        }
        if (97 <= b && b <= 122) {
            return new CaseFoldCodeItem[]{new CaseFoldCodeItem(1, 1, new int[]{b - 32})};
        }
        return EMPTY_FOLD_CODES;
    }

    public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes2, int p2, int end2) {
        return this.asciiCaseFoldCodesByString(flag, bytes2, p2, end2);
    }

    public int propertyNameToCType(byte[] bytes2, int p2, int end2) {
        Integer ctype = PosixBracket.PBSTableUpper.get(bytes2, p2, end2);
        if (ctype != null) {
            return ctype;
        }
        throw new CharacterPropertyException("invalid character property name <%n>", new String(bytes2, p2, end2 - p2));
    }
}

