/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.SharedScopeBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ForNode
extends IterNode {
    public final CallSite callAdapter = MethodIndex.getCallSite("each");
    private Node iterNode;

    public ForNode(ISourcePosition position, Node varNode, Node bodyNode, Node iterNode, StaticScope scope) {
        super(position, varNode, scope, bodyNode);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = iterNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FORNODE;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitForNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Block block = SharedScopeBlock.newInterpretedSharedScopeClosure(context, this, context.getCurrentScope(), self);
        try {
            while (true) {
                try {
                    String savedFile = context.getFile();
                    int savedLine = context.getLine();
                    IRubyObject recv2 = null;
                    try {
                        recv2 = this.iterNode.interpret(runtime, context, self, aBlock);
                    }
                    finally {
                        context.setFileAndLine(savedFile, savedLine);
                    }
                    return this.callAdapter.call(context, self, recv2, block);
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                break;
            }
        }
        catch (JumpException.BreakJump bj) {
            return (IRubyObject)bj.getValue();
        }
    }
}

