/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod {
    private Callback callback;

    public FullFunctionCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeNone);
        this.callback = callback;
    }

    /*
     * Loose catch block
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject;
            block14: {
                this.callConfig.pre(context, self, clazz, name2, block, null);
                assert (args2 != null);
                Ruby runtime = context.runtime;
                boolean isTrace = runtime.hasEventHooks();
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.C_CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                }
                try {
                    iRubyObject = this.callback.execute(self, args2, block);
                    if (!isTrace) break block14;
                }
                catch (JumpException.ReturnJump rj) {
                    block15: {
                        if (rj.getTarget() != context.getFrameJumpTarget()) break block15;
                        IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                        if (isTrace) {
                            runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                        }
                        this.callConfig.post(context);
                        return iRubyObject2;
                    }
                    throw rj;
                    {
                        catch (Throwable throwable) {
                            if (isTrace) {
                                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                            }
                            throw throwable;
                        }
                    }
                }
                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
            }
            return iRubyObject;
        }
        finally {
            this.callConfig.post(context);
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Arity getArity() {
        return this.getCallback().getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

