/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;

public class MultipleAsgnBase
extends Instr
implements ResultInstr {
    protected Variable result;
    protected Operand array;
    protected final int index;

    public MultipleAsgnBase(Operation op, Variable result2, Operand array, int index2) {
        super(op);
        assert (result2 != null) : "MultipleAsgnBase result is null";
        this.result = result2;
        this.array = array;
        this.index = index2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.array};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.array = this.array.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        return super.simplifyAndGetResult(scope, valueMap);
    }
}

