/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AsString
extends Operand {
    private final Operand source;

    public AsString(Operand source2) {
        if (source2 == null) {
            source2 = new StringLiteral("");
        }
        this.source = source2;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        return ((IRubyObject)this.source.retrieve(context, self, currDynScope, temp)).asString();
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newSource = this.source.getSimplifiedOperand(valueMap, force);
        return newSource == this.source ? this : new AsString(newSource);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return new AsString(this.source.cloneForInlining(ii));
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.source.addUsedVariables(l);
    }

    public String toString() {
        return "#{" + this.source + "}";
    }

    public Operand getSource() {
        return this.source;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AsString(this);
    }
}

