/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SValue
extends Operand {
    private final Operand array;

    public SValue(Operand array) {
        this.array = array;
    }

    @Override
    public boolean hasKnownValue() {
        return this.array.hasKnownValue();
    }

    public String toString() {
        return "SValue:" + this.array;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newArray = this.array.getSimplifiedOperand(valueMap, force);
        if (newArray instanceof Array) {
            Array a = (Array)newArray;
            return a.elts.length == 1 ? a.elts[0] : a;
        }
        return newArray == this.array ? this : new SValue(newArray);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.array.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.hasKnownValue() ? this : new SValue(this.array.cloneForInlining(ii));
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        Object val = this.array.retrieve(context, self, currDynScope, temp);
        if (context.runtime.is1_9()) {
            return val instanceof RubyArray ? val : context.runtime.getNil();
        }
        if (val instanceof RubyArray) {
            int n = ((RubyArray)val).getLength();
            if (n == 0) {
                return context.nil;
            }
            if (n == 1) {
                return ((RubyArray)val).entry(0);
            }
            return val;
        }
        return context.nil;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SValue(this);
    }
}

