/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.runtime.CallType;
import org.jruby.runtime.callsite.CacheEntry;

public class JRubyCallSite
extends MutableCallSite {
    private final MethodHandles.Lookup lookup;
    private final CallType callType;
    public CacheEntry entry = CacheEntry.NULL_CACHE;
    private final Set<Integer> seenTypes = new HashSet<Integer>();
    private final boolean attrAssign;
    private final boolean iterator;
    private final boolean expression;
    private final String name;
    private int clearCount;
    private static final AtomicLong SITE_ID = new AtomicLong(1L);
    private final long siteID = SITE_ID.getAndIncrement();
    private final String file;
    private final int line;
    private boolean boundOnce = false;

    public JRubyCallSite(MethodHandles.Lookup lookup, MethodType type2, CallType callType, String file2, int line, String name2, boolean attrAssign, boolean iterator, boolean expression) {
        super(type2);
        this.lookup = lookup;
        this.callType = callType;
        this.attrAssign = attrAssign;
        this.iterator = iterator;
        this.expression = expression;
        this.name = name2;
        this.file = file2;
        this.line = line;
    }

    public MethodHandles.Lookup lookup() {
        return this.lookup;
    }

    public CallType callType() {
        return this.callType;
    }

    public boolean isAttrAssign() {
        return this.attrAssign;
    }

    public boolean isIterator() {
        return this.iterator;
    }

    public boolean isExpression() {
        return this.expression;
    }

    public String name() {
        return this.name;
    }

    public synchronized boolean hasSeenType(int typeCode) {
        return this.seenTypes.contains(typeCode);
    }

    public synchronized void addType(int typeCode) {
        this.seenTypes.add(typeCode);
    }

    public synchronized int seenTypesCount() {
        return this.seenTypes.size();
    }

    public synchronized void clearTypes() {
        this.seenTypes.clear();
        ++this.clearCount;
    }

    public int clearCount() {
        return this.clearCount;
    }

    public long siteID() {
        return this.siteID;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public boolean boundOnce() {
        return this.boundOnce;
    }

    public void boundOnce(boolean boundOnce) {
        this.boundOnce = boundOnce;
    }

    @Override
    public void setTarget(MethodHandle target) {
        super.setTarget(target);
        this.boundOnce = true;
    }

    public void setInitialTarget(MethodHandle target) {
        super.setTarget(target);
    }
}

