/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.directvm.DirectVmBlockingProducer;
import org.apache.camel.component.directvm.DirectVmComponent;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmProcessor;
import org.apache.camel.component.directvm.DirectVmProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="direct-vm", syntax="direct-vm:name", consumerClass=DirectConsumer.class, label="core,endpoint")
public class DirectVmEndpoint
extends DefaultEndpoint {
    @UriPath(description="Name of direct-vm endpoint")
    @Metadata(required="true")
    private String name;
    @UriParam(label="producer")
    private boolean block;
    @UriParam(label="producer", defaultValue="30000")
    private long timeout = 30000L;

    public DirectVmEndpoint(String endpointUri, DirectVmComponent component) {
        super(endpointUri, component);
    }

    @Override
    public DirectVmComponent getComponent() {
        return (DirectVmComponent)super.getComponent();
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.block) {
            return new DirectVmBlockingProducer(this);
        }
        return new DirectVmProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        DirectVmConsumer answer = new DirectVmConsumer(this, (Processor)new DirectVmProcessor(processor, this));
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public DirectVmConsumer getConsumer() {
        return this.getComponent().getConsumer(this);
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

