/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.CamelContextHelper;

@UriEndpoint(scheme="ref", syntax="ref:name", label="core,endpoint")
public class RefEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private volatile Endpoint endpoint;
    @UriPath
    @Metadata(required="true")
    private String name;

    public RefEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Producer createProducer() throws Exception {
        return this.endpoint.createProducer();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return this.endpoint.createConsumer(processor);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        this.endpoint = CamelContextHelper.mandatoryLookup(this.getCamelContext(), this.name, Endpoint.class);
        this.getCamelContext().addService(this.endpoint);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }
}

