/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.scheduler.SchedulerComponent;
import org.apache.camel.component.scheduler.SchedulerConsumer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="scheduler", syntax="scheduler:name", consumerOnly=true, consumerClass=SchedulerConsumer.class, label="core,scheduling")
public class SchedulerEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam(defaultValue="1")
    private int concurrentTasks = 1;

    public SchedulerEndpoint(String uri, SchedulerComponent component, String remaining) {
        super(uri, component);
        this.name = remaining;
    }

    @Override
    public SchedulerComponent getComponent() {
        return (SchedulerComponent)super.getComponent();
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Scheduler cannot be used as a producer");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        SchedulerConsumer consumer = new SchedulerConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getConcurrentTasks() {
        return this.concurrentTasks;
    }

    public void setConcurrentTasks(int concurrentTasks) {
        this.concurrentTasks = concurrentTasks;
    }

    public void onConsumerStart(SchedulerConsumer consumer) {
        if (consumer.getScheduler() == null && consumer.getScheduledExecutorService() == null) {
            ScheduledExecutorService scheduler = this.getComponent().addConsumer(consumer);
            consumer.setScheduledExecutorService(scheduler);
        }
    }

    public void onConsumerStop(SchedulerConsumer consumer) {
        this.getComponent().removeConsumer(consumer);
    }
}

