/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="dataformat,transformation")
@XmlRootElement(name="zip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ZipDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="-1")
    private Integer compressionLevel;

    public ZipDataFormat() {
        super("zip");
    }

    public ZipDataFormat(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.compressionLevel == null) {
            return new org.apache.camel.impl.ZipDataFormat(-1);
        }
        return new org.apache.camel.impl.ZipDataFormat(this.compressionLevel);
    }

    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
    }
}

