/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="language")
@XmlRootElement(name="xpath")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XPathExpression
extends NamespaceAwareExpression {
    @XmlAttribute(name="documentType")
    private String documentTypeName;
    @XmlAttribute(name="resultType")
    private String resultTypeName;
    @XmlAttribute
    private Boolean saxon;
    @XmlAttribute
    private String factoryRef;
    @XmlAttribute
    private String objectModel;
    @XmlAttribute
    private Boolean logNamespaces;
    @XmlAttribute
    private String headerName;
    @XmlTransient
    private Class<?> documentType;
    @XmlTransient
    private Class<?> resultType;
    @XmlTransient
    private XPathFactory xpathFactory;

    public XPathExpression() {
    }

    public XPathExpression(String expression) {
        super(expression);
    }

    public XPathExpression(Expression expression) {
        this.setExpressionValue(expression);
    }

    @Override
    public String getLanguage() {
        return "xpath";
    }

    public Class<?> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class<?> documentType) {
        this.documentType = documentType;
    }

    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    public void setDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public void setSaxon(Boolean saxon) {
        this.saxon = saxon;
    }

    public Boolean getSaxon() {
        return this.saxon;
    }

    public void setFactoryRef(String factoryRef) {
        this.factoryRef = factoryRef;
    }

    public String getFactoryRef() {
        return this.factoryRef;
    }

    public void setObjectModel(String objectModel) {
        this.objectModel = objectModel;
    }

    public String getObjectModel() {
        return this.objectModel;
    }

    public void setLogNamespaces(Boolean logNamespaces) {
        this.logNamespaces = logNamespaces;
    }

    public Boolean getLogNamespaces() {
        return this.logNamespaces;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        if (this.documentType == null && this.documentTypeName != null) {
            try {
                this.documentType = camelContext.getClassResolver().resolveMandatoryClass(this.documentTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.resultType == null && this.resultTypeName != null) {
            try {
                this.resultType = camelContext.getClassResolver().resolveMandatoryClass(this.resultTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        this.resolveXPathFactory(camelContext);
        return super.createExpression(camelContext);
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        this.resolveXPathFactory(camelContext);
        return super.createPredicate(camelContext);
    }

    @Override
    protected void configureExpression(CamelContext camelContext, Expression expression) {
        boolean isLogNamespaces;
        boolean isSaxon = this.getSaxon() != null && this.getSaxon() != false;
        boolean bl = isLogNamespaces = this.getLogNamespaces() != null && this.getLogNamespaces() != false;
        if (this.documentType != null) {
            this.setProperty(expression, "documentType", this.documentType);
        }
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
        if (isSaxon) {
            ObjectHelper.cast(XPathBuilder.class, expression).enableSaxon();
        }
        if (this.xpathFactory != null) {
            this.setProperty(expression, "xPathFactory", this.xpathFactory);
        }
        if (this.objectModel != null) {
            this.setProperty(expression, "objectModelUri", this.objectModel);
        }
        if (isLogNamespaces) {
            ObjectHelper.cast(XPathBuilder.class, expression).setLogNamespaces(true);
        }
        if (ObjectHelper.isNotEmpty(this.getHeaderName())) {
            ObjectHelper.cast(XPathBuilder.class, expression).setHeaderName(this.getHeaderName());
        }
        super.configureExpression(camelContext, expression);
    }

    @Override
    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        boolean isLogNamespaces;
        boolean isSaxon = this.getSaxon() != null && this.getSaxon() != false;
        boolean bl = isLogNamespaces = this.getLogNamespaces() != null && this.getLogNamespaces() != false;
        if (this.documentType != null) {
            this.setProperty(predicate, "documentType", this.documentType);
        }
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
        if (isSaxon) {
            ObjectHelper.cast(XPathBuilder.class, predicate).enableSaxon();
        }
        if (this.xpathFactory != null) {
            this.setProperty(predicate, "xPathFactory", this.xpathFactory);
        }
        if (this.objectModel != null) {
            this.setProperty(predicate, "objectModelUri", this.objectModel);
        }
        if (isLogNamespaces) {
            ObjectHelper.cast(XPathBuilder.class, predicate).setLogNamespaces(true);
        }
        if (ObjectHelper.isNotEmpty(this.getHeaderName())) {
            ObjectHelper.cast(XPathBuilder.class, predicate).setHeaderName(this.getHeaderName());
        }
        super.configurePredicate(camelContext, predicate);
    }

    private void resolveXPathFactory(CamelContext camelContext) {
        if ((ObjectHelper.isNotEmpty(this.factoryRef) || ObjectHelper.isNotEmpty(this.objectModel)) && this.saxon != null) {
            throw new IllegalArgumentException("The saxon attribute cannot be set on the xpath element if any of the following is also set: factory, objectModel" + this);
        }
        if (ObjectHelper.isNotEmpty(this.factoryRef)) {
            this.xpathFactory = camelContext.getRegistry().lookupByNameAndType(this.factoryRef, XPathFactory.class);
            if (this.xpathFactory == null) {
                throw new IllegalArgumentException("The provided XPath Factory is invalid; either it cannot be resolved or it is not an XPathFactory instance");
            }
        }
    }
}

