/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.sf.flatpack.Parser;
import net.sf.flatpack.converter.Converter;
import net.sf.flatpack.converter.FPConvertException;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.FPException;
import net.sf.flatpack.xml.MetaData;
import net.sf.flatpack.xml.XMLRecordElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserUtils {
    private ParserUtils() {
    }

    public static List<String> splitLine(String line, char delimiter, char qualifier, int initialSize) {
        ArrayList<String> list = new ArrayList<String>(initialSize);
        if (delimiter == '\u0000') {
            list.add(line);
            return list;
        }
        if (line == null) {
            return list;
        }
        String trimmedLine = delimiter == '\t' || delimiter == ' ' ? line : line.trim();
        int size = trimmedLine.length();
        if (size == 0) {
            list.add("");
            return list;
        }
        boolean insideQualifier = false;
        char previousChar = '\u0000';
        int startBlock = 0;
        int endBlock = 0;
        boolean blockWasInQualifier = false;
        String doubleQualifier = "" + qualifier + qualifier;
        for (int i = 0; i < size; ++i) {
            char currentChar = trimmedLine.charAt(i);
            if (currentChar != delimiter && currentChar != qualifier) {
                previousChar = currentChar;
                endBlock = i + 1;
                continue;
            }
            if (currentChar == delimiter) {
                if (!insideQualifier) {
                    String trimmed = trimmedLine.substring(startBlock, endBlock > startBlock ? endBlock : startBlock + 1);
                    trimmed = !blockWasInQualifier ? trimmed.trim() : trimmed.replaceAll(doubleQualifier, String.valueOf(qualifier));
                    if (trimmed.length() == 1 && (trimmed.charAt(0) == delimiter || trimmed.charAt(0) == qualifier)) {
                        list.add("");
                    } else {
                        list.add(trimmed);
                    }
                    blockWasInQualifier = false;
                    startBlock = i + 1;
                }
            } else if (currentChar == qualifier) {
                if (!insideQualifier && previousChar != qualifier) {
                    if (previousChar == delimiter || previousChar == '\u0000' || previousChar == ' ') {
                        insideQualifier = true;
                        startBlock = i + 1;
                    } else {
                        endBlock = i + 1;
                    }
                } else {
                    if (i + 1 < size && delimiter != ' ') {
                        int start = i + 1;
                        char charToCheck = trimmedLine.charAt(start);
                        while (charToCheck == ' ' && ++start != size) {
                            charToCheck = trimmedLine.charAt(start);
                        }
                        if (charToCheck != delimiter) {
                            previousChar = currentChar;
                            endBlock = i + 1;
                            continue;
                        }
                    }
                    insideQualifier = false;
                    blockWasInQualifier = true;
                    endBlock = i;
                    if (i == size - 1) {
                        String str = trimmedLine.substring(startBlock, size - 1);
                        str = str.replaceAll(doubleQualifier, String.valueOf(qualifier));
                        list.add(str);
                        startBlock = i + 1;
                    }
                }
            }
            previousChar = currentChar;
        }
        if (startBlock < size) {
            String str = trimmedLine.substring(startBlock, size);
            str = str.replaceAll(doubleQualifier, String.valueOf(qualifier));
            if (blockWasInQualifier) {
                if (str.charAt(str.length() - 1) == qualifier) {
                    list.add(str.substring(0, str.length() - 1));
                } else {
                    list.add(str);
                }
            } else {
                list.add(str.trim());
            }
        } else if (trimmedLine.charAt(size - 1) == delimiter) {
            list.add("");
        }
        return list;
    }

    public static int getDelimiterOffset(String line, int start, char delimiter) {
        int idx = line.indexOf(delimiter, start);
        if (idx >= 0) {
            idx -= start - 1;
        }
        return idx;
    }

    public static String lTrim(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        int maxLength = value.length();
        for (offset = 0; offset < maxLength && (value.charAt(offset) == ' ' || value.charAt(offset) == '\t'); ++offset) {
        }
        if (offset > 0) {
            trimmed = value.substring(offset);
        }
        return trimmed;
    }

    public static String lTrimKeepTabs(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        int maxLength = value.length();
        for (offset = 0; offset < maxLength && value.charAt(offset) == ' '; ++offset) {
        }
        if (offset > 0) {
            trimmed = value.substring(offset);
        }
        return trimmed;
    }

    public static String rTrim(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        for (offset = value.length() - 1; offset > -1 && (value.charAt(offset) == ' ' || value.charAt(offset) == '\t'); --offset) {
        }
        if (offset < value.length() - 1) {
            trimmed = value.substring(0, offset + 1);
        }
        return trimmed;
    }

    public static String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        String ret = value.trim();
        return ret.length() == 0 ? null : ret;
    }

    public static String removeChar(char theChar, String theString) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < theString.length(); ++i) {
            char currentChar = theString.charAt(i);
            if (currentChar == theChar) continue;
            s.append(currentChar);
        }
        return s.toString();
    }

    public static MetaData getPZMetaDataFromFile(String line, char delimiter, char qualifier, Parser p) {
        ArrayList<ColumnMetaData> results = new ArrayList<ColumnMetaData>();
        HashSet<String> dupCheck = new HashSet<String>();
        List<String> lineData = ParserUtils.splitLine(line, delimiter, qualifier, 10);
        for (String colName : lineData) {
            ColumnMetaData cmd = new ColumnMetaData();
            cmd.setColName(colName);
            if (dupCheck.contains(cmd.getColName())) {
                throw new FPException("Duplicate Column Name In File: " + cmd.getColName());
            }
            results.add(cmd);
            dupCheck.add(cmd.getColName());
        }
        return new MetaData(results, ParserUtils.buidColumnIndexMap(results, p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnMetaData> getColumnMDFromFile(File theFile, String delimiter, String qualifier) throws IOException {
        BufferedReader br = null;
        FileReader fr = null;
        ArrayList<ColumnMetaData> results = new ArrayList<ColumnMetaData>();
        try {
            fr = new FileReader(theFile);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                List<String> lineData = ParserUtils.splitLine(line, delimiter.charAt(0), qualifier.charAt(0), 10);
                for (String colName : lineData) {
                    ColumnMetaData cmd = new ColumnMetaData();
                    cmd.setColName(colName);
                    results.add(cmd);
                }
                break;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
        return results;
    }

    public static boolean isMultiLine(char[] chrArry, char delimiter, char qualifier) {
        if (chrArry[chrArry.length - 1] != qualifier) {
            boolean qualiFound = false;
            block0: for (int i = chrArry.length - 1; i >= 0; --i) {
                if (chrArry[i] == ' ') continue;
                if (qualiFound) {
                    if (chrArry[i] == delimiter) {
                        return true;
                    }
                    qualiFound = chrArry[i] == qualifier;
                    continue;
                }
                if (chrArry[i] == delimiter) {
                    for (int j = i - 1; j >= 0; --j) {
                        if (chrArry[j] == ' ') continue;
                        if (chrArry[j] != qualifier) continue block0;
                        return false;
                    }
                    continue;
                }
                if (chrArry[i] != qualifier) continue;
                qualiFound = true;
            }
        } else {
            for (int i = chrArry.length - 1; i >= 0; --i) {
                if (i == chrArry.length - 1 || chrArry[i] == ' ') continue;
                if (chrArry[i] == delimiter) {
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static Map<String, Integer> calculateRecordLengths(MetaData columnMD) {
        HashMap<String, Integer> recordLengths = new HashMap<String, Integer>();
        int recordLength = 0;
        for (ColumnMetaData cmd : columnMD.getColumnsNames()) {
            recordLength += cmd.getColLength();
        }
        recordLengths.put("detail", recordLength);
        Iterator<Map.Entry<String, XMLRecordElement>> columnMDIt = columnMD.xmlRecordIterator();
        while (columnMDIt.hasNext()) {
            Map.Entry<String, XMLRecordElement> entry = columnMDIt.next();
            List<ColumnMetaData> cmds = entry.getValue().getColumns();
            recordLength = 0;
            for (ColumnMetaData cmd : cmds) {
                recordLength += cmd.getColLength();
            }
            recordLengths.put(entry.getKey(), recordLength);
        }
        return recordLengths;
    }

    public static String getCMDKeyForDelimitedFile(MetaData columnMD, List<String> lineElements) {
        if (!columnMD.isAnyRecordFormatSpecified()) {
            return "detail";
        }
        Iterator<Map.Entry<String, XMLRecordElement>> mapEntries = columnMD.xmlRecordIterator();
        while (mapEntries.hasNext()) {
            String lineElement;
            Map.Entry<String, XMLRecordElement> entry = mapEntries.next();
            XMLRecordElement recordXMLElement = entry.getValue();
            if (recordXMLElement.getElementCount() > 0 && recordXMLElement.getElementCount() == lineElements.size()) {
                return entry.getKey();
            }
            if (recordXMLElement.getElementNumber() > lineElements.size() || !(lineElement = lineElements.get(recordXMLElement.getElementNumber() - 1)).equals(recordXMLElement.getIndicator())) continue;
            return entry.getKey();
        }
        return "detail";
    }

    public static List<ColumnMetaData> getColumnMetaData(String key, MetaData columnMD) {
        if (key == null || key.equals("detail") || key.equals("colIndex")) {
            return columnMD.getColumnsNames();
        }
        return columnMD.getListColumnsForRecord(key);
    }

    public static int getColumnIndex(String key, MetaData columnMD, String colName, boolean columNameCaseSensitive) {
        int idx = -1;
        String column = colName;
        if (!columNameCaseSensitive) {
            column = colName.toLowerCase(Locale.getDefault());
        }
        if ((idx = columnMD.getColumnIndex(key, column)) < 0) {
            throw new NoSuchElementException("Column [" + column + "] does not exist, check case/spelling. key:" + key);
        }
        return idx;
    }

    public static InputStream createInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        return new FileInputStream(file);
    }

    public static void closeReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            throw new FPException(ex);
        }
    }

    public static void closeReader(InputStream reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            throw new FPException(ex);
        }
    }

    public static String padding(int repeat, char padChar) {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static Map<String, Integer> buidColumnIndexMap(List<ColumnMetaData> columns, Parser p) {
        HashMap<String, Integer> map = null;
        if (columns != null && !columns.isEmpty()) {
            map = new HashMap<String, Integer>();
            int idx = 0;
            for (ColumnMetaData meta : columns) {
                String colName = meta.getColName();
                if (p != null && !p.isColumnNamesCaseSensitive()) {
                    colName = colName.toLowerCase(Locale.getDefault());
                }
                map.put(colName, idx++);
            }
        }
        return map;
    }

    public static String stripNonLongChars(String value) {
        char c;
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < value.length() && (c = value.charAt(i)) != '.'; ++i) {
            if ((c < '0' || c > '9') && c != '-') continue;
            newString.append(c);
        }
        int sLen = newString.length();
        String s = newString.toString();
        if (sLen == 0 || sLen == 1 && "-".equals(s)) {
            return "0";
        }
        return newString.toString();
    }

    public static String stripNonDoubleChars(String value) {
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != '.') continue;
            newString.append(c);
        }
        int sLen = newString.length();
        String s = newString.toString();
        if (sLen == 0 || sLen == 1 && (".".equals(s) || "-".equals(s))) {
            return "0";
        }
        return newString.toString();
    }

    public static Properties loadConvertProperties() throws IOException {
        Properties pzConvertProps = new Properties();
        URL url = ParserUtils.class.getClassLoader().getResource("fpconvert.properties");
        pzConvertProps.load(url.openStream());
        return pzConvertProps;
    }

    public static boolean isListElementsEmpty(List<String> l) {
        for (String s : l) {
            if (s == null || s.trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Object runPzConverter(Properties classXref, String value, Class<?> typeToReturn) {
        String sConverter = classXref.getProperty(typeToReturn.getName());
        if (sConverter == null) {
            throw new FPConvertException(typeToReturn.getName() + " is not registered in pzconvert.properties");
        }
        try {
            Converter pzconverter = (Converter)Class.forName(sConverter).newInstance();
            return pzconverter.convertValue(value);
        }
        catch (IllegalAccessException ex) {
            throw new FPConvertException(ex);
        }
        catch (InstantiationException ex) {
            throw new FPConvertException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new FPConvertException(ex);
        }
    }

    public static List<ColumnMetaData> buildMDFromSQLTable(Connection con, String dataDefinition) throws SQLException {
        return ParserUtils.buildMDFromSQLTable(con, dataDefinition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnMetaData> buildMDFromSQLTable(Connection con, String dataDefinition, Parser parser) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<ColumnMetaData> cmds = new ArrayList<ColumnMetaData>();
        try {
            String dfTbl = parser != null ? parser.getDataFileTable() : "DATAFILE";
            String dsTbl = parser != null ? parser.getDataStructureTable() : "DATASTRUCTURE";
            StringBuilder sqlSb = new StringBuilder();
            sqlSb.append("SELECT * FROM ").append(dfTbl).append(" INNER JOIN ").append(dsTbl).append(" ON ").append(dfTbl).append(".DATAFILE_NO = ").append(dsTbl).append(".DATAFILE_NO WHERE DATAFILE_DESC = ? ORDER BY DATASTRUCTURE_COL_ORDER");
            stmt = con.prepareStatement(sqlSb.toString());
            stmt.setString(1, dataDefinition);
            rs = stmt.executeQuery();
            int recPosition = 1;
            while (rs.next()) {
                ColumnMetaData column = new ColumnMetaData();
                column.setColName(rs.getString("DATASTRUCTURE_COLUMN"));
                column.setColLength(rs.getInt("DATASTRUCTURE_LENGTH"));
                column.setStartPosition(recPosition);
                column.setEndPosition(recPosition + (rs.getInt("DATASTRUCTURE_LENGTH") - 1));
                recPosition += rs.getInt("DATASTRUCTURE_LENGTH");
                cmds.add(column);
            }
            if (cmds.isEmpty()) {
                throw new FPException("Data File Key [" + dataDefinition + "] Is Not In The database OR No Columns Specified In Table");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return cmds;
    }
}

