/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dozer.BaseConverter;
import org.apache.camel.component.dozer.CustomMapper;
import org.apache.camel.component.dozer.DozerConfiguration;
import org.apache.camel.component.dozer.DozerProducer;
import org.apache.camel.component.dozer.ExpressionMapper;
import org.apache.camel.component.dozer.VariableMapper;
import org.apache.camel.converter.dozer.DozerTypeConverterLoader;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.dozer.DozerBeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="dozer", syntax="dozer:name", producerOnly=true, label="transformation")
public class DozerEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DozerEndpoint.class);
    private static final String CUSTOM_MAPPING_ID = "_customMapping";
    private static final String VARIABLE_MAPPING_ID = "_variableMapping";
    private static final String EXPRESSION_MAPPING_ID = "_expressionMapping";
    private DozerBeanMapper mapper;
    private VariableMapper variableMapper;
    private CustomMapper customMapper;
    private ExpressionMapper expressionMapper;
    @UriParam
    private DozerConfiguration configuration;

    public DozerEndpoint(String endpointUri, Component component, DozerConfiguration configuration) throws Exception {
        super(endpointUri, component);
        this.configuration = configuration;
        this.variableMapper = new VariableMapper();
        this.customMapper = new CustomMapper(this.getCamelContext().getClassResolver());
        this.expressionMapper = new ExpressionMapper();
    }

    public Producer createProducer() throws Exception {
        return new DozerProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Dozer endpoints");
    }

    public boolean isSingleton() {
        return true;
    }

    public DozerBeanMapper getMapper() throws Exception {
        return this.mapper;
    }

    public DozerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DozerConfiguration configuration) {
        this.configuration = configuration;
    }

    CustomMapper getCustomMapper() {
        return this.customMapper;
    }

    VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    ExpressionMapper getExpressionMapper() {
        return this.expressionMapper;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.mapper == null) {
            this.mapper = this.configuration.getMappingConfiguration() != null ? DozerTypeConverterLoader.createDozerBeanMapper(this.configuration.getMappingConfiguration()) : this.createDozerBeanMapper();
            this.configureMapper(this.mapper);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DozerBeanMapper createDozerBeanMapper() throws Exception {
        DozerBeanMapper answer = new DozerBeanMapper();
        InputStream mapStream = null;
        try {
            LOG.info("Loading Dozer mapping file {}.", (Object)this.configuration.getMappingFile());
            mapStream = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.configuration.getMappingFile());
            answer.addMapping(mapStream);
        }
        catch (Throwable throwable) {
            IOHelper.close(mapStream);
            throw throwable;
        }
        IOHelper.close((Closeable)mapStream);
        return answer;
    }

    private void configureMapper(DozerBeanMapper mapper) throws Exception {
        HashMap<String, BaseConverter> converters = new HashMap<String, BaseConverter>();
        converters.put(CUSTOM_MAPPING_ID, this.customMapper);
        converters.put(VARIABLE_MAPPING_ID, this.variableMapper);
        converters.put(EXPRESSION_MAPPING_ID, this.expressionMapper);
        converters.putAll(mapper.getCustomConvertersWithId());
        mapper.setCustomConvertersWithId(converters);
    }
}

