/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactoryComponentManager<S>
extends SingleComponentManager<S> {
    private IdentityHashMap<S, ComponentContextImpl> serviceContexts = new IdentityHashMap();

    public ServiceFactoryComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
        super(activator, componentHolder, metadata, componentMethods);
    }

    @Override
    protected boolean createComponent() {
        return true;
    }

    @Override
    protected void deleteComponent(int reason) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        for (ComponentContextImpl componentContext : this.getComponentContexts()) {
            this.disposeImplementationObject(componentContext, reason);
            this.log(4, "Unset implementation object for component {0} in deleteComponent for reason {1}", new Object[]{this.getName(), REASONS[reason]}, null);
        }
        this.serviceContexts.clear();
        this.clearServiceProperties();
    }

    @Override
    S getInstance() {
        return null;
    }

    @Override
    public S getService(Bundle bundle, ServiceRegistration<S> registration) {
        this.log(4, "ServiceFactory.getService()", null);
        try {
            if (!this.collectDependencies()) {
                this.log(4, "getService (ServiceFactory) did not win collecting dependencies, try creating object anyway.", null);
            } else {
                this.log(4, "getService (ServiceFactory) won collecting dependencies, proceed to creating object.", null);
            }
        }
        catch (IllegalStateException e) {
            return null;
        }
        Object service = this.createImplementationObject(bundle, new SingleComponentManager.SetImplementationObject<S>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void presetComponentContext(ComponentContextImpl<S> componentContext) {
                IdentityHashMap identityHashMap = ServiceFactoryComponentManager.this.serviceContexts;
                synchronized (identityHashMap) {
                    ServiceFactoryComponentManager.this.serviceContexts.put(componentContext.getImplementationObject(false), componentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetImplementationObject(S implementationObject) {
                IdentityHashMap identityHashMap = ServiceFactoryComponentManager.this.serviceContexts;
                synchronized (identityHashMap) {
                    ServiceFactoryComponentManager.this.serviceContexts.remove(implementationObject);
                }
            }
        });
        if (service == null) {
            this.log(1, "Failed creating the component instance; see log for reason", null);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<S> registration, S service) {
        ComponentContextImpl serviceContext;
        this.log(4, "ServiceFactory.ungetService()", null);
        IdentityHashMap<S, ComponentContextImpl> identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            serviceContext = this.serviceContexts.get(service);
        }
        this.disposeImplementationObject(serviceContext, 5);
        identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            this.serviceContexts.remove(service);
            if (this.serviceContexts.isEmpty() && this.getState() == 16) {
                this.unsetDependenciesCollected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ComponentContextImpl> getComponentContexts() {
        IdentityHashMap<S, ComponentContextImpl> identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            return new ArrayList<ComponentContextImpl>(this.serviceContexts.values());
        }
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<T> refPair, int trackingCount) {
        for (ComponentContextImpl cc : this.getComponentContexts()) {
            dependencyManager.invokeBindMethod(cc.getImplementationObject(false), refPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    <T> void invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<T> refPair, int trackingCount) {
        for (ComponentContextImpl cc : this.getComponentContexts()) {
            dependencyManager.invokeUpdatedMethod(cc.getImplementationObject(false), refPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<T> oldRefPair, int trackingCount) {
        for (ComponentContextImpl cc : this.getComponentContexts()) {
            dependencyManager.invokeUnbindMethod(cc.getImplementationObject(false), oldRefPair, trackingCount, cc.getEdgeInfo(dependencyManager));
        }
    }

    @Override
    protected MethodResult invokeModifiedMethod() {
        ModifiedMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        MethodResult result = MethodResult.VOID;
        for (ComponentContextImpl componentContext : this.getComponentContexts()) {
            Object instance = componentContext.getImplementationObject(true);
            result = modifiedMethod.invoke(instance, new ActivateMethod.ActivatorParameter(componentContext, -1), MethodResult.VOID, this);
        }
        return result;
    }

    @Override
    boolean hasInstance() {
        return !this.serviceContexts.isEmpty();
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return super.getComponentInstance();
    }
}

