/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.component.lucene.LuceneIndexProducer;
import org.apache.camel.component.lucene.LuceneIndexer;
import org.apache.camel.component.lucene.LuceneQueryProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="lucene", syntax="lucene:host:operation", producerOnly=true, label="database,search")
public class LuceneEndpoint
extends DefaultEndpoint {
    @UriParam
    LuceneConfiguration config;
    LuceneIndexer indexer;
    boolean insertFlag;

    public LuceneEndpoint() {
    }

    public LuceneEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
    }

    public LuceneEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LuceneEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public LuceneEndpoint(String endpointUri, LuceneComponent component, LuceneConfiguration config) throws Exception {
        this(endpointUri, (Component)component);
        this.config = config;
        if (config.getOperation().equalsIgnoreCase("insert")) {
            this.indexer = new LuceneIndexer(config.getSourceDirectory(), config.getIndexDirectory(), config.getAnalyzer());
            this.insertFlag = true;
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Lucene endpoint");
    }

    public Producer createProducer() throws Exception {
        if (!this.insertFlag) {
            return new LuceneQueryProducer((Endpoint)this, this.config);
        }
        return new LuceneIndexProducer((Endpoint)this, this.config, this.indexer);
    }

    public LuceneConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(LuceneConfiguration config) {
        this.config = config;
    }

    public boolean isSingleton() {
        return true;
    }
}

