/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jmx.JMXComponent;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.component.jmx.JMXMonitorConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="jmx", syntax="jmx:serverURL", consumerOnly=true, consumerClass=JMXConsumer.class, label="monitoring")
public class JMXEndpoint
extends DefaultEndpoint {
    protected static final String ERR_PLATFORM_SERVER = "Monitor type consumer only supported on platform server.";
    protected static final String ERR_THRESHOLD_LOW = "ThresholdLow must be set when monitoring a gauge attribute.";
    protected static final String ERR_THRESHOLD_HIGH = "ThresholdHigh must be set when monitoring a gauge attribute.";
    protected static final String ERR_GAUGE_NOTIFY = "One or both of NotifyHigh and NotifyLow must be true when monitoring a gauge attribute.";
    protected static final String ERR_STRING_NOTIFY = "One or both of NotifyDiffer and NotifyMatch must be true when monitoring a string attribute.";
    protected static final String ERR_STRING_TO_COMPARE = "StringToCompare must be specified when monitoring a string attribute.";
    protected static final String ERR_OBSERVED_ATTRIBUTE = "Observed attribute must be specified";
    @UriPath
    private String serverURL;
    @UriParam
    private String observedAttribute;
    @UriParam
    private long granularityPeriod;
    @UriParam
    private String monitorType;
    @UriParam
    private int initThreshold;
    @UriParam
    private int offset;
    @UriParam
    private int modulus;
    @UriParam
    private boolean differenceMode;
    @UriParam
    private boolean notifyHigh;
    @UriParam
    private boolean notifyLow;
    @UriParam
    private Double thresholdHigh;
    @UriParam
    private Double thresholdLow;
    @UriParam
    private boolean notifyDiffer;
    @UriParam
    private boolean notifyMatch;
    @UriParam
    private String stringToCompare;
    @UriParam(defaultValue="xml")
    private String format = "xml";
    @UriParam
    private String user;
    @UriParam
    private String password;
    @UriParam
    private String objectDomain;
    @UriParam
    private String objectName;
    @UriParam
    private NotificationFilter notificationFilter;
    @UriParam
    private Object handback;
    @UriParam(defaultValue="true")
    private boolean testConnectionOnStartup = true;
    @UriParam
    private boolean reconnectOnConnectionFailure;
    @UriParam(defaultValue="10")
    private int reconnectDelay = 10;
    private Hashtable<String, String> objectProperties;
    private transient ObjectName jmxObjectName;

    public JMXEndpoint(String aEndpointUri, JMXComponent aComponent) {
        super(aEndpointUri, (Component)aComponent);
    }

    public Consumer createConsumer(Processor aProcessor) throws Exception {
        if (this.getMonitorType() != null) {
            if (!this.isPlatformServer()) {
                throw new IllegalArgumentException(ERR_PLATFORM_SERVER);
            }
            if (ObjectHelper.isEmpty((Object)this.getObservedAttribute())) {
                throw new IllegalArgumentException(ERR_OBSERVED_ATTRIBUTE);
            }
            if (this.getMonitorType().equals("string")) {
                if (ObjectHelper.isEmpty((Object)this.getStringToCompare())) {
                    throw new IllegalArgumentException(ERR_STRING_TO_COMPARE);
                }
                if (!this.isNotifyDiffer() && !this.isNotifyMatch()) {
                    throw new IllegalArgumentException(ERR_STRING_NOTIFY);
                }
            } else if (this.getMonitorType().equals("gauge")) {
                if (!this.isNotifyHigh() && !this.isNotifyLow()) {
                    throw new IllegalArgumentException(ERR_GAUGE_NOTIFY);
                }
                if (this.getThresholdHigh() == null) {
                    throw new IllegalArgumentException(ERR_THRESHOLD_HIGH);
                }
                if (this.getThresholdLow() == null) {
                    throw new IllegalArgumentException(ERR_THRESHOLD_LOW);
                }
            }
            JMXMonitorConsumer answer = new JMXMonitorConsumer(this, aProcessor);
            this.configureConsumer((Consumer)answer);
            return answer;
        }
        JMXConsumer answer = new JMXConsumer(this, aProcessor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("producing JMX notifications is not supported");
    }

    public boolean isSingleton() {
        return false;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String aFormat) {
        this.format = aFormat;
    }

    public boolean isXML() {
        return "xml".equals(this.getFormat());
    }

    public boolean isPlatformServer() {
        return "platform".equals(this.getServerURL());
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String aUser) {
        this.user = aUser;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    public String getObjectDomain() {
        return this.objectDomain;
    }

    public void setObjectDomain(String aObjectDomain) {
        this.objectDomain = aObjectDomain;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String aObjectName) {
        if (this.getObjectProperties() != null) {
            throw new IllegalArgumentException("Cannot set both objectName and objectProperties");
        }
        this.objectName = aObjectName;
    }

    protected String getServerURL() {
        return this.serverURL;
    }

    protected void setServerURL(String aServerURL) {
        this.serverURL = aServerURL;
    }

    public NotificationFilter getNotificationFilter() {
        return this.notificationFilter;
    }

    public void setNotificationFilter(NotificationFilter aFilterRef) {
        this.notificationFilter = aFilterRef;
    }

    public Object getHandback() {
        return this.handback;
    }

    public void setHandback(Object aHandback) {
        this.handback = aHandback;
    }

    public Hashtable<String, String> getObjectProperties() {
        return this.objectProperties;
    }

    public void setObjectProperties(Hashtable<String, String> aObjectProperties) {
        if (this.getObjectName() != null) {
            throw new IllegalArgumentException("Cannot set both objectName and objectProperties");
        }
        this.objectProperties = aObjectProperties;
    }

    protected ObjectName getJMXObjectName() throws MalformedObjectNameException {
        if (this.jmxObjectName == null) {
            ObjectName on = this.buildObjectName();
            this.setJMXObjectName(on);
        }
        return this.jmxObjectName;
    }

    protected void setJMXObjectName(ObjectName aCachedObjectName) {
        this.jmxObjectName = aCachedObjectName;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    public void setObservedAttribute(String aObservedAttribute) {
        this.observedAttribute = aObservedAttribute;
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long aGranularityPeriod) {
        this.granularityPeriod = aGranularityPeriod;
    }

    public String getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(String aMonitorType) {
        this.monitorType = aMonitorType;
    }

    public int getInitThreshold() {
        return this.initThreshold;
    }

    public void setInitThreshold(int aInitThreshold) {
        this.initThreshold = aInitThreshold;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int aOffset) {
        this.offset = aOffset;
    }

    public int getModulus() {
        return this.modulus;
    }

    public void setModulus(int aModulus) {
        this.modulus = aModulus;
    }

    public boolean isDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean aDifferenceMode) {
        this.differenceMode = aDifferenceMode;
    }

    public boolean isNotifyHigh() {
        return this.notifyHigh;
    }

    public void setNotifyHigh(boolean aNotifyHigh) {
        this.notifyHigh = aNotifyHigh;
    }

    public boolean isNotifyLow() {
        return this.notifyLow;
    }

    public void setNotifyLow(boolean aNotifyLow) {
        this.notifyLow = aNotifyLow;
    }

    public Double getThresholdHigh() {
        return this.thresholdHigh;
    }

    public void setThresholdHigh(Double aThresholdHigh) {
        this.thresholdHigh = aThresholdHigh;
    }

    public Double getThresholdLow() {
        return this.thresholdLow;
    }

    public void setThresholdLow(Double aThresholdLow) {
        this.thresholdLow = aThresholdLow;
    }

    public boolean isNotifyDiffer() {
        return this.notifyDiffer;
    }

    public void setNotifyDiffer(boolean aNotifyDiffer) {
        this.notifyDiffer = aNotifyDiffer;
    }

    public boolean isNotifyMatch() {
        return this.notifyMatch;
    }

    public void setNotifyMatch(boolean aNotifyMatch) {
        this.notifyMatch = aNotifyMatch;
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    public void setStringToCompare(String aStringToCompare) {
        this.stringToCompare = aStringToCompare;
    }

    public boolean getTestConnectionOnStartup() {
        return this.testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public boolean getReconnectOnConnectionFailure() {
        return this.reconnectOnConnectionFailure;
    }

    public void setReconnectOnConnectionFailure(boolean reconnectOnConnectionFailure) {
        this.reconnectOnConnectionFailure = reconnectOnConnectionFailure;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    private ObjectName buildObjectName() throws MalformedObjectNameException {
        ObjectName objectName;
        if (this.getObjectProperties() == null) {
            StringBuilder sb = new StringBuilder(this.getObjectDomain()).append(':').append("name=").append(this.getObjectName());
            objectName = new ObjectName(sb.toString());
        } else {
            objectName = new ObjectName(this.getObjectDomain(), this.getObjectProperties());
        }
        return objectName;
    }
}

