/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.gravia.repository.Namespace100;
import org.jboss.gravia.repository.RepositoryReader;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.spi.AttributeValueHandler;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;

public abstract class AbstractRepositoryXMLReader
implements RepositoryReader {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final XMLStreamReader reader;

    public AbstractRepositoryXMLReader(InputStream inputStream) {
        IllegalArgumentAssertion.assertNotNull((Object)inputStream, (String)"inputStream");
        this.reader = this.createXMLStreamReader(inputStream);
        try {
            this.reader.require(7, null, null);
            this.reader.nextTag();
            this.reader.require(1, "http://www.osgi.org/xmlns/repository/v1.0.0", Namespace100.Element.REPOSITORY.getLocalName());
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                this.attributes.put(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot read resource element: " + this.reader.getLocation(), ex);
        }
    }

    protected abstract XMLStreamReader createXMLStreamReader(InputStream var1);

    protected abstract ResourceBuilder createResourceBuilder();

    @Override
    public Map<String, String> getRepositoryAttributes() {
        return this.attributes;
    }

    @Override
    public Resource nextResource() {
        try {
            return AbstractRepositoryXMLReader.nextResource(this.reader, this.createResourceBuilder());
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Cannot read resource element: " + this.reader.getLocation(), ex);
        }
    }

    public static Resource nextResource(XMLStreamReader reader, ResourceBuilder builder) throws XMLStreamException {
        if (!reader.hasNext() || reader.nextTag() == 2) {
            return null;
        }
        Namespace100.Element element = Namespace100.Element.forName(reader.getLocalName());
        IllegalStateAssertion.assertEquals((Object)((Object)Namespace100.Element.RESOURCE), (Object)((Object)element), (String)("Expected resource element, but got: " + (Object)((Object)element)));
        block4: while (reader.hasNext() && reader.nextTag() == 1) {
            element = Namespace100.Element.forName(reader.getLocalName());
            switch (element) {
                case CAPABILITY: {
                    AbstractRepositoryXMLReader.readCapability(reader, builder);
                    continue block4;
                }
                case REQUIREMENT: {
                    AbstractRepositoryXMLReader.readRequirement(reader, builder);
                    continue block4;
                }
            }
        }
        AbstractRepositoryXMLReader.assertEndElement(reader, Namespace100.Element.RESOURCE.getLocalName());
        return builder.getResource();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private static Capability readCapability(XMLStreamReader reader, ResourceBuilder builder) throws XMLStreamException {
        String namespace = reader.getAttributeValue(null, Namespace100.Attribute.NAMESPACE.toString());
        HashMap<String, Object> atts = new HashMap<String, Object>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        AbstractRepositoryXMLReader.readAttributesAndDirectives(reader, atts, dirs);
        AbstractRepositoryXMLReader.assertEndElement(reader, Namespace100.Element.CAPABILITY.getLocalName());
        return builder.addCapability(namespace, atts, dirs);
    }

    private static Requirement readRequirement(XMLStreamReader reader, ResourceBuilder builder) throws XMLStreamException {
        String namespace = reader.getAttributeValue(null, Namespace100.Attribute.NAMESPACE.toString());
        HashMap<String, Object> atts = new HashMap<String, Object>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        AbstractRepositoryXMLReader.readAttributesAndDirectives(reader, atts, dirs);
        AbstractRepositoryXMLReader.assertEndElement(reader, Namespace100.Element.REQUIREMENT.getLocalName());
        return builder.addRequirement(namespace, atts, dirs);
    }

    public static void readAttributesAndDirectives(XMLStreamReader reader, Map<String, Object> atts, Map<String, String> dirs) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() == 1) {
            Namespace100.Element element = Namespace100.Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE: {
                    AbstractRepositoryXMLReader.readAttributeElement(reader, atts);
                    continue block4;
                }
                case DIRECTIVE: {
                    AbstractRepositoryXMLReader.readDirectiveElement(reader, dirs);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported element: " + reader.getLocalName());
        }
    }

    private static void readAttributeElement(XMLStreamReader reader, Map<String, Object> attributes) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Namespace100.Attribute.NAME.toString());
        String valstr = reader.getAttributeValue(null, Namespace100.Attribute.VALUE.toString());
        String typespec = reader.getAttributeValue(null, Namespace100.Attribute.TYPE.toString());
        AttributeValueHandler.AttributeValue value = AttributeValueHandler.readAttributeValue((String)name, (String)typespec, (String)valstr);
        attributes.put(name, value.getValue());
        AbstractRepositoryXMLReader.assertEndElement(reader, Namespace100.Element.ATTRIBUTE.getLocalName());
    }

    private static void readDirectiveElement(XMLStreamReader reader, Map<String, String> directives) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Namespace100.Attribute.NAME.toString());
        String value = reader.getAttributeValue(null, Namespace100.Attribute.VALUE.toString());
        directives.put(name, value);
        AbstractRepositoryXMLReader.assertEndElement(reader, Namespace100.Element.DIRECTIVE.getLocalName());
    }

    public static void assertEndElement(XMLStreamReader reader, String localName) throws XMLStreamException {
        if (reader.getEventType() != 2 || !localName.equals(reader.getLocalName())) {
            IllegalStateAssertion.assertEquals((Object)2, (Object)reader.nextTag(), (String)("End of <" + localName + "> expected, but was start of: " + reader.getLocalName()));
            IllegalStateAssertion.assertEquals((Object)localName, (Object)reader.getLocalName(), (String)("End of <" + localName + "> expected, but was end of: " + reader.getLocalName()));
        }
    }
}

