/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.PGPPublicKeyAccessor;
import org.apache.camel.converter.crypto.PGPSecretKeyAccessor;
import org.apache.camel.converter.crypto.PGPSecretKeyAndPrivateKeyAndUserId;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPKeyAccessDataFormat
extends ServiceSupport
implements DataFormat {
    public static final String KEY_USERID = "CamelPGPDataFormatKeyUserid";
    public static final String KEY_USERIDS = "CamelPGPDataFormatKeyUserids";
    public static final String SIGNATURE_KEY_USERID = "CamelPGPDataFormatSignatureKeyUserid";
    public static final String SIGNATURE_KEY_USERIDS = "CamelPGPDataFormatSignatureKeyUserids";
    public static final String ENCRYPTION_ALGORITHM = "CamelPGPDataFormatEncryptionAlgorithm";
    public static final String SIGNATURE_HASH_ALGORITHM = "CamelPGPDataFormatSignatureHashAlgorithm";
    public static final String COMPRESSION_ALGORITHM = "CamelPGPDataFormatCompressionAlgorithm";
    public static final String SIGNATURE_VERIFICATION_OPTION_OPTIONAL = "optional";
    public static final String SIGNATURE_VERIFICATION_OPTION_REQUIRED = "required";
    public static final String SIGNATURE_VERIFICATION_OPTION_IGNORE = "ignore";
    public static final String SIGNATURE_VERIFICATION_OPTION_NO_SIGNATURE_ALLOWED = "no_signature_allowed";
    public static final String NUMBER_OF_ENCRYPTION_KEYS = "CamelPGPDataFormatNumberOfEncryptionKeys";
    public static final String NUMBER_OF_SIGNING_KEYS = "CamelPGPDataFormatNumberOfSigningKeys";
    private static final Logger LOG = LoggerFactory.getLogger(PGPKeyAccessDataFormat.class);
    private static final List<String> SIGNATURE_VERIFICATION_OPTIONS = Arrays.asList("optional", "required", "ignore", "no_signature_allowed");
    private static final String BC = "BC";
    private static final int BUFFER_SIZE = 16384;
    PGPPublicKeyAccessor publicKeyAccessor;
    PGPSecretKeyAccessor secretKeyAccessor;
    private String provider = "BC";
    private String keyUserid;
    private List<String> keyUserids;
    private String signatureKeyUserid;
    private List<String> signatureKeyUserids;
    private boolean armored;
    private boolean integrity = true;
    private int hashAlgorithm = 2;
    private int algorithm = 3;
    private int compressionAlgorithm = 1;
    private String signatureVerificationOption = "optional";
    private String fileName = "_CONSOLE";

    protected String findKeyUserid(Exchange exchange) {
        return (String)exchange.getIn().getHeader(KEY_USERID, (Object)this.getKeyUserid(), String.class);
    }

    protected List<String> findKeyUserids(Exchange exchange) {
        return (List)exchange.getIn().getHeader(KEY_USERIDS, this.getKeyUserids(), List.class);
    }

    protected String findSignatureKeyUserid(Exchange exchange) {
        return (String)exchange.getIn().getHeader(SIGNATURE_KEY_USERID, (Object)this.getSignatureKeyUserid(), String.class);
    }

    protected List<String> findSignatureKeyUserids(Exchange exchange) {
        return (List)exchange.getIn().getHeader(SIGNATURE_KEY_USERIDS, this.getSignatureKeyUserids(), List.class);
    }

    protected int findCompressionAlgorithm(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader(COMPRESSION_ALGORITHM, (Object)this.getCompressionAlgorithm(), Integer.class);
    }

    protected int findAlgorithm(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader(ENCRYPTION_ALGORITHM, (Object)this.getAlgorithm(), Integer.class);
    }

    protected int findHashAlgorithm(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader(SIGNATURE_HASH_ALGORITHM, (Object)this.getHashAlgorithm(), Integer.class);
    }

    protected String findFileName(Exchange exchange) {
        return (String)exchange.getIn().getHeader("CamelFileName", (Object)this.getFileName(), String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        List<String> userids = this.determineEncryptionUserIds(exchange);
        List<PGPPublicKey> keys = this.publicKeyAccessor.getEncryptionKeys(exchange, userids);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot PGP encrypt message. No public encryption key found for the User Ids " + userids + " in the public keyring. Either specify other User IDs or add correct public keys to the keyring.");
        }
        exchange.getOut().setHeader(NUMBER_OF_ENCRYPTION_KEYS, (Object)keys.size());
        InputStream input = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)graph);
        if (this.armored) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(this.findAlgorithm(exchange)).setWithIntegrityPacket(this.integrity).setSecureRandom(new SecureRandom()).setProvider(this.getProvider()));
        for (PGPPublicKey key : keys) {
            encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(key));
        }
        OutputStream encOut = encGen.open(outputStream, new byte[16384]);
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(this.findCompressionAlgorithm(exchange));
        BufferedOutputStream comOut = new BufferedOutputStream(comData.open(encOut));
        List<PGPSignatureGenerator> sigGens = this.createSignatureGenerator(exchange, comOut);
        PGPLiteralDataGenerator litData = new PGPLiteralDataGenerator();
        String fileName = this.findFileName(exchange);
        OutputStream litOut = litData.open((OutputStream)comOut, 'b', fileName, new Date(), new byte[16384]);
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = input.read(buffer)) != -1) {
                litOut.write(buffer, 0, bytesRead);
                if (sigGens != null && !sigGens.isEmpty()) {
                    for (PGPSignatureGenerator sigGen : sigGens) {
                        sigGen.update(buffer, 0, bytesRead);
                    }
                }
                litOut.flush();
            }
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable)litOut);
            if (sigGens != null && !sigGens.isEmpty()) {
                for (int i = sigGens.size() - 1; i > -1; --i) {
                    PGPSignatureGenerator sigGen = sigGens.get(i);
                    sigGen.generate().encode((OutputStream)comOut);
                }
            }
            IOHelper.close((Closeable[])new Closeable[]{comOut, encOut, outputStream, input});
            throw throwable;
        }
        IOHelper.close((Closeable)litOut);
        if (sigGens != null && !sigGens.isEmpty()) {
            for (int i = sigGens.size() - 1; i > -1; --i) {
                PGPSignatureGenerator sigGen = sigGens.get(i);
                sigGen.generate().encode((OutputStream)comOut);
            }
        }
        IOHelper.close((Closeable[])new Closeable[]{comOut, encOut, outputStream, input});
    }

    protected List<String> determineEncryptionUserIds(Exchange exchange) {
        List<String> result;
        String userid = this.findKeyUserid(exchange);
        List<String> userids = this.findKeyUserids(exchange);
        if (userid != null) {
            if (userids == null || userids.isEmpty()) {
                result = Collections.singletonList(userid);
            } else {
                result = new ArrayList<String>(userids.size() + 1);
                result.add(userid);
                result.addAll(userids);
            }
        } else {
            if (userids == null || userids.isEmpty()) {
                throw new IllegalStateException("Cannot PGP encrypt message. No User ID of the public key specified.");
            }
            result = userids;
        }
        return result;
    }

    protected List<String> determineSignaturenUserIds(Exchange exchange) {
        List<String> result;
        String userid = this.findSignatureKeyUserid(exchange);
        List<String> userids = this.findSignatureKeyUserids(exchange);
        if (userid != null) {
            if (userids == null || userids.isEmpty()) {
                result = Collections.singletonList(userid);
            } else {
                result = new ArrayList<String>(userids.size() + 1);
                result.add(userid);
                result.addAll(userids);
            }
        } else {
            result = userids;
        }
        return result;
    }

    protected List<PGPSignatureGenerator> createSignatureGenerator(Exchange exchange, OutputStream out) throws Exception {
        if (this.secretKeyAccessor == null) {
            return null;
        }
        List<String> sigKeyUserids = this.determineSignaturenUserIds(exchange);
        List<PGPSecretKeyAndPrivateKeyAndUserId> sigSecretKeysWithPrivateKeyAndUserId = this.secretKeyAccessor.getSignerKeys(exchange, sigKeyUserids);
        if (sigSecretKeysWithPrivateKeyAndUserId.isEmpty()) {
            return null;
        }
        exchange.getOut().setHeader(NUMBER_OF_SIGNING_KEYS, (Object)sigSecretKeysWithPrivateKeyAndUserId.size());
        ArrayList<PGPSignatureGenerator> sigGens = new ArrayList<PGPSignatureGenerator>();
        for (PGPSecretKeyAndPrivateKeyAndUserId sigSecretKeyWithPrivateKeyAndUserId : sigSecretKeysWithPrivateKeyAndUserId) {
            PGPPrivateKey sigPrivateKey = sigSecretKeyWithPrivateKeyAndUserId.getPrivateKey();
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, sigSecretKeyWithPrivateKeyAndUserId.getUserId());
            int algorithm = sigSecretKeyWithPrivateKeyAndUserId.getSecretKey().getPublicKey().getAlgorithm();
            PGPSignatureGenerator sigGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(algorithm, this.findHashAlgorithm(exchange)).setProvider(this.getProvider()));
            sigGen.init(0, sigPrivateKey);
            sigGen.setHashedSubpackets(spGen.generate());
            sigGen.generateOnePassVersion(false).encode(out);
            sigGens.add(sigGen);
        }
        return sigGens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream encryptedStream) throws Exception {
        ByteArrayOutputStream bos;
        CachedOutputStream cos;
        if (encryptedStream == null) {
            return null;
        }
        InputStream in = null;
        InputStream encData = null;
        InputStream uncompressedData = null;
        InputStream litData = null;
        ByteArrayOutputStream os = null;
        try {
            int bytesRead;
            PGPOnePassSignature signature;
            in = PGPUtil.getDecoderStream((InputStream)encryptedStream);
            encData = this.getDecryptedData(exchange, in);
            uncompressedData = this.getUncompressedData(encData);
            PGPObjectFactory pgpFactory = new PGPObjectFactory(uncompressedData);
            Object object = pgpFactory.nextObject();
            if (object instanceof PGPOnePassSignatureList) {
                signature = this.getSignature(exchange, (PGPOnePassSignatureList)object);
                object = pgpFactory.nextObject();
            } else {
                signature = null;
                if (SIGNATURE_VERIFICATION_OPTION_REQUIRED.equals(this.getSignatureVerificationOption())) {
                    throw new PGPException("PGP message does not contain any signatures although a signature is expected. Either send a PGP message with signature or change the configuration of the PGP decryptor.");
                }
            }
            if (!(object instanceof PGPLiteralData)) {
                throw this.getFormatException();
            }
            PGPLiteralData ld = (PGPLiteralData)object;
            litData = ld.getInputStream();
            if (exchange.getContext().getStreamCachingStrategy().isEnabled()) {
                cos = new CachedOutputStream(exchange);
                bos = null;
                os = cos;
            } else {
                cos = null;
                os = bos = new ByteArrayOutputStream();
            }
            byte[] buffer = new byte[16384];
            while ((bytesRead = litData.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
                if (signature != null) {
                    signature.update(buffer, 0, bytesRead);
                }
                os.flush();
            }
            this.verifySignature(pgpFactory, signature);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{os, litData, uncompressedData, encData, in, encryptedStream});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{os, litData, uncompressedData, encData, in, encryptedStream});
        if (cos != null) {
            return cos.newStreamCache();
        }
        return bos.toByteArray();
    }

    private InputStream getUncompressedData(InputStream encData) throws IOException, PGPException {
        PGPObjectFactory pgpFactory = new PGPObjectFactory(encData);
        Object compObj = pgpFactory.nextObject();
        if (!(compObj instanceof PGPCompressedData)) {
            throw this.getFormatException();
        }
        PGPCompressedData comData = (PGPCompressedData)compObj;
        InputStream uncompressedData = comData.getDataStream();
        return uncompressedData;
    }

    private InputStream getDecryptedData(Exchange exchange, InputStream encryptedStream) throws Exception, PGPException {
        PGPObjectFactory pgpFactory = new PGPObjectFactory(encryptedStream);
        Object firstObject = pgpFactory.nextObject();
        PGPEncryptedDataList enc = this.getEcryptedDataList(pgpFactory, firstObject);
        if (enc == null) {
            throw this.getFormatException();
        }
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey key = null;
        for (int i = 0; i < enc.size() && key == null; ++i) {
            Object encryptedData = enc.get(i);
            if (!(encryptedData instanceof PGPPublicKeyEncryptedData)) {
                throw this.getFormatException();
            }
            pbe = (PGPPublicKeyEncryptedData)encryptedData;
            key = this.secretKeyAccessor.getPrivateKey(exchange, pbe.getKeyID());
            if (key != null) break;
        }
        if (key == null) {
            throw new PGPException("PGP message is encrypted with a key which could not be found in the Secret Keyring.");
        }
        InputStream encData = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(this.getProvider()).build(key));
        return encData;
    }

    private PGPEncryptedDataList getEcryptedDataList(PGPObjectFactory pgpFactory, Object firstObject) throws IOException {
        Object secondObject;
        Object enc = firstObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)firstObject : ((secondObject = pgpFactory.nextObject()) instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)secondObject : null);
        return enc;
    }

    private void verifySignature(PGPObjectFactory pgpFactory, PGPOnePassSignature signature) throws IOException, PGPException, SignatureException {
        if (signature != null) {
            PGPSignatureList sigList = (PGPSignatureList)pgpFactory.nextObject();
            if (!signature.verify(this.getSignatureWithKeyId(signature.getKeyID(), sigList))) {
                throw new SignatureException("Verification of the PGP signature with the key ID " + signature.getKeyID() + " failed. The PGP message may have been tampered.");
            }
        }
    }

    private IllegalArgumentException getFormatException() {
        return new IllegalArgumentException("The input message body has an invalid format. The PGP decryption/verification processor expects a sequence of PGP packets of the form (entries in brackets are optional and ellipses indicate repetition, comma represents  sequential composition, and vertical bar separates alternatives): Public Key Encrypted Session Key ..., Symmetrically Encrypted Data | Sym. Encrypted and Integrity Protected Data, Compressed Data, (One Pass Signature ...,) Literal Data, (Signature ...,)");
    }

    protected PGPSignature getSignatureWithKeyId(long keyID, PGPSignatureList sigList) {
        for (int i = 0; i < sigList.size(); ++i) {
            PGPSignature signature = sigList.get(i);
            if (keyID != signature.getKeyID()) continue;
            return signature;
        }
        throw new IllegalStateException("PGP signature is inconsistent");
    }

    protected PGPOnePassSignature getSignature(Exchange exchange, PGPOnePassSignatureList signatureList) throws Exception {
        if (SIGNATURE_VERIFICATION_OPTION_IGNORE.equals(this.getSignatureVerificationOption())) {
            return null;
        }
        if (SIGNATURE_VERIFICATION_OPTION_NO_SIGNATURE_ALLOWED.equals(this.getSignatureVerificationOption())) {
            throw new PGPException("PGP message contains a signature although a signature is not expected. Either change the configuration of the PGP decryptor or send a PGP message with no signature.");
        }
        List<String> allowedUserIds = this.determineSignaturenUserIds(exchange);
        for (int i = 0; i < signatureList.size(); ++i) {
            PGPOnePassSignature signature = signatureList.get(i);
            PGPPublicKey sigPublicKey = this.publicKeyAccessor.getPublicKey(exchange, signature.getKeyID(), allowedUserIds);
            if (sigPublicKey == null) continue;
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(this.getProvider()), sigPublicKey);
            return signature;
        }
        if (signatureList.isEmpty()) {
            return null;
        }
        throw new IllegalArgumentException("Cannot verify the PGP signature: No public key found for the key ID(s) contained in the PGP signature(s). Either the received PGP message contains a signature from an unexpected sender or the Public Keyring does not contain the public key of the sender.");
    }

    public void setArmored(boolean armored) {
        this.armored = armored;
    }

    public boolean getArmored() {
        return this.armored;
    }

    public void setIntegrity(boolean integrity) {
        this.integrity = integrity;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public void setKeyUserid(String keyUserid) {
        this.keyUserid = keyUserid;
    }

    public String getKeyUserid() {
        return this.keyUserid;
    }

    public List<String> getKeyUserids() {
        return this.keyUserids;
    }

    public void setKeyUserids(List<String> keyUserids) {
        this.keyUserids = keyUserids;
    }

    public void setSignatureKeyUserid(String signatureKeyUserid) {
        this.signatureKeyUserid = signatureKeyUserid;
    }

    public String getSignatureKeyUserid() {
        return this.signatureKeyUserid;
    }

    public List<String> getSignatureKeyUserids() {
        return this.signatureKeyUserids;
    }

    public void setSignatureKeyUserids(List<String> signatureKeyUserids) {
        this.signatureKeyUserids = signatureKeyUserids;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(int compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(int hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(int algorithm) {
        this.algorithm = algorithm;
    }

    public PGPPublicKeyAccessor getPublicKeyAccessor() {
        return this.publicKeyAccessor;
    }

    public void setPublicKeyAccessor(PGPPublicKeyAccessor publicKeyAccessor) {
        this.publicKeyAccessor = publicKeyAccessor;
    }

    public PGPSecretKeyAccessor getSecretKeyAccessor() {
        return this.secretKeyAccessor;
    }

    public void setSecretKeyAccessor(PGPSecretKeyAccessor secretKeyAccessor) {
        this.secretKeyAccessor = secretKeyAccessor;
    }

    public String getSignatureVerificationOption() {
        return this.signatureVerificationOption;
    }

    public void setSignatureVerificationOption(String signatureVerificationOption) {
        if (!SIGNATURE_VERIFICATION_OPTIONS.contains(signatureVerificationOption)) {
            throw new IllegalArgumentException(signatureVerificationOption + " is not a valid signature verification option");
        }
        this.signatureVerificationOption = signatureVerificationOption;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 'fileName' is null");
        }
        this.fileName = fileName;
    }

    protected void doStart() throws Exception {
        if (Security.getProvider(BC) == null && BC.equals(this.getProvider())) {
            LOG.debug("Adding BouncyCastleProvider as security provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            LOG.debug("Using custom provider {} which is expected to be enlisted manually.", (Object)this.getProvider());
        }
    }

    protected void doStop() throws Exception {
    }
}

