/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreX509CredentialAdapter
extends BasicCredential
implements X509Credential {
    private Logger log = LoggerFactory.getLogger(KeyStoreX509CredentialAdapter.class);
    private KeyStore keyStore;
    private String credentialAlias;
    private char[] keyPassword;

    public KeyStoreX509CredentialAdapter(KeyStore store, String alias, char[] password) {
        this.keyStore = store;
        this.credentialAlias = alias;
        this.keyPassword = password;
    }

    @Override
    public Collection<X509CRL> getCRLs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public X509Certificate getEntityCertificate() {
        try {
            return (X509Certificate)this.keyStore.getCertificate(this.credentialAlias);
        }
        catch (KeyStoreException e) {
            this.log.error("Error accessing {} certificates in keystore", (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<X509Certificate> getEntityCertificateChain() {
        ArrayList<X509Certificate> certsCollection = Collections.EMPTY_LIST;
        try {
            Certificate[] certs = this.keyStore.getCertificateChain(this.credentialAlias);
            if (certs != null) {
                certsCollection = new ArrayList<X509Certificate>(certs.length);
                for (Certificate cert : certs) {
                    certsCollection.add((X509Certificate)cert);
                }
            }
        }
        catch (KeyStoreException e) {
            this.log.error("Error accessing {} certificates in keystore", (Throwable)e);
        }
        return certsCollection;
    }

    @Override
    public PrivateKey getPrivateKey() {
        try {
            return (PrivateKey)this.keyStore.getKey(this.credentialAlias, this.keyPassword);
        }
        catch (Exception e) {
            this.log.error("Error accessing {} private key in keystore", (Throwable)e);
            return null;
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }
}

