/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims.mapper;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;

public class ClaimUtils {
    public ProcessedClaimCollection add(ProcessedClaimCollection collection, ProcessedClaim ... claims) {
        ProcessedClaimCollection resultClaimCollection = null;
        if (collection != null) {
            resultClaimCollection = (ProcessedClaimCollection)collection.clone();
            for (ProcessedClaim c : claims) {
                if (c == null) continue;
                resultClaimCollection.add(c);
            }
        }
        return resultClaimCollection;
    }

    public ProcessedClaimCollection add(ProcessedClaimCollection collection, ProcessedClaimCollection ... claimCollections) {
        ProcessedClaimCollection resultClaimCollection = null;
        if (collection != null) {
            resultClaimCollection = (ProcessedClaimCollection)collection.clone();
            for (ProcessedClaimCollection cc : claimCollections) {
                resultClaimCollection.addAll(cc);
            }
        }
        return resultClaimCollection;
    }

    public ProcessedClaim create(String processedClaimTypeURI, String ... values) {
        ProcessedClaim processedClaim = new ProcessedClaim();
        if (processedClaimTypeURI != null) {
            processedClaim.setClaimType(URI.create(processedClaimTypeURI));
        }
        if (values != null) {
            processedClaim.getValues().addAll(Arrays.asList(values));
        }
        return processedClaim;
    }

    public ProcessedClaim get(ProcessedClaimCollection processedClaims, String processedClaimType) {
        if (processedClaimType == null || processedClaims == null) {
            return null;
        }
        for (ProcessedClaim c : processedClaims) {
            if (c.getClaimType() == null || !processedClaimType.equals(c.getClaimType().toString())) continue;
            return c;
        }
        return null;
    }

    public ProcessedClaimCollection mapType(ProcessedClaimCollection processedClaims, Map<String, String> map, boolean keepUnmapped) {
        ProcessedClaimCollection mappedProcessedClaims = new ProcessedClaimCollection();
        if (processedClaims != null && map != null) {
            for (ProcessedClaim c : processedClaims) {
                String processedClaimType = c.getClaimType() != null ? c.getClaimType().toString() : "";
                String mappedProcessedClaimType = map.get(processedClaimType);
                if (mappedProcessedClaimType != null) {
                    ProcessedClaim processedClaim = c.clone();
                    processedClaim.setClaimType(URI.create(mappedProcessedClaimType));
                    mappedProcessedClaims.add(processedClaim);
                    continue;
                }
                if (!keepUnmapped) continue;
                mappedProcessedClaims.add(c.clone());
            }
        }
        return mappedProcessedClaims;
    }

    public ProcessedClaim mapValues(ProcessedClaim processedClaim, Map<Object, Object> mapping, boolean keepUnmapped) {
        ProcessedClaim resultClaim = null;
        if (processedClaim != null) {
            resultClaim = processedClaim.clone();
            List values = resultClaim.getValues();
            ArrayList<Object> mappedValues = new ArrayList<Object>();
            if (values == null || mapping == null || mapping.size() == 0) {
                resultClaim.setValues(mappedValues);
                return resultClaim;
            }
            for (Object value : values) {
                Object newValue = mapping.get(value);
                if (newValue != null) {
                    mappedValues.add(newValue);
                    continue;
                }
                if (!keepUnmapped) continue;
                mappedValues.add(value);
            }
            resultClaim.setValues(mappedValues);
        }
        return resultClaim;
    }

    public ProcessedClaim filterValues(ProcessedClaim processedClaim, String filter) {
        ProcessedClaim resultClaim = null;
        if (processedClaim != null) {
            resultClaim = processedClaim.clone();
            List values = resultClaim.getValues();
            ArrayList filteredValues = new ArrayList();
            if (values == null || filter == null) {
                resultClaim.setValues(filteredValues);
                return resultClaim;
            }
            for (Object value : values) {
                if (value == null || !value.toString().matches(filter)) continue;
                filteredValues.add(value);
            }
            resultClaim.setValues(filteredValues);
        }
        return resultClaim;
    }

    public ProcessedClaim merge(ProcessedClaimCollection processedClaims, String targetClaimType, String delimiter, String ... processedClaimType) {
        ProcessedClaim mergedProcessedClaim = null;
        StringBuilder sbProcessedClaimValue = new StringBuilder();
        for (String sc : processedClaimType) {
            List values;
            ProcessedClaim c = this.get(processedClaims, sc);
            if (c == null || (values = c.getValues()) == null || values.size() <= 0) continue;
            if (mergedProcessedClaim == null) {
                mergedProcessedClaim = c.clone();
                sbProcessedClaimValue.append(values.get(0));
                mergedProcessedClaim.getValues().clear();
                continue;
            }
            sbProcessedClaimValue.append(delimiter).append(values.get(0));
        }
        if (mergedProcessedClaim != null) {
            mergedProcessedClaim.setClaimType(URI.create(targetClaimType));
            mergedProcessedClaim.addValue(sbProcessedClaimValue.toString());
        }
        return mergedProcessedClaim;
    }

    public ProcessedClaim setType(ProcessedClaim processedClaim, String processedClaimTypeURI) {
        if (processedClaim != null && processedClaimTypeURI != null) {
            processedClaim.setClaimType(URI.create(processedClaimTypeURI));
        }
        return processedClaim;
    }

    public ProcessedClaimCollection updateIssuer(ProcessedClaimCollection processedClaims, String newIssuer) {
        ProcessedClaimCollection resultClaimCollection = null;
        if (processedClaims != null) {
            resultClaimCollection = new ProcessedClaimCollection();
            for (ProcessedClaim c : processedClaims) {
                ProcessedClaim newClaim = c.clone();
                if (newClaim.getOriginalIssuer() == null) {
                    newClaim.setOriginalIssuer(newClaim.getIssuer());
                }
                newClaim.setIssuer(newIssuer);
                resultClaimCollection.add(newClaim);
            }
        }
        return resultClaimCollection;
    }

    public ProcessedClaim upperCaseValues(ProcessedClaim processedClaim) {
        ProcessedClaim resultClaim = null;
        if (processedClaim != null && (resultClaim = processedClaim.clone()).getValues() != null) {
            List oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (Object value : oldValues) {
                newValues.add(value.toString().toUpperCase());
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public ProcessedClaim lowerCaseValues(ProcessedClaim processedClaim) {
        ProcessedClaim resultClaim = null;
        if (processedClaim != null && (resultClaim = processedClaim.clone()).getValues() != null) {
            List oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (Object value : oldValues) {
                newValues.add(value.toString().toLowerCase());
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public ProcessedClaim wrapValues(ProcessedClaim processedClaim, String prefix, String suffix) {
        prefix = prefix == null ? "" : prefix;
        suffix = suffix == null ? "" : suffix;
        ProcessedClaim resultClaim = null;
        if (processedClaim != null && (resultClaim = processedClaim.clone()).getValues() != null) {
            List oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (Object value : oldValues) {
                newValues.add(prefix + value.toString() + suffix);
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public ProcessedClaim singleToMultiValue(ProcessedClaim processedClaim, String delimiter) {
        ProcessedClaim resultClaim = null;
        if (processedClaim != null && (resultClaim = processedClaim.clone()).getValues() != null) {
            List oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (Object value : oldValues) {
                String multivalue = value.toString();
                StringTokenizer st = new StringTokenizer(multivalue, delimiter);
                while (st.hasMoreTokens()) {
                    newValues.add(st.nextToken());
                }
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public ProcessedClaim multiToSingleValue(ProcessedClaim processedClaim, String delimiter) {
        ProcessedClaim resultClaim = null;
        if (processedClaim != null && (resultClaim = processedClaim.clone()).getValues() != null) {
            List oldValues = resultClaim.getValues();
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (Object value : oldValues) {
                if (first) {
                    sb.append(value);
                    first = false;
                    continue;
                }
                sb.append(delimiter).append(value);
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().add(sb.toString());
        }
        return resultClaim;
    }
}

