/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.activemq.jms.pool.PooledSession;
import org.apache.activemq.jms.pool.PooledSessionEventListener;
import org.apache.activemq.jms.pool.SessionHolder;
import org.apache.activemq.jms.pool.SessionKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool
implements ExceptionListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConnectionPool.class);
    protected Connection connection;
    private int referenceCount;
    private long lastUsed;
    private final long firstUsed;
    private boolean hasExpired;
    private int idleTimeout;
    private long expiryTimeout;
    private boolean useAnonymousProducers;
    private final AtomicBoolean started;
    private final GenericKeyedObjectPool<SessionKey, SessionHolder> sessionPool;
    private final List<PooledSession> loanedSessions;
    private boolean reconnectOnException;
    private ExceptionListener parentExceptionListener;

    public ConnectionPool(Connection connection) {
        this.firstUsed = this.lastUsed = System.currentTimeMillis();
        this.idleTimeout = 30000;
        this.expiryTimeout = 0L;
        this.useAnonymousProducers = true;
        this.started = new AtomicBoolean(false);
        this.loanedSessions = new CopyOnWriteArrayList<PooledSession>();
        this.connection = this.wrap(connection);
        this.sessionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new KeyedPoolableObjectFactory<SessionKey, SessionHolder>(){

            public void activateObject(SessionKey key, SessionHolder session) throws Exception {
            }

            public void destroyObject(SessionKey key, SessionHolder session) throws Exception {
                session.close();
            }

            public SessionHolder makeObject(SessionKey key) throws Exception {
                return new SessionHolder(ConnectionPool.this.makeSession(key));
            }

            public void passivateObject(SessionKey key, SessionHolder session) throws Exception {
            }

            public boolean validateObject(SessionKey key, SessionHolder session) {
                return true;
            }
        });
    }

    public void setHasExpired(boolean val) {
        this.hasExpired = val;
    }

    protected Session makeSession(SessionKey key) throws JMSException {
        return this.connection.createSession(key.isTransacted(), key.getAckMode());
    }

    protected Connection wrap(Connection connection) {
        return connection;
    }

    protected void unWrap(Connection connection) {
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession session;
        SessionKey key = new SessionKey(transacted, ackMode);
        try {
            session = new PooledSession(key, (SessionHolder)this.sessionPool.borrowObject((Object)key), (KeyedObjectPool<SessionKey, SessionHolder>)this.sessionPool, key.isTransacted(), this.useAnonymousProducers);
            session.addSessionEventListener(new PooledSessionEventListener(){

                @Override
                public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
                }

                @Override
                public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
                }

                @Override
                public void onSessionClosed(PooledSession session) {
                    ConnectionPool.this.loanedSessions.remove(session);
                }
            });
            this.loanedSessions.add(session);
        }
        catch (Exception e) {
            IllegalStateException illegalStateException = new IllegalStateException(e.toString());
            illegalStateException.initCause((Throwable)e);
            throw illegalStateException;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                this.sessionPool.close();
            }
            catch (Exception e) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            for (PooledSession session : this.loanedSessions) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            this.loanedSessions.clear();
            this.unWrap(this.getConnection());
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        boolean expired = false;
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired && this.referenceCount == 0) {
            this.close();
            expired = true;
        }
        if (this.expiryTimeout > 0L && System.currentTimeMillis() > this.firstUsed + this.expiryTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
                expired = true;
            }
        }
        if (this.referenceCount == 0 && this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout) {
            this.hasExpired = true;
            this.close();
            expired = true;
        }
        return expired;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public int getMaximumActiveSessionPerConnection() {
        return this.sessionPool.getMaxActive();
    }

    public void setMaximumActiveSessionPerConnection(int maximumActiveSessionPerConnection) {
        this.sessionPool.setMaxActive(maximumActiveSessionPerConnection);
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    public int getNumSessions() {
        return this.sessionPool.getNumIdle() + this.sessionPool.getNumActive();
    }

    public int getNumIdleSessions() {
        return this.sessionPool.getNumIdle();
    }

    public int getNumActiveSessions() {
        return this.sessionPool.getNumActive();
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.sessionPool.setWhenExhaustedAction(block ? (byte)1 : 0);
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.sessionPool.getWhenExhaustedAction() == 1;
    }

    public long getBlockIfSessionPoolIsFullTimeout() {
        return this.sessionPool.getMaxWait();
    }

    public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
        this.sessionPool.setMaxWait(blockIfSessionPoolIsFullTimeout);
    }

    public boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
        try {
            if (this.isReconnectOnException()) {
                if (this.connection.getExceptionListener() != null) {
                    this.parentExceptionListener = this.connection.getExceptionListener();
                }
                this.connection.setExceptionListener((ExceptionListener)this);
            } else {
                if (this.parentExceptionListener != null) {
                    this.connection.setExceptionListener(this.parentExceptionListener);
                }
                this.parentExceptionListener = null;
            }
        }
        catch (JMSException jmse) {
            LOG.warn("Cannot set reconnect exception listener", (Throwable)jmse);
        }
    }

    public void onException(JMSException exception) {
        this.close();
        if (this.parentExceptionListener != null) {
            this.parentExceptionListener.onException(exception);
        }
    }

    public String toString() {
        return "ConnectionPool[" + this.connection + "]";
    }
}

