/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Comment;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Entity;
import de.pdark.decentxml.EntityResolver;
import de.pdark.decentxml.Location;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.ProcessingInstruction;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLStringSource;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLUtils;
import de.pdark.decentxml.dtd.DTDTokenizer;
import de.pdark.decentxml.dtd.DocType;
import de.pdark.decentxml.dtd.DocTypeAttributeList;
import de.pdark.decentxml.dtd.DocTypeElement;
import de.pdark.decentxml.dtd.DocTypeEntity;
import de.pdark.decentxml.dtd.DocTypeEntityResolver;
import de.pdark.decentxml.dtd.DocTypeNode;
import de.pdark.decentxml.dtd.DocTypeNotation;
import de.pdark.decentxml.dtd.DocTypeText;
import de.pdark.decentxml.validation.CharValidator;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser {
    private EntityResolver entityResolver;
    private boolean expandEntities;
    private boolean treatEntitiesAsText = true;
    private CharValidator charValidator = new CharValidator();

    public XMLParser setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        if (entityResolver != null) {
            this.setExpandEntities(true);
        }
        return this;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public XMLParser setExpandEntities(boolean expandEntities) {
        this.expandEntities = expandEntities;
        if (expandEntities) {
            this.setTreatEntitiesAsText(false);
        }
        return this;
    }

    public boolean isExpandEntities() {
        return this.expandEntities && this.entityResolver != null;
    }

    public XMLParser setTreatEntitiesAsText(boolean treatEntitiesAsText) {
        this.treatEntitiesAsText = treatEntitiesAsText;
        return this;
    }

    public boolean isTreatEntitiesAsText() {
        return this.treatEntitiesAsText;
    }

    public CharValidator getCharValidator() {
        return this.charValidator;
    }

    public XMLParser setCharValidator(CharValidator charValidator) {
        if (charValidator == null) {
            throw new IllegalArgumentException("charValidator is null");
        }
        this.charValidator = charValidator;
        return this;
    }

    public Document parse(XMLSource source) {
        Token token;
        Document doc = new Document();
        XMLTokenizer tokenizer = this.createTokenizer(source);
        tokenizer.setCharValidator(this.charValidator);
        tokenizer.setEntityResolver(this.entityResolver);
        while ((token = tokenizer.next()) != null) {
            if (token.getType() == XMLTokenizer.Type.DOCTYPE) {
                XMLTokenizer dtdTokenizer = this.createDTDTokenizer(tokenizer.getSource(), token.getStartOffset());
                DocType docType = this.parseDocType(dtdTokenizer);
                doc.addNode(docType);
                tokenizer.setOffset(dtdTokenizer.getOffset());
                this.entityResolver = new DocTypeEntityResolver(docType, this.entityResolver);
                continue;
            }
            Node n = this.toNode(token);
            doc.addNode(n);
            if (token.getType() != XMLTokenizer.Type.BEGIN_ELEMENT) continue;
            this.parseElement(tokenizer, (Element)n);
        }
        if (doc.getRootElement() == null) {
            throw new XMLParseException("No root element found");
        }
        if (this.entityResolver instanceof DocTypeEntityResolver) {
            this.entityResolver = this.entityResolver.getParent();
        }
        return doc;
    }

    protected DocType parseDocType(XMLTokenizer tokenizer) {
        Token startToken = tokenizer.next();
        if (startToken == null) {
            throw new XMLParseException("Expected '<!DOCTYPE'", tokenizer.getSource(), tokenizer.getOffset());
        }
        if (startToken.getType() != XMLTokenizer.Type.DOCTYPE) {
            throw new XMLParseException("Expected '<!DOCTYPE' but found '" + startToken.getText() + "'", startToken);
        }
        DocType docType = new DocType(startToken);
        Token token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '<!DOCTYPE'");
        docType.add(this.toNode(token));
        token = this.expect(tokenizer, startToken, XMLTokenizer.Type.TEXT, "Expected name after '<!DOCTYPE'");
        docType.add(this.toNode(token));
        docType.setName(token.getText());
        token = this.skipOptionalWhitespace(tokenizer, tokenizer.next(), docType);
        if (token.getType() == XMLTokenizer.Type.DOCTYPE_SYSTEM) {
            docType.add(this.toNode(token));
            token = this.parseSystemLiteral(tokenizer, token, docType);
        } else if (token.getType() == XMLTokenizer.Type.DOCTYPE_PUBLIC) {
            docType.add(this.toNode(token));
            token = this.parsePublicLiteral(tokenizer, token, docType);
        } else if (token.getType() == XMLTokenizer.Type.DOCTYPE_NDATA) {
            // empty if block
        }
        token = this.skipOptionalWhitespace(tokenizer, token, docType);
        if (token.getType() == XMLTokenizer.Type.DOCTYPE_BEGIN_SUBSET) {
            docType.add(this.toNode(token));
            token = this.parseDocTypeSubSet(tokenizer, token, docType);
        }
        if (token.getType() != XMLTokenizer.Type.DOCTYPE_END) {
            throw new XMLParseException("Expected '>', got " + token, token);
        }
        docType.add(this.toNode(token));
        token = tokenizer.next();
        if (token != null) {
            throw new XMLParseException("Expected no further tokens from the DTD tokenizer: " + token, token);
        }
        return docType;
    }

    protected XMLTokenizer createDTDTokenizer(XMLSource source, int startOffset) {
        return new DTDTokenizer(source, startOffset);
    }

    protected Token skipOptionalWhitespace(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        if (startToken == null) {
            throw new XMLParseException("Unexpected EOF after '<!DOCTYPE'", tokenizer.getSource(), tokenizer.getSource().length());
        }
        Token token = startToken;
        if (token.getType() == XMLTokenizer.Type.DTD_WHITESPACE) {
            docType.add(this.toNode(token));
            token = tokenizer.next();
            if (token == null) {
                throw new XMLParseException("Unexpected EOF after '<!DOCTYPE'", startToken);
            }
        }
        return token;
    }

    protected Token parseDocTypeSubSet(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        Token token;
        while ((token = tokenizer.next()) != null) {
            if (token.getType() == XMLTokenizer.Type.DOCTYPE_ELEMENT) {
                this.parseDocTypeSubElement(tokenizer, token, docType);
                continue;
            }
            if (token.getType() == XMLTokenizer.Type.DOCTYPE_ATTLIST) {
                this.parseDocTypeAttList(tokenizer, token, docType);
                continue;
            }
            if (token.getType() == XMLTokenizer.Type.DOCTYPE_ENTITY) {
                this.parseDocTypeEntity(tokenizer, token, docType);
                continue;
            }
            if (token.getType() == XMLTokenizer.Type.DOCTYPE_NOTATION) {
                this.parseDocTypeNotation(tokenizer, token, docType);
                continue;
            }
            docType.add(this.toNode(token));
            if (token.getType() != XMLTokenizer.Type.DOCTYPE_END_SUBSET) continue;
        }
        docType.mapElementsAndAttributes();
        return this.skipOptionalWhitespace(tokenizer, tokenizer.next(), docType);
    }

    protected void parseDocTypeNotation(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        DocTypeNotation notation = new DocTypeNotation(startToken, null);
        Token token = startToken;
        token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '<!NOTATION'");
        notation.addNode(this.toNode(token));
        token = this.expect(tokenizer, token, XMLTokenizer.Type.TEXT, "Expected notation name");
        notation.addNode(this.toNode(token));
        String name = token.getText();
        notation.setName(name);
        token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after notation name");
        notation.addNode(this.toNode(token));
        token = this.expect(tokenizer, token, new XMLTokenizer.Type[]{XMLTokenizer.Type.DOCTYPE_SYSTEM, XMLTokenizer.Type.DOCTYPE_PUBLIC}, "Expected 'SYSTEM' or 'PUBLIC'");
        notation.addNode(this.toNode(token));
        if (token.getType() == XMLTokenizer.Type.DOCTYPE_SYSTEM) {
            notation.setText(token.getText());
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'SYSTEM'");
            notation.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected quoted text after 'SYSTEM'");
            notation.addNode(this.toNode(token));
            notation.setSystemLiteral(this.stripQuotes(token));
            token = this.skipWhiteSpaceAndComments(tokenizer, tokenizer.next(), notation);
        } else if (token.getType() == XMLTokenizer.Type.DOCTYPE_PUBLIC) {
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'PUBLIC'");
            notation.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected public ID literal after 'PUBLIC'");
            notation.addNode(this.toNode(token));
            notation.setPublicIDLiteral(this.stripQuotes(token));
            token = tokenizer.next();
            if (token != null && token.getType() != XMLTokenizer.Type.DOCTYPE_END) {
                if (token.getType() != XMLTokenizer.Type.DTD_WHITESPACE) {
                    throw new XMLParseException("Expected whitespace after public ID literal", token);
                }
                token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected system literal after public ID literal");
                notation.addNode(this.toNode(token));
                notation.setSystemLiteral(this.stripQuotes(token));
            }
        }
        if (token == null) {
            throw new XMLParseException("Unexpected EOF while parsing notation declaration", tokenizer.getSource(), tokenizer.getOffset());
        }
        if (token.getType() != XMLTokenizer.Type.DOCTYPE_END) {
            throw new XMLParseException("Expected '>' after notation declaration" + tokenizer.lookAheadForErrorMessage("but found", token.getStartOffset(), 20), tokenizer.getSource(), tokenizer.getOffset());
        }
        docType.add(notation);
    }

    protected void parseDocTypeEntity(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        DocTypeEntity entity = new DocTypeEntity(startToken, null);
        Token token = startToken;
        token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '<!ENTITY'");
        entity.addNode(this.toNode(token));
        token = this.expect(tokenizer, token, new XMLTokenizer.Type[]{XMLTokenizer.Type.TEXT, XMLTokenizer.Type.DOCTYPE_PARAMETER_ENTITY}, "Expected entity name or '%'");
        entity.addNode(this.toNode(token));
        String name = token.getText();
        boolean isParameterEntity = "%".equals(name);
        if (isParameterEntity) {
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '%'");
            entity.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.TEXT, "Expected entity name");
            entity.addNode(this.toNode(token));
            name = token.getText();
        }
        entity.setParameterEntity(isParameterEntity);
        entity.setName(name);
        token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after entity name");
        entity.addNode(this.toNode(token));
        token = this.expect(tokenizer, token, new XMLTokenizer.Type[]{XMLTokenizer.Type.DOCTYPE_SYSTEM, XMLTokenizer.Type.DOCTYPE_PUBLIC, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT}, "Expected 'SYSTEM', 'PUBLIC' or quoted text after entity name");
        entity.addNode(this.toNode(token));
        if (token.getType() == XMLTokenizer.Type.DOCTYPE_SYSTEM) {
            entity.setText(token.getText());
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'SYSTEM'");
            entity.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected quoted text after 'SYSTEM'");
            entity.addNode(this.toNode(token));
            entity.setSystemLiteral(this.stripQuotes(token));
        } else if (token.getType() == XMLTokenizer.Type.DOCTYPE_PUBLIC) {
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'PUBLIC'");
            entity.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected public ID literal after 'PUBLIC'");
            entity.addNode(this.toNode(token));
            entity.setPublicIDLiteral(this.stripQuotes(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after public ID literal");
            entity.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected system literal after public ID literal");
            entity.addNode(this.toNode(token));
            entity.setSystemLiteral(this.stripQuotes(token));
        } else {
            entity.setText(this.stripQuotes(token));
        }
        token = this.skipWhiteSpaceAndComments(tokenizer, tokenizer.next(), entity);
        if (token == null) {
            throw new XMLParseException("Unexpected EOF while parsing entity declaration", tokenizer.getSource(), tokenizer.getOffset());
        }
        if (token.getType() == XMLTokenizer.Type.DOCTYPE_NDATA) {
            Node last = entity.getNodes().get(entity.getNodes().size() - 1);
            if (!XMLUtils.isText(last) || !((Text)last).isWhitespace()) {
                throw new XMLParseException("Space is required before an NDATA entity annotation", token);
            }
            if (isParameterEntity) {
                throw new XMLParseException("Parameter entities are always parsed; NDATA annotations are not permitted", token);
            }
            entity.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'NDATA'");
            entity.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.TEXT, "Expected name after 'NDATA'");
            entity.addNode(this.toNode(token));
            entity.setNotationName(token.getText());
            token = this.skipWhiteSpaceAndComments(tokenizer, tokenizer.next(), entity);
            if (token == null) {
                throw new XMLParseException("Unexpected EOF while parsing entity declaration", tokenizer.getSource(), tokenizer.getOffset());
            }
        }
        if (token.getType() != XMLTokenizer.Type.DOCTYPE_END) {
            throw new XMLParseException("Expected '>' after entity declaration" + tokenizer.lookAheadForErrorMessage("but found", token.getStartOffset(), 20), tokenizer.getSource(), tokenizer.getOffset());
        }
        docType.add(entity);
    }

    protected String stripQuotes(Token token) {
        String text = token.getText();
        if (text == null || text.length() < 2) {
            return text;
        }
        return text.substring(1, text.length() - 1);
    }

    protected void parseDocTypeAttList(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        Token token = startToken;
        token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '<!ATTLIST'");
        String elementName = (token = this.expect(tokenizer, token, XMLTokenizer.Type.TEXT, "Expected name of element that this '<!ATTLIST' is for")).getText();
        if (!this.isValidName(tokenizer, elementName)) {
            throw new XMLParseException("Attribute name is no valid XML name", token);
        }
        DocTypeAttributeList attList = new DocTypeAttributeList(startToken, elementName);
        while ((token = tokenizer.next()) != null && (token = this.skipWhiteSpaceAndComments(tokenizer, token, attList)).getType() != XMLTokenizer.Type.DOCTYPE_END) {
            if (token.getType() != XMLTokenizer.Type.TEXT) {
                throw new XMLParseException("Expected attribute name", token);
            }
            attList.addNode(this.toNode(token));
            if (!this.isValidName(tokenizer, token.getText())) {
                throw new XMLParseException("Attribute name is no valid XML name", token);
            }
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after attribute name");
            attList.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, new XMLTokenizer.Type[]{XMLTokenizer.Type.TEXT, XMLTokenizer.Type.DOCTYPE_BEGIN_GROUP}, "Expected attribute type");
            attList.addNode(this.toNode(token));
            if (token.getType() == XMLTokenizer.Type.TEXT) {
                String type = token.getText();
                token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after attribute type");
                attList.addNode(this.toNode(token));
                if ("NOTATION".equals(type)) {
                    token = tokenizer.next();
                    if (token == null) break;
                    if (token.getType() == XMLTokenizer.Type.DOCTYPE_BEGIN_GROUP) {
                        token = this.parseAttListTypeGroup(tokenizer, token, attList);
                    }
                    token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after list of notation types");
                    attList.addNode(this.toNode(token));
                }
            } else {
                token = this.parseAttListNameTokens(tokenizer, token, attList);
                token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after list of alternatives");
                attList.addNode(this.toNode(token));
            }
            token = tokenizer.next();
            if (token == null) break;
            if (token.getType() != XMLTokenizer.Type.DOCTYPE_IMPLIED && token.getType() != XMLTokenizer.Type.DOCTYPE_REQUIRED && token.getType() != XMLTokenizer.Type.DOCTYPE_FIXED && token.getType() != XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT) {
                throw new XMLParseException("Expected #IMPLIED or quoted text: " + token, token);
            }
            attList.addNode(this.toNode(token));
            if (token.getType() != XMLTokenizer.Type.DOCTYPE_FIXED) continue;
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '#FIXED'");
            attList.addNode(this.toNode(token));
            token = this.expect(tokenizer, token, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected quoted text after '#FIXED'");
            attList.addNode(this.toNode(token));
        }
        if (token == null) {
            throw new XMLParseException("Unexpected EOF while parsing attribute list declaration", tokenizer.getSource(), tokenizer.getOffset());
        }
        docType.add(attList);
    }

    protected boolean isValidName(XMLTokenizer tokenizer, String name) {
        return name != null && name.length() > 0 && this.charValidator.isNameStartChar(name.charAt(0));
    }

    protected Token parseAttListNameTokens(XMLTokenizer tokenizer, Token token, DocTypeAttributeList attList) {
        while ((token = tokenizer.next()) != null) {
            attList.addNode(this.toNode(token));
            if (token.getType() == XMLTokenizer.Type.DTD_WHITESPACE || token.getType() == XMLTokenizer.Type.TEXT || token.getType() == XMLTokenizer.Type.DOCTYPE_ALTERNATIVE) continue;
            if (token.getType() == XMLTokenizer.Type.DOCTYPE_END_GROUP) break;
            throw new XMLParseException("Expected whitespace, '|' or a name token", token);
        }
        return token;
    }

    protected Token parseAttListTypeGroup(XMLTokenizer tokenizer, Token token, DocTypeAttributeList attList) {
        attList.addNode(this.toNode(token));
        Token startGroup = token;
        int subLevel = 0;
        while ((token = tokenizer.next()) != null) {
            attList.addNode(this.toNode(token));
            if (token.getType() == XMLTokenizer.Type.DOCTYPE_END_GROUP) {
                if (subLevel == 0) break;
                --subLevel;
                continue;
            }
            if (token.getType() != XMLTokenizer.Type.DOCTYPE_BEGIN_GROUP) continue;
            ++subLevel;
        }
        if (token == null) {
            throw new XMLParseException("Expected end of group" + tokenizer.lookAheadForErrorMessage("but found", startGroup.getStartOffset(), 20), startGroup);
        }
        return token;
    }

    protected Token skipWhiteSpaceAndComments(XMLTokenizer tokenizer, Token token, DocTypeNode n) {
        while (token != null) {
            if (token.getType() == XMLTokenizer.Type.DTD_WHITESPACE) {
                n.addNode(this.toNode(token));
                token = tokenizer.next();
                continue;
            }
            if (token.getType() != XMLTokenizer.Type.DOCTYPE_COMMENT) break;
            n.addNode(this.toNode(token));
            token = tokenizer.next();
        }
        return token;
    }

    protected void parseDocTypeSubElement(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        Token token = startToken;
        token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after '<!ELEMENT'");
        token = this.expect(tokenizer, token, XMLTokenizer.Type.TEXT, "Expected element name");
        String name = token.getText();
        Token beforeContent = token = this.expect(tokenizer, token, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after element name");
        while ((token = tokenizer.next()) != null && token.getType() != XMLTokenizer.Type.DOCTYPE_END) {
        }
        if (token == null) {
            throw new XMLParseException("Unexpected EOF while parsing element content", tokenizer.getSource(), tokenizer.getOffset());
        }
        String content = tokenizer.getSource().substring(beforeContent.getEndOffset(), token.getStartOffset());
        startToken.setEndOffset(token.getEndOffset());
        DocTypeElement element = new DocTypeElement(startToken, name, content);
        docType.add(element);
    }

    protected Token parsePublicLiteral(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        docType.setDocTypeType(DocType.DocTypeType.PUBLIC);
        Token token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'PUBLIC'");
        docType.add(this.toNode(token));
        token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected quoted public id after 'PUBLIC'");
        docType.add(this.toNode(token));
        String s = token.getText();
        docType.setPublicLiteral(s.substring(1, s.length() - 1));
        token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after public id " + docType.getPublicLiteral());
        docType.add(this.toNode(token));
        token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected quoted system literal after the public id of 'PUBLIC'");
        docType.add(this.toNode(token));
        s = token.getText();
        docType.setSystemLiteral(s.substring(1, s.length() - 1));
        return this.skipOptionalWhitespace(tokenizer, tokenizer.next(), docType);
    }

    protected Token parseSystemLiteral(XMLTokenizer tokenizer, Token startToken, DocType docType) {
        docType.setDocTypeType(DocType.DocTypeType.SYSTEM);
        Token token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DTD_WHITESPACE, "Expected whitespace after 'SYSTEM'");
        docType.add(this.toNode(token));
        token = this.expect(tokenizer, startToken, XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT, "Expected quoted system literal after 'SYSTEM'");
        docType.add(this.toNode(token));
        String s = token.getText();
        docType.setSystemLiteral(s.substring(1, s.length() - 1));
        return this.skipOptionalWhitespace(tokenizer, tokenizer.next(), docType);
    }

    protected Token expect(XMLTokenizer tokenizer, Token startToken, XMLTokenizer.Type[] expected, String errorMessage) {
        boolean valid;
        Token token = tokenizer.next();
        boolean bl = valid = token != null;
        if (valid) {
            valid = false;
            for (XMLTokenizer.Type t : expected) {
                if (token.getType() != t) continue;
                valid = true;
                break;
            }
        }
        if (!valid) {
            if (token == null) {
                token = startToken;
            }
            throw new XMLParseException(errorMessage + ": " + token, token);
        }
        return token;
    }

    protected Token expect(XMLTokenizer tokenizer, Token startToken, XMLTokenizer.Type expected, String errorMessage) {
        Token token = tokenizer.next();
        if (token == null || token.getType() != expected) {
            if (token == null) {
                token = startToken;
            }
            throw new XMLParseException(errorMessage + tokenizer.lookAheadForErrorMessage("but found", token.getStartOffset(), 20) + " (" + token + ")", token);
        }
        return token;
    }

    protected XMLTokenizer createTokenizer(XMLSource source) {
        XMLTokenizer tokenizer = new XMLTokenizer(source);
        tokenizer.setTreatEntitiesAsText(this.treatEntitiesAsText);
        return tokenizer;
    }

    protected void parseElement(XMLTokenizer tokenizer, Element parent) {
        Token token = null;
        while ((token = tokenizer.next()) != null && token.getType() != XMLTokenizer.Type.BEGIN_ELEMENT_END) {
            if (token.getType() != XMLTokenizer.Type.ATTRIBUTE) {
                throw new XMLParseException("Unexpected token " + token + " while parsing attributes of element " + parent.getName(), token);
            }
            if (!Character.isWhitespace(token.getSource().charAt(token.getStartOffset()))) {
                throw new XMLParseException("Expected whitespace between attributes of element a but found " + token, token);
            }
            parent.addAttribute((Attribute)this.toNode(token));
        }
        int pos = parent.getName().indexOf(58);
        if (pos == 0) {
            throw new XMLParseException("Missing namespace prefix before colon: '" + parent.getName() + "'", parent.getStartToken());
        }
        if (pos > 0) {
            String prefix = parent.getName().substring(0, pos);
            Namespace ns = parent.getDocument().getNamespace(prefix);
            if (ns == null) {
                throw new XMLParseException("The namespace prefix " + prefix + " is not defined: '" + parent.getName() + "'", parent.getStartToken());
            }
            parent.setNamespace(ns);
            String name = parent.getName().substring(pos + 1);
            if (name.length() == 0) {
                throw new XMLParseException("Missing element name after namespace prefix: '" + parent.getName() + "'", parent.getStartToken());
            }
            String beginName = parent.getBeginName();
            String endName = parent.getEndName();
            parent.setName(name);
            parent.setBeginName(beginName);
            parent.setEndName(endName);
        }
        if (token == null) {
            throw new XMLParseException("Unexpected end-of-file while parsing attributes of element " + parent.getName(), tokenizer.getSource(), tokenizer.getOffset());
        }
        if (token.getType() == XMLTokenizer.Type.BEGIN_ELEMENT_END) {
            String postSpace = token.getPrefixWhiteSpace();
            parent.setPostSpace(postSpace);
            if ("/>".equals(token.getText().trim())) {
                parent.setCompactEmpty(true);
                return;
            }
        }
        if ((token = this.parseElementContent(tokenizer, parent, null)) == null) {
            throw new XMLParseException("Unexpected end-of-file while parsing children of element " + parent.getName(), parent.getStartToken());
        }
    }

    protected Token parseElementContent(XMLTokenizer tokenizer, Element parent, Set<String> recursionTrap) {
        Token token;
        while ((token = tokenizer.next()) != null) {
            if (token.getType() == XMLTokenizer.Type.END_ELEMENT) {
                String endName = token.getText();
                endName = endName.substring(2, endName.length() - 1);
                String name = endName.trim();
                String elementName = parent.getName();
                if (parent.getNamespace().getPrefix().length() != 0) {
                    elementName = parent.getNamespace().getPrefix() + ":" + elementName;
                }
                if (!name.trim().equals(elementName)) {
                    Location l = new Location(token);
                    throw new XMLParseException("End element '" + name + "' at line " + l.getLine() + ", column " + l.getColumn() + " doesn't match with '" + parent.getName() + "'", parent.getStartToken());
                }
                if (endName.length() != parent.getName().length()) {
                    parent.setEndName(endName);
                }
                parent.getStartToken().setEndOffset(token.getEndOffset());
                return token;
            }
            if (this.expandEntities && token.getType() == XMLTokenizer.Type.ENTITY) {
                if (recursionTrap == null) {
                    recursionTrap = new HashSet<String>();
                }
                this.expandEntity(parent, tokenizer, token, recursionTrap);
                continue;
            }
            Node n = this.toNode(token);
            parent.addNode(n);
            if (token.getType() != XMLTokenizer.Type.BEGIN_ELEMENT) continue;
            Element child = (Element)n;
            this.parseElement(tokenizer, child);
        }
        return null;
    }

    protected void expandEntity(Element parent, XMLTokenizer parentTokenizer, Token entityToken, Set<String> recursionTrap) {
        Token token;
        String entity = entityToken.getText();
        String expandedEntity = this.getEntityResolver().expand(entity);
        if (expandedEntity == null) {
            throw new XMLParseException("Entity " + entity + " is not defined", entityToken);
        }
        if ("<".equals(expandedEntity) || ">".equals(expandedEntity) || "&".equals(expandedEntity)) {
            parent.addNode(new Text(expandedEntity));
            return;
        }
        if (recursionTrap.contains(entity)) {
            throw new XMLParseException("Expansion of " + entity + " leads to infinite recursion", entityToken);
        }
        XMLStringSource source = new XMLStringSource(expandedEntity);
        XMLTokenizer entityTokenizer = new XMLTokenizer(source);
        entityTokenizer.setEntityResolver(parentTokenizer.getEntityResolver());
        entityTokenizer.setTreatEntitiesAsText(parentTokenizer.isTreatEntitiesAsText());
        entityTokenizer.setCharValidator(parentTokenizer.getCharValidator());
        try {
            recursionTrap.add(entity);
            token = this.parseElementContent(entityTokenizer, parent, recursionTrap);
            recursionTrap.remove(entity);
        }
        catch (XMLParseException e) {
            throw new XMLParseException("Error while expanding entity " + entity + ": " + e.getMessage(), e).setToken(entityToken);
        }
        if (token == null) {
            return;
        }
        throw new XMLParseException("Expanded entity " + entity + " is not well-formed since it contains the end-token for '" + parent.getName() + "'", entityToken);
    }

    protected Node toNode(Token token) {
        switch (token.getType()) {
            case TEXT: {
                return this.createText(token);
            }
            case ENTITY: {
                return this.createEntity(token);
            }
            case ATTRIBUTE: {
                return this.createAttribute(token);
            }
            case BEGIN_ELEMENT: {
                return this.createElement(token);
            }
            case CDATA: {
                return this.createCData(token);
            }
            case COMMENT: {
                return this.createComment(token);
            }
            case DTD_WHITESPACE: {
                return this.createElementWhitespace(token);
            }
            case PROCESSING_INSTRUCTION: {
                return this.createProcessingInstruction(token);
            }
            case DOCTYPE_END: 
            case DOCTYPE_SYSTEM: 
            case DOCTYPE_PUBLIC: 
            case DOCTYPE_NDATA: 
            case DOCTYPE_QUOTED_TEXT: 
            case DOCTYPE_BEGIN_SUBSET: 
            case DOCTYPE_END_SUBSET: 
            case DOCTYPE_BEGIN_GROUP: 
            case DOCTYPE_END_GROUP: 
            case DOCTYPE_ALTERNATIVE: 
            case DOCTYPE_IMPLIED: 
            case DOCTYPE_REQUIRED: 
            case DOCTYPE_FIXED: 
            case DOCTYPE_COMMENT: 
            case DOCTYPE_PARAMETER_ENTITY: 
            case DOCTYPE_PARAMETER_ENTITY_END: {
                return this.createDocTypeText(token);
            }
        }
        throw new XMLParseException("Unexpected token " + token, token);
    }

    protected Node createDocTypeText(Token token) {
        return new DocTypeText(token);
    }

    protected Node createProcessingInstruction(Token token) {
        return new ProcessingInstruction(token);
    }

    protected Node createElementWhitespace(Token token) {
        return new Text(token);
    }

    protected Node createComment(Token token) {
        return new Comment(token);
    }

    protected Node createCData(Token token) {
        return new Text(token);
    }

    protected Node createElement(Token token) {
        return new Element(token);
    }

    protected Node createAttribute(Token token) {
        return new Attribute(token);
    }

    protected Node createEntity(Token token) {
        return new Entity(token, this.entityResolver);
    }

    protected Node createText(Token token) {
        return new Text(token);
    }

    public static Document parse(String xml) {
        return new XMLParser().parse(new XMLStringSource(xml));
    }

    public static Document parse(File file) throws IOException {
        XMLIOSource source = new XMLIOSource(file);
        XMLParser parser = new XMLParser();
        return parser.parse(source);
    }
}

