/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.inject.Named;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageBundle;
import org.apache.deltaspike.core.api.message.MessageTemplate;
import org.apache.deltaspike.core.impl.message.MessageBundleContext;
import org.apache.deltaspike.core.impl.message.NamedMessageBundleInvocationHandler;
import org.apache.deltaspike.core.impl.message.NamedTypedMessageBundle;
import org.apache.deltaspike.core.impl.message.NamedTypedMessageBundleLiteral;
import org.apache.deltaspike.core.impl.message.TypedMessageBundle;
import org.apache.deltaspike.core.impl.message.TypedMessageBundleProducer;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.bean.ImmutableBeanWrapper;
import org.apache.deltaspike.core.util.bean.ImmutablePassivationCapableBeanWrapper;
import org.apache.deltaspike.core.util.bean.WrappingBeanBuilder;

public class MessageBundleExtension
implements Extension,
Deactivatable {
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private Bean<Object> bundleProducerBean;
    private Bean<Object> namedBundleProducerBean;
    private NamedTypedMessageBundle namedTypedMessageBundle = new NamedTypedMessageBundleLiteral();
    private boolean elSupportEnabled;
    private List<String> deploymentErrors = new ArrayList<String>();
    private Boolean isActivated = true;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        this.elSupportEnabled = ClassDeactivationUtils.isActivated(NamedMessageBundleInvocationHandler.class);
    }

    protected void detectInterfaces(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        AnnotatedType type = processAnnotatedType.getAnnotatedType();
        if (type.isAnnotationPresent(MessageBundle.class) && this.validateMessageBundle(type.getJavaClass())) {
            this.messageBundleTypes.add(type);
        }
    }

    private boolean validateMessageBundle(Class<?> currentClass) {
        boolean ok = true;
        if (!currentClass.isInterface()) {
            this.deploymentErrors.add("@MessageBundle must only be used on Interfaces, but got used on class " + currentClass.getName());
            return false;
        }
        for (Method currentMethod : currentClass.getDeclaredMethods()) {
            if (!currentMethod.isAnnotationPresent(MessageTemplate.class) || String.class.isAssignableFrom(currentMethod.getReturnType()) || Message.class.isAssignableFrom(currentMethod.getReturnType())) continue;
            this.deploymentErrors.add(currentMethod.getReturnType().getName() + " isn't supported. Details: " + currentMethod.getDeclaringClass().getName() + "#" + currentMethod.getName() + " only " + String.class.getName() + " or " + Message.class.getName());
            ok = false;
        }
        return ok;
    }

    protected void detectProducers(@Observes ProcessProducerMethod<Object, TypedMessageBundleProducer> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    @Deprecated
    protected void detectProducersInverted(@Observes ProcessProducerMethod<TypedMessageBundleProducer, Object> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    protected void captureProducers(AnnotatedMethod<?> method, Bean<?> bean) {
        if (method.isAnnotationPresent(TypedMessageBundle.class)) {
            this.bundleProducerBean = bean;
        } else if (method.isAnnotationPresent(NamedTypedMessageBundle.class)) {
            this.namedBundleProducerBean = bean;
        }
    }

    protected void installMessageBundleProducerBeans(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        if (!this.deploymentErrors.isEmpty()) {
            abd.addDefinitionError((Throwable)new IllegalArgumentException("The following MessageBundle problems where found: " + Arrays.toString(this.deploymentErrors.toArray())));
            return;
        }
        for (AnnotatedType<?> type : this.messageBundleTypes) {
            Bean<?> namedBean;
            abd.addBean(this.createMessageBundleBean(this.bundleProducerBean, type, beanManager));
            if (!this.elSupportEnabled || (namedBean = this.createNamedMessageBundleBean(this.namedBundleProducerBean, type, beanManager)).getName() == null) continue;
            abd.addBean(namedBean);
        }
    }

    private <T> Bean<T> createMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> annotatedType, BeanManager beanManager) {
        WrappingBeanBuilder beanBuilder = new WrappingBeanBuilder(delegate, beanManager).readFromType(annotatedType);
        if (this.elSupportEnabled) {
            beanBuilder.name(null);
        }
        beanBuilder.types(new Type[]{annotatedType.getJavaClass(), Object.class, Serializable.class});
        beanBuilder.passivationCapable(true);
        beanBuilder.id("MessageBundleBean#" + annotatedType.getJavaClass().getName());
        return beanBuilder.create();
    }

    private <T> Bean<T> createNamedMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> annotatedType, BeanManager beanManager) {
        WrappingBeanBuilder beanBuilder = new WrappingBeanBuilder<T>(delegate, beanManager){

            public ImmutableBeanWrapper<T> create() {
                final ImmutableBeanWrapper result = super.create();
                String beanName = this.createBeanName(result.getTypes());
                HashSet<Object> qualifiers = new HashSet<Object>();
                qualifiers.add(new AnyLiteral());
                qualifiers.add(MessageBundleExtension.this.namedTypedMessageBundle);
                if (this.isPassivationCapable()) {
                    return new ImmutablePassivationCapableBeanWrapper<T>((Bean)result, beanName, qualifiers, result.getScope(), result.getStereotypes(), result.getTypes(), result.isAlternative(), result.isNullable(), result.toString(), ((PassivationCapable)result).getId()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public T create(CreationalContext<T> creationalContext) {
                            MessageBundleContext.setBean((Bean)result);
                            try {
                                Object object = super.create(creationalContext);
                                return object;
                            }
                            finally {
                                MessageBundleContext.reset();
                            }
                        }
                    };
                }
                return new ImmutableBeanWrapper<T>((Bean)result, beanName, qualifiers, result.getScope(), result.getStereotypes(), result.getTypes(), result.isAlternative(), result.isNullable(), result.toString()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public T create(CreationalContext<T> creationalContext) {
                        MessageBundleContext.setBean((Bean)result);
                        try {
                            Object object = super.create(creationalContext);
                            return object;
                        }
                        finally {
                            MessageBundleContext.reset();
                        }
                    }
                };
            }

            private String createBeanName(Set<Type> types) {
                for (Type type : types) {
                    Named namedAnnotation;
                    if (!(type instanceof Class) || (namedAnnotation = ((Class)type).getAnnotation(Named.class)) == null) continue;
                    String result = namedAnnotation.value();
                    if (!"".equals(result)) {
                        return result;
                    }
                    return Introspector.decapitalize(((Class)type).getSimpleName());
                }
                return null;
            }
        };
        beanBuilder.readFromType(annotatedType);
        beanBuilder.types(new Type[]{annotatedType.getJavaClass(), Object.class, Serializable.class});
        beanBuilder.passivationCapable(true);
        beanBuilder.id("NamedMessageBundleBean#" + annotatedType.getJavaClass().getName());
        return beanBuilder.create();
    }

    protected void cleanup(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.messageBundleTypes.clear();
    }
}

