/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum MllpDecoderState {
    START(11, true){

        protected MllpDecoderState proceed() {
            return BODY;
        }

        protected void handleEndOfStream() throws IOException {
            LOG.info("End of input stream reached.");
            throw new SocketException("End of input stream reached before message starts");
        }
    }
    ,
    BODY(28, false){

        protected MllpDecoderState proceed() {
            return PREPARE_END;
        }

        protected void handleEndOfStream() throws IOException, LLPException {
            throw new LLPException("MLLP protocol violation - Stream ends in the message body");
        }
    }
    ,
    PREPARE_END(13, true){

        protected MllpDecoderState proceed() {
            return END;
        }

        protected void handleEndOfStream() throws IOException, LLPException {
            throw new LLPException("MLLP protocol violation - Stream ends before LLP end byte");
        }
    }
    ,
    END(0, false){

        protected MllpDecoderState proceed() {
            return END;
        }

        protected void handleEndOfStream() throws IOException, LLPException {
        }

        MllpDecoderState read(InputStream in, OutputStream out) throws IOException, LLPException {
            throw new LLPException("Internal error - reading after end of message");
        }
    };

    private int nextStateByte;
    private boolean mustChangeState;
    private static final Logger LOG;

    private MllpDecoderState(int nextStateByte, boolean mustChangeState) {
        this.nextStateByte = nextStateByte;
        this.mustChangeState = mustChangeState;
    }

    MllpDecoderState read(InputStream in, OutputStream out) throws SocketTimeoutException, IOException, LLPException {
        try {
            int c = in.read();
            if (c == -1) {
                this.handleEndOfStream();
            } else {
                LowerLayerProtocol.logCharacterReceived(c);
            }
            if (c == this.nextStateByte) {
                return this.proceed();
            }
            if (this.mustChangeState) {
                throw new LLPException("MLLP protocol violation - Expected byte '" + this.nextStateByte + "' in state " + (Object)((Object)this) + " but was '" + c + "'");
            }
            out.write(c);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (SocketException e) {
            LOG.info("SocketException on read() attempt.  Socket appears to have been closed: " + e.getMessage());
            throw e;
        }
        return this;
    }

    protected abstract MllpDecoderState proceed();

    protected abstract void handleEndOfStream() throws IOException, LLPException;

    static {
        LOG = LoggerFactory.getLogger(MllpDecoderState.class);
    }
}

