/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.EnsureRubyArrayInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpIndirectInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.Match2Instr;
import org.jruby.ir.instructions.Match3Instr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.MethodLookupInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.NotInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushBindingInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.instructions.ReceiveClosureInstr;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SetReturnAddressInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.BackrefIsMatchDataInstr;
import org.jruby.ir.instructions.defined.ClassVarIsDefinedInstr;
import org.jruby.ir.instructions.defined.GetBackrefInstr;
import org.jruby.ir.instructions.defined.GetDefinedConstantOrMethodInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.GlobalIsDefinedInstr;
import org.jruby.ir.instructions.defined.HasInstanceVarInstr;
import org.jruby.ir.instructions.defined.IsMethodBoundInstr;
import org.jruby.ir.instructions.defined.MethodDefinedInstr;
import org.jruby.ir.instructions.defined.MethodIsPublicInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.instructions.defined.SuperMethodBoundInstr;
import org.jruby.ir.instructions.ruby19.BuildLambdaInstr;
import org.jruby.ir.instructions.ruby19.GetEncodingInstr;
import org.jruby.ir.instructions.ruby19.ReceivePostReqdArgInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.BacktickString;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.BooleanLiteral;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.CompoundArray;
import org.jruby.ir.operands.CompoundString;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.MethodHandle;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public class JVMVisitor
extends IRVisitor {
    public static final String DYNAMIC_SCOPE = "$dynamicScope";
    private final JVM jvm = new JVM();
    private IRScriptBody script;
    private IRScope currentScope;

    public static Class compile(Ruby ruby2, IRScope scope, JRubyClassLoader jrubyClassLoader) {
        JVMVisitor target = new JVMVisitor();
        target.codegen(scope);
        return jrubyClassLoader.defineClass(JVM.scriptToClass(scope.getName()), target.code());
    }

    public byte[] code() {
        return this.jvm.code();
    }

    public void codegen(IRScope scope) {
        if (scope instanceof IRScriptBody) {
            this.codegen((IRScriptBody)scope);
        }
    }

    public void codegen(IRScriptBody script) {
        this.script = script;
        this.emit(script);
    }

    public String emitScope(IRScope scope, String name2, int arity2) {
        this.currentScope = scope;
        name2 = name2 + scope.getLineNumber();
        this.jvm.pushmethod(name2, arity2);
        Tuple<Instr[], Map<Integer, org.jruby.ir.operands.Label[]>> t = scope.prepareForCompilation();
        Instr[] instrs = (Instr[])t.a;
        Map jumpTable = (Map)t.b;
        IRBytecodeAdapter m = this.jvm.method();
        for (int i2 = 0; i2 < instrs.length; ++i2) {
            Instr instr = instrs[i2];
            if (jumpTable.get(i2) != null) {
                for (org.jruby.ir.operands.Label label2 : (org.jruby.ir.operands.Label[])jumpTable.get(i2)) {
                    m.mark(this.jvm.methodData().getLabel(label2));
                }
            }
            this.visit(instr);
        }
        this.jvm.popmethod();
        return name2;
    }

    public void emit(IRScriptBody script) {
        String clsName = JVM.scriptToClass(script.getName());
        this.jvm.pushscript(clsName, script.getFileName());
        this.emitScope(script, "__script__", 0);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    public void emit(IRMethod method2) {
        String name2 = this.emitScope(method2, method2.getName(), method2.getCallArgs().length);
        this.jvm.method().pushHandle(this.jvm.clsData().clsName, name2, method2.getStaticScope().getRequiredArgs());
    }

    public void emit(IRModuleBody method2) {
        String name2 = method2.getName();
        if (name2.indexOf("DUMMY_MC") != -1) {
            name2 = "METACLASS";
        }
        name2 = this.emitScope(method2, name2, 0);
        this.jvm.method().pushHandle(this.jvm.clsData().clsName, name2, method2.getStaticScope().getRequiredArgs());
    }

    @Override
    public void visit(Instr instr) {
        instr.visit(this);
    }

    @Override
    public void visit(Operand operand) {
        if (operand.hasKnownValue()) {
            operand.visit(this);
        } else if (operand instanceof Variable) {
            this.emitVariable((Variable)operand);
        } else {
            operand.visit(this);
        }
    }

    private int getJVMLocalVarIndex(Variable variable) {
        return this.jvm.methodData().local(variable);
    }

    private int getJVMLocalVarIndex(String specialVar) {
        return this.jvm.methodData().local(specialVar);
    }

    private Label getJVMLabel(org.jruby.ir.operands.Label label2) {
        return this.jvm.methodData().getLabel(label2);
    }

    private void jvmStoreLocal(Variable variable) {
        this.jvm.method().storeLocal(this.getJVMLocalVarIndex(variable));
    }

    private void jvmStoreLocal(String specialVar) {
        this.jvm.method().storeLocal(this.getJVMLocalVarIndex(specialVar));
    }

    private void jvmLoadLocal(Variable variable) {
        this.jvm.method().loadLocal(this.getJVMLocalVarIndex(variable));
    }

    private void jvmLoadLocal(String specialVar) {
        this.jvm.method().loadLocal(this.getJVMLocalVarIndex(specialVar));
    }

    public void emitVariable(Variable variable) {
        int index2 = this.getJVMLocalVarIndex(variable);
        this.jvm.method().loadLocal(index2);
    }

    @Override
    public void AliasInstr(AliasInstr aliasInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        m.loadLocal(0);
        m.loadLocal(this.getJVMLocalVarIndex(aliasInstr.getReceiver()));
        m.adapter.ldc(((StringLiteral)aliasInstr.getNewName()).string);
        m.adapter.ldc(((StringLiteral)aliasInstr.getOldName()).string);
        m.invokeHelper("defineAlias", IRubyObject.class, ThreadContext.class, IRubyObject.class, Object.class, Object.class);
        m.adapter.pop();
    }

    @Override
    public void AttrAssignInstr(AttrAssignInstr attrAssignInstr) {
        this.jvm.method().loadLocal(0);
        this.visit(attrAssignInstr.getReceiver());
        for (Operand operand : attrAssignInstr.getCallArgs()) {
            this.visit(operand);
        }
        this.jvm.method().invokeOther(attrAssignInstr.getMethodAddr().getName(), attrAssignInstr.getCallArgs().length);
        this.jvm.method().adapter.pop();
    }

    @Override
    public void BEQInstr(BEQInstr beqInstr) {
        Operand[] args2 = beqInstr.getOperands();
        this.jvm.method().loadLocal(0);
        this.visit(args2[0]);
        this.visit(args2[1]);
        this.jvm.method().invokeHelper("BEQ", Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvm.method().adapter.iftrue(this.getJVMLabel(beqInstr.getJumpTarget()));
    }

    @Override
    public void BFalseInstr(BFalseInstr bFalseInstr) {
        this.visit(bFalseInstr.getArg1());
        this.jvm.method().isTrue();
        this.jvm.method().bfalse(this.getJVMLabel(bFalseInstr.getJumpTarget()));
    }

    @Override
    public void BlockGivenInstr(BlockGivenInstr blockGivenInstr) {
        this.jvm.method().loadRuntime();
        this.visit(blockGivenInstr.getBlockArg());
        this.jvm.method().invokeVirtual(Type.getType(Block.class), Method.getMethod("boolean isGiven()"));
        this.jvm.method().invokeVirtual(Type.getType(Ruby.class), Method.getMethod("org.jruby.RubyBoolean newBoolean(boolean)"));
        this.jvmStoreLocal(blockGivenInstr.getResult());
    }

    @Override
    public void BNEInstr(BNEInstr bneinstr) {
        Operand[] args2 = bneinstr.getOperands();
        this.jvm.method().loadLocal(0);
        this.visit(args2[0]);
        this.visit(args2[1]);
        this.jvm.method().invokeHelper("BNE", Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvm.method().adapter.iftrue(this.getJVMLabel(bneinstr.getJumpTarget()));
    }

    @Override
    public void BNilInstr(BNilInstr bnilinstr) {
        this.visit(bnilinstr.getArg1());
        this.jvm.method().isNil();
        this.jvm.method().btrue(this.getJVMLabel(bnilinstr.getJumpTarget()));
    }

    @Override
    public void BreakInstr(BreakInstr breakInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        SkinnyMethodAdapter a = m.adapter;
        m.loadLocal(0);
        a.aload(1);
        m.invokeVirtual(Type.getType(IRScope.class), Method.getMethod("org.jruby.ir.IRScope getIRScope()"));
        a.ldc(breakInstr.getScopeToReturnTo().getScopeId());
        this.visit(breakInstr.getReturnValue());
        m.pushNil();
        a.invokestatic(CodegenUtils.p(IRubyObject.class), "initiateBreak", CodegenUtils.sig(ThreadContext.class, IRScope.class, IRScope.class, IRubyObject.class, Block.Type.class));
    }

    @Override
    public void BTrueInstr(BTrueInstr btrueinstr) {
        this.visit(btrueinstr.getArg1());
        this.jvm.method().isTrue();
        this.jvm.method().btrue(this.getJVMLabel(btrueinstr.getJumpTarget()));
    }

    @Override
    public void BUndefInstr(BUndefInstr bundefinstr) {
        this.visit(bundefinstr.getArg1());
        this.jvm.method().pushUndefined();
        this.jvm.method().adapter.if_acmpeq(this.getJVMLabel(bundefinstr.getJumpTarget()));
    }

    @Override
    public void CallInstr(CallInstr callInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        String name2 = callInstr.getMethodAddr().getName();
        Operand[] args2 = callInstr.getCallArgs();
        int numArgs = args2.length;
        if ((name2.equals("+") || name2.equals("-") || name2.equals("*") || name2.equals("/")) && numArgs == 1 && args2[0] instanceof Fixnum && callInstr.getCallType() == CallType.NORMAL) {
            m.loadLocal(0);
            m.loadLocal(2);
            this.visit(callInstr.getReceiver());
            m.invokeFixnumOp(name2, ((Fixnum)args2[0]).value);
        } else {
            m.loadLocal(0);
            this.visit(callInstr.getReceiver());
            for (Operand operand : args2) {
                this.visit(operand);
            }
            switch (callInstr.getCallType()) {
                case FUNCTIONAL: 
                case VARIABLE: {
                    m.invokeSelf(name2, numArgs);
                    break;
                }
                case NORMAL: {
                    m.invokeOther(name2, numArgs);
                    break;
                }
                case SUPER: {
                    m.invokeSuper(name2, numArgs);
                }
            }
        }
        this.jvmStoreLocal(callInstr.getResult());
    }

    @Override
    public void CheckArgsArrayArityInstr(CheckArgsArrayArityInstr checkargsarrayarityinstr) {
        this.jvm.method().loadContext();
        this.visit(checkargsarrayarityinstr.getArgsArray());
        this.jvm.method().adapter.pushInt(checkargsarrayarityinstr.required);
        this.jvm.method().adapter.pushInt(checkargsarrayarityinstr.opt);
        this.jvm.method().adapter.pushInt(checkargsarrayarityinstr.rest);
        this.jvm.method().invokeStatic(Type.getType(Helpers.class), Method.getMethod("void irCheckArgsArrayArity(org.jruby.runtime.ThreadContext, org.jruby.RubyArray, int, int, int)"));
    }

    @Override
    public void CheckArityInstr(CheckArityInstr checkarityinstr) {
    }

    @Override
    public void ClassSuperInstr(ClassSuperInstr classsuperinstr) {
        super.ClassSuperInstr(classsuperinstr);
    }

    @Override
    public void ConstMissingInstr(ConstMissingInstr constmissinginstr) {
        this.visit(constmissinginstr.getReceiver());
        this.jvm.method().adapter.checkcast("org/jruby/RubyModule");
        this.jvm.method().loadContext();
        this.jvm.method().adapter.ldc("const_missing");
        this.jvm.method().pushSymbol(constmissinginstr.getMissingConst());
        this.jvm.method().invokeVirtual(Type.getType(RubyModule.class), Method.getMethod("org.jruby.runtime.builtin.IRubyObject callMethod(org.jruby.runtime.ThreadContext, java.lang.String, org.jruby.runtime.builtin.IRubyObject)"));
    }

    @Override
    public void CopyInstr(CopyInstr copyinstr) {
        int index2 = this.getJVMLocalVarIndex(copyinstr.getResult());
        this.visit(copyinstr.getSource());
        this.jvm.method().storeLocal(index2);
    }

    @Override
    public void DefineClassInstr(DefineClassInstr defineclassinstr) {
        IRClassBody newIRClassBody = defineclassinstr.getNewIRClassBody();
        StaticScope scope = newIRClassBody.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = Helpers.encodeScope(scope);
        IRBytecodeAdapter m = this.jvm.method();
        SkinnyMethodAdapter a = m.adapter;
        a.newobj(CodegenUtils.p(CompiledIRMethod.class));
        a.dup();
        this.emit(newIRClassBody);
        a.ldc(newIRClassBody.getName());
        a.ldc(newIRClassBody.getFileName());
        a.ldc(newIRClassBody.getLineNumber());
        a.aload(0);
        a.ldc(newIRClassBody.getName());
        m.loadLocal(2);
        m.loadLocal(0);
        this.visit(defineclassinstr.getContainer());
        m.invokeHelper("checkIsRubyModule", RubyModule.class, ThreadContext.class, Object.class);
        if (defineclassinstr.getSuperClass() instanceof Nil) {
            a.aconst_null();
        } else {
            this.visit(defineclassinstr.getSuperClass());
        }
        a.ldc(newIRClassBody instanceof IRMetaClassBody);
        m.invokeHelper("newClassForIR", RubyClass.class, ThreadContext.class, String.class, IRubyObject.class, RubyModule.class, Object.class, Boolean.TYPE);
        a.aload(0);
        a.aload(1);
        a.ldc(scopeString);
        a.invokestatic(CodegenUtils.p(Helpers.class), "decodeScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        a.swap();
        a.dup2();
        a.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        a.getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        a.swap();
        a.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvmStoreLocal(defineclassinstr.getResult());
    }

    @Override
    public void DefineClassMethodInstr(DefineClassMethodInstr defineclassmethodinstr) {
        super.DefineClassMethodInstr(defineclassmethodinstr);
    }

    @Override
    public void DefineInstanceMethodInstr(DefineInstanceMethodInstr defineinstancemethodinstr) {
        IRMethod method2 = defineinstancemethodinstr.getMethod();
        StaticScope scope = method2.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = Helpers.encodeScope(scope);
        IRBytecodeAdapter m = this.jvm.method();
        SkinnyMethodAdapter a = m.adapter;
        a.aload(0);
        a.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRubyClass", "()Lorg/jruby/RubyModule;");
        a.ldc(method2.getName());
        a.newobj(CodegenUtils.p(CompiledIRMethod.class));
        a.dup();
        this.emit(method2);
        a.ldc(method2.getName());
        a.ldc(method2.getFileName());
        a.ldc(method2.getLineNumber());
        a.aload(0);
        a.aload(1);
        a.ldc(scopeString);
        a.invokestatic(CodegenUtils.p(Helpers.class), "decodeScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        a.aload(0);
        a.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentVisibility", "()Lorg/jruby/runtime/Visibility;");
        a.aload(0);
        a.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRubyClass", "()Lorg/jruby/RubyModule;");
        a.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        a.invokevirtual(CodegenUtils.p(RubyModule.class), "addMethod", "(Ljava/lang/String;Lorg/jruby/internal/runtime/methods/DynamicMethod;)V");
    }

    @Override
    public void DefineMetaClassInstr(DefineMetaClassInstr definemetaclassinstr) {
        IRModuleBody metaClassBody = definemetaclassinstr.getMetaClassBody();
        StaticScope scope = metaClassBody.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = Helpers.encodeScope(scope);
        IRBytecodeAdapter m = this.jvm.method();
        SkinnyMethodAdapter a = m.adapter;
        a.newobj(CodegenUtils.p(CompiledIRMethod.class));
        a.dup();
        this.emit(metaClassBody);
        a.ldc(metaClassBody.getName());
        a.ldc(metaClassBody.getFileName());
        a.ldc(metaClassBody.getLineNumber());
        a.aload(0);
        a.aload(1);
        a.ldc(scopeString);
        a.invokestatic(CodegenUtils.p(Helpers.class), "decodeScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        m.loadRuntime();
        this.visit(definemetaclassinstr.getObject());
        m.invokeHelper("getSingletonClass", RubyClass.class, Ruby.class, IRubyObject.class);
        a.dup2();
        a.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        a.getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        a.swap();
        a.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvmStoreLocal(definemetaclassinstr.getResult());
    }

    @Override
    public void DefineModuleInstr(DefineModuleInstr definemoduleinstr) {
        IRModuleBody newIRModuleBody = definemoduleinstr.getNewIRModuleBody();
        StaticScope scope = newIRModuleBody.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = Helpers.encodeScope(scope);
        IRBytecodeAdapter m = this.jvm.method();
        SkinnyMethodAdapter a = m.adapter;
        a.newobj(CodegenUtils.p(CompiledIRMethod.class));
        a.dup();
        this.emit(newIRModuleBody);
        a.ldc(newIRModuleBody.getName());
        a.ldc(newIRModuleBody.getFileName());
        a.ldc(newIRModuleBody.getLineNumber());
        a.aload(0);
        a.aload(1);
        a.ldc(scopeString);
        a.invokestatic(CodegenUtils.p(Helpers.class), "decodeScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        m.loadLocal(0);
        this.visit(definemoduleinstr.getContainer());
        m.invokeHelper("checkIsRubyModule", RubyModule.class, ThreadContext.class, Object.class);
        a.ldc(newIRModuleBody.getName());
        a.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, String.class));
        a.dup2();
        a.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        a.getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        a.swap();
        a.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvmStoreLocal(definemoduleinstr.getResult());
    }

    @Override
    public void EnsureRubyArrayInstr(EnsureRubyArrayInstr ensurerubyarrayinstr) {
        this.visit(ensurerubyarrayinstr.getObject());
        this.jvm.method().adapter.dup();
        Label after = new Label();
        this.jvm.method().adapter.instance_of("org/jruby/RubyArray");
        this.jvm.method().adapter.iftrue(after);
        this.jvm.method().adapter.swap();
        this.jvm.method().loadRuntime();
        this.jvm.method().adapter.ldc(false);
        this.jvm.method().invokeStatic(Type.getType(ArgsUtil.class), Method.getMethod("org.jruby.RubyArray convertToRubyArray(org.jruby.Ruby, org.jruby.runtime.builtin.IRubyObject, boolean)"));
        this.jvm.method().adapter.label(after);
        this.jvmStoreLocal(ensurerubyarrayinstr.getResult());
    }

    @Override
    public void EQQInstr(EQQInstr eqqinstr) {
        super.EQQInstr(eqqinstr);
    }

    @Override
    public void ExceptionRegionEndMarkerInstr(ExceptionRegionEndMarkerInstr exceptionregionendmarkerinstr) {
        throw new RuntimeException("Marker instructions shouldn't reach compiler: " + exceptionregionendmarkerinstr);
    }

    @Override
    public void ExceptionRegionStartMarkerInstr(ExceptionRegionStartMarkerInstr exceptionregionstartmarkerinstr) {
        throw new RuntimeException("Marker instructions shouldn't reach compiler: " + exceptionregionstartmarkerinstr);
    }

    @Override
    public void GetClassVarContainerModuleInstr(GetClassVarContainerModuleInstr getclassvarcontainermoduleinstr) {
        super.GetClassVarContainerModuleInstr(getclassvarcontainermoduleinstr);
    }

    @Override
    public void GetClassVariableInstr(GetClassVariableInstr getclassvariableinstr) {
        super.GetClassVariableInstr(getclassvariableinstr);
    }

    @Override
    public void GetFieldInstr(GetFieldInstr getfieldinstr) {
        this.visit(getfieldinstr.getSource());
        this.jvm.method().getField(getfieldinstr.getRef());
        this.jvmStoreLocal(getfieldinstr.getResult());
    }

    @Override
    public void GetGlobalVariableInstr(GetGlobalVariableInstr getglobalvariableinstr) {
        super.GetGlobalVariableInstr(getglobalvariableinstr);
    }

    @Override
    public void GVarAliasInstr(GVarAliasInstr gvaraliasinstr) {
        super.GVarAliasInstr(gvaraliasinstr);
    }

    @Override
    public void InheritanceSearchConstInstr(InheritanceSearchConstInstr inheritancesearchconstinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(inheritancesearchconstinstr.getCurrentModule());
        this.jvm.method().inheritanceSearchConst(inheritancesearchconstinstr.getConstName());
        this.jvmStoreLocal(inheritancesearchconstinstr.getResult());
    }

    @Override
    public void InstanceSuperInstr(InstanceSuperInstr instancesuperinstr) {
        super.InstanceSuperInstr(instancesuperinstr);
    }

    @Override
    public void JumpIndirectInstr(JumpIndirectInstr jumpindirectinstr) {
        super.JumpIndirectInstr(jumpindirectinstr);
    }

    @Override
    public void JumpInstr(JumpInstr jumpinstr) {
        this.jvm.method().goTo(this.getJVMLabel(jumpinstr.getJumpTarget()));
    }

    @Override
    public void LabelInstr(LabelInstr labelinstr) {
        this.jvm.method().mark(this.getJVMLabel(labelinstr.getLabel()));
    }

    @Override
    public void LexicalSearchConstInstr(LexicalSearchConstInstr lexicalsearchconstinstr) {
        super.LexicalSearchConstInstr(lexicalsearchconstinstr);
    }

    @Override
    public void LineNumberInstr(LineNumberInstr linenumberinstr) {
        this.jvm.method().adapter.line(linenumberinstr.getLineNumber());
    }

    @Override
    public void LoadLocalVarInstr(LoadLocalVarInstr loadlocalvarinstr) {
        IRBytecodeAdapter m = this.jvm.method();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        int depth = loadlocalvarinstr.getLocalVar().getScopeDepth();
        int location = loadlocalvarinstr.getLocalVar().getLocation() - 1;
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                    case 1: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                    case 2: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueTwoDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                    case 3: {
                        m.pushNil();
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueThreeDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                }
                m.adapter.pushInt(location);
                m.pushNil();
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class));
                return;
            }
        }
        m.adapter.pushInt(location);
        m.adapter.pushInt(depth);
        m.pushNil();
        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE, IRubyObject.class));
    }

    @Override
    public void Match2Instr(Match2Instr match2instr) {
        super.Match2Instr(match2instr);
    }

    @Override
    public void Match3Instr(Match3Instr match3instr) {
        super.Match3Instr(match3instr);
    }

    @Override
    public void MatchInstr(MatchInstr matchinstr) {
        super.MatchInstr(matchinstr);
    }

    @Override
    public void MethodLookupInstr(MethodLookupInstr methodlookupinstr) {
        throw new RuntimeException("Unsupported instruction: " + methodlookupinstr);
    }

    @Override
    public void ModuleVersionGuardInstr(ModuleVersionGuardInstr moduleversionguardinstr) {
        throw new RuntimeException("Unsupported instruction: " + moduleversionguardinstr);
    }

    @Override
    public void NopInstr(NopInstr nopinstr) {
    }

    @Override
    public void NoResultCallInstr(NoResultCallInstr noResultCallInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        m.loadLocal(0);
        this.visit(noResultCallInstr.getReceiver());
        for (Operand operand : noResultCallInstr.getCallArgs()) {
            this.visit(operand);
        }
        switch (noResultCallInstr.getCallType()) {
            case FUNCTIONAL: 
            case VARIABLE: {
                m.invokeSelf(noResultCallInstr.getMethodAddr().getName(), noResultCallInstr.getCallArgs().length);
                break;
            }
            case NORMAL: {
                m.invokeOther(noResultCallInstr.getMethodAddr().getName(), noResultCallInstr.getCallArgs().length);
                break;
            }
            case SUPER: {
                m.invokeSuper(noResultCallInstr.getMethodAddr().getName(), noResultCallInstr.getCallArgs().length);
            }
        }
        m.adapter.pop();
    }

    @Override
    public void NotInstr(NotInstr instr) {
        this.visit(instr.getOperands()[0]);
        this.jvm.method().invokeHelper("irNot", IRubyObject.class, ThreadContext.class, IRubyObject.class);
    }

    @Override
    public void OptArgMultipleAsgnInstr(OptArgMultipleAsgnInstr optargmultipleasgninstr) {
        super.OptArgMultipleAsgnInstr(optargmultipleasgninstr);
    }

    @Override
    public void PopBindingInstr(PopBindingInstr popbindinginstr) {
    }

    @Override
    public void ProcessModuleBodyInstr(ProcessModuleBodyInstr processmodulebodyinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(processmodulebodyinstr.getModuleBody());
        this.jvm.method().invokeHelper("invokeModuleBody", IRubyObject.class, ThreadContext.class, CompiledIRMethod.class);
        this.jvmStoreLocal(processmodulebodyinstr.getResult());
    }

    @Override
    public void PushBindingInstr(PushBindingInstr pushbindinginstr) {
        this.jvm.method().loadStaticScope();
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(DynamicScope.class), "newDynamicScope", CodegenUtils.sig(DynamicScope.class, StaticScope.class));
        this.jvmStoreLocal(DYNAMIC_SCOPE);
    }

    @Override
    public void PutClassVariableInstr(PutClassVariableInstr putclassvariableinstr) {
        super.PutClassVariableInstr(putclassvariableinstr);
    }

    @Override
    public void PutConstInstr(PutConstInstr putconstinstr) {
        IRBytecodeAdapter m = this.jvm.method();
        this.visit(putconstinstr.getTarget());
        m.adapter.checkcast(CodegenUtils.p(RubyModule.class));
        m.adapter.ldc(putconstinstr.getRef());
        this.visit(putconstinstr.getValue());
        m.adapter.invokevirtual(CodegenUtils.p(RubyModule.class), "setConstant", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
        m.adapter.pop();
    }

    @Override
    public void PutFieldInstr(PutFieldInstr putfieldinstr) {
        this.visit(putfieldinstr.getTarget());
        this.visit(putfieldinstr.getValue());
        this.jvm.method().putField(putfieldinstr.getRef());
    }

    @Override
    public void PutGlobalVarInstr(PutGlobalVarInstr putglobalvarinstr) {
        super.PutGlobalVarInstr(putglobalvarinstr);
    }

    @Override
    public void RaiseArgumentErrorInstr(RaiseArgumentErrorInstr raiseargumenterrorinstr) {
        super.RaiseArgumentErrorInstr(raiseargumenterrorinstr);
    }

    @Override
    public void ReceiveClosureInstr(ReceiveClosureInstr receiveclosureinstr) {
    }

    @Override
    public void ReceiveExceptionInstr(ReceiveExceptionInstr receiveexceptioninstr) {
    }

    @Override
    public void ReceivePreReqdArgInstr(ReceivePreReqdArgInstr instr) {
        int index2 = this.getJVMLocalVarIndex(instr.getResult());
        this.jvm.method().loadLocal(3 + instr.getArgIndex());
        this.jvm.method().storeLocal(index2);
    }

    @Override
    public void ReceiveOptArgInstr(ReceiveOptArgInstr instr) {
        this.jvm.method().adapter.pushInt(instr.getArgIndex() + instr.numUsedArgs);
        this.jvm.method().adapter.pushInt(instr.getArgIndex() + instr.argOffset);
        this.jvm.method().adapter.aload(3);
        this.jvm.method().invokeHelper("irLoadOptArg", IRubyObject.class, Integer.TYPE, Integer.TYPE, IRubyObject[].class);
    }

    @Override
    public void ReceivePostReqdArgInstr(ReceivePostReqdArgInstr instr) {
        this.jvm.method().loadContext();
        this.jvm.method().adapter.pushInt(instr.getArgIndex());
        this.jvm.method().adapter.pushInt(instr.preReqdArgsCount);
        this.jvm.method().adapter.pushInt(instr.postReqdArgsCount);
        this.jvm.method().adapter.aload(3);
        this.jvm.method().invokeHelper("irLoadPostReqdArg", IRubyObject.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, IRubyObject[].class);
    }

    @Override
    public void ReceiveRestArgInstr(ReceiveRestArgInstr instr) {
        this.jvm.method().loadContext();
        this.jvm.method().adapter.pushInt(instr.numUsedArgs);
        this.jvm.method().adapter.pushInt(instr.getArgIndex());
        this.jvm.method().adapter.aload(3);
        this.jvm.method().invokeHelper("irLoadRestArg", IRubyObject.class, ThreadContext.class, Integer.TYPE, Integer.TYPE, IRubyObject[].class);
    }

    @Override
    public void ReceiveSelfInstr(ReceiveSelfInstr receiveselfinstr) {
        throw new RuntimeException("Self instr should have been stripped: " + receiveselfinstr);
    }

    @Override
    public void RecordEndBlockInstr(RecordEndBlockInstr recordendblockinstr) {
        super.RecordEndBlockInstr(recordendblockinstr);
    }

    @Override
    public void ReqdArgMultipleAsgnInstr(ReqdArgMultipleAsgnInstr reqdargmultipleasgninstr) {
        this.jvm.method().loadContext();
        this.visit(reqdargmultipleasgninstr.getArrayArg());
        this.jvm.method().adapter.checkcast("org/jruby/RubyArray");
        this.jvm.method().adapter.pushInt(reqdargmultipleasgninstr.getPreArgsCount());
        this.jvm.method().adapter.pushInt(reqdargmultipleasgninstr.getIndex());
        this.jvm.method().adapter.pushInt(reqdargmultipleasgninstr.getPostArgsCount());
        this.jvm.method().invokeHelper("irReqdArgMultipleAsgn", IRubyObject.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        this.jvmStoreLocal(reqdargmultipleasgninstr.getResult());
    }

    @Override
    public void RescueEQQInstr(RescueEQQInstr rescueeqqinstr) {
        super.RescueEQQInstr(rescueeqqinstr);
    }

    @Override
    public void RestArgMultipleAsgnInstr(RestArgMultipleAsgnInstr restargmultipleasgninstr) {
        super.RestArgMultipleAsgnInstr(restargmultipleasgninstr);
    }

    @Override
    public void NonlocalReturnInstr(NonlocalReturnInstr returninstr) {
        if (this.currentScope instanceof IRClosure) {
            SkinnyMethodAdapter a = this.jvm.method().adapter;
            a.aload(0);
            a.aload(1);
            this.visit(returninstr.getReturnValue());
        } else if (returninstr.methodToReturnFrom == null) {
            this.visit(returninstr.getReturnValue());
            this.jvm.method().returnValue();
        }
    }

    @Override
    public void ReturnInstr(ReturnInstr returninstr) {
        this.visit(returninstr.getReturnValue());
        this.jvm.method().returnValue();
    }

    @Override
    public void SearchConstInstr(SearchConstInstr searchconstinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(searchconstinstr.getStartingScope());
        this.jvm.method().searchConst(searchconstinstr.getConstName());
        this.jvmStoreLocal(searchconstinstr.getResult());
    }

    @Override
    public void SetReturnAddressInstr(SetReturnAddressInstr setreturnaddressinstr) {
        super.SetReturnAddressInstr(setreturnaddressinstr);
    }

    @Override
    public void StoreLocalVarInstr(StoreLocalVarInstr storelocalvarinstr) {
        IRBytecodeAdapter m = this.jvm.method();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        int depth = storelocalvarinstr.getLocalVar().getScopeDepth();
        int location = storelocalvarinstr.getLocalVar().getLocation() - 1;
        Operand storeValue = storelocalvarinstr.getValue();
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 1: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 2: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 3: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                }
                storeValue.visit(this);
                m.adapter.pushInt(location);
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Integer.TYPE));
                m.adapter.pop();
                return;
            }
        }
        m.adapter.pushInt(depth);
        storeValue.visit(this);
        m.adapter.pushInt(location);
        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class, Integer.TYPE));
        m.adapter.pop();
    }

    @Override
    public void ThreadPollInstr(ThreadPollInstr threadpollinstr) {
        this.jvm.method().poll();
    }

    @Override
    public void ThrowExceptionInstr(ThrowExceptionInstr throwexceptioninstr) {
    }

    @Override
    public void ToAryInstr(ToAryInstr toaryinstr) {
        this.jvm.method().loadContext();
        this.visit(toaryinstr.getArrayArg());
        this.jvm.method().adapter.ldc(toaryinstr.dontToAryArrays());
        this.jvm.method().invokeHelper("irToAry", IRubyObject.class, ThreadContext.class, IRubyObject.class, Boolean.TYPE);
        this.jvmStoreLocal(toaryinstr.getResult());
    }

    @Override
    public void UndefMethodInstr(UndefMethodInstr undefmethodinstr) {
        super.UndefMethodInstr(undefmethodinstr);
    }

    @Override
    public void UnresolvedSuperInstr(UnresolvedSuperInstr unresolvedsuperinstr) {
        super.UnresolvedSuperInstr(unresolvedsuperinstr);
    }

    @Override
    public void YieldInstr(YieldInstr yieldinstr) {
        this.visit(yieldinstr.getBlockArg());
        this.jvm.method().loadLocal(0);
        if (yieldinstr.getYieldArg() == UndefinedValue.UNDEFINED) {
            this.jvm.method().adapter.invokevirtual(CodegenUtils.p(Block.class), "yieldSpecific", CodegenUtils.sig(IRubyObject.class, ThreadContext.class));
        } else {
            this.visit(yieldinstr.getYieldArg());
            this.jvm.method().adapter.invokevirtual(CodegenUtils.p(Block.class), "yield", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        }
        this.jvmStoreLocal(yieldinstr.getResult());
    }

    @Override
    public void ZSuperInstr(ZSuperInstr zsuperinstr) {
        super.ZSuperInstr(zsuperinstr);
    }

    @Override
    public void BackrefIsMatchDataInstr(BackrefIsMatchDataInstr backrefismatchdatainstr) {
        super.BackrefIsMatchDataInstr(backrefismatchdatainstr);
    }

    @Override
    public void ClassVarIsDefinedInstr(ClassVarIsDefinedInstr classvarisdefinedinstr) {
        super.ClassVarIsDefinedInstr(classvarisdefinedinstr);
    }

    @Override
    public void GetBackrefInstr(GetBackrefInstr getbackrefinstr) {
        super.GetBackrefInstr(getbackrefinstr);
    }

    @Override
    public void GetDefinedConstantOrMethodInstr(GetDefinedConstantOrMethodInstr getdefinedconstantormethodinstr) {
        super.GetDefinedConstantOrMethodInstr(getdefinedconstantormethodinstr);
    }

    @Override
    public void GetErrorInfoInstr(GetErrorInfoInstr geterrorinfoinstr) {
        super.GetErrorInfoInstr(geterrorinfoinstr);
    }

    @Override
    public void GlobalIsDefinedInstr(GlobalIsDefinedInstr globalisdefinedinstr) {
        super.GlobalIsDefinedInstr(globalisdefinedinstr);
    }

    @Override
    public void HasInstanceVarInstr(HasInstanceVarInstr hasinstancevarinstr) {
        IRBytecodeAdapter m = this.jvm.method();
        m.loadRuntime();
        this.visit(hasinstancevarinstr.getObject());
        m.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
        m.adapter.ldc(hasinstancevarinstr.getName().string);
        m.adapter.invokeinterface(CodegenUtils.p(InstanceVariables.class), "hasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, String.class));
        m.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newBoolean", CodegenUtils.sig(RubyBoolean.class, Boolean.TYPE));
        this.jvmStoreLocal(hasinstancevarinstr.getResult());
    }

    @Override
    public void IsMethodBoundInstr(IsMethodBoundInstr ismethodboundinstr) {
        super.IsMethodBoundInstr(ismethodboundinstr);
    }

    @Override
    public void MethodDefinedInstr(MethodDefinedInstr methoddefinedinstr) {
        super.MethodDefinedInstr(methoddefinedinstr);
    }

    @Override
    public void MethodIsPublicInstr(MethodIsPublicInstr methodispublicinstr) {
        super.MethodIsPublicInstr(methodispublicinstr);
    }

    @Override
    public void RestoreErrorInfoInstr(RestoreErrorInfoInstr restoreerrorinfoinstr) {
        super.RestoreErrorInfoInstr(restoreerrorinfoinstr);
    }

    @Override
    public void SuperMethodBoundInstr(SuperMethodBoundInstr supermethodboundinstr) {
        super.SuperMethodBoundInstr(supermethodboundinstr);
    }

    @Override
    public void BuildLambdaInstr(BuildLambdaInstr buildlambdainstr) {
        super.BuildLambdaInstr(buildlambdainstr);
    }

    @Override
    public void GetEncodingInstr(GetEncodingInstr getencodinginstr) {
        super.GetEncodingInstr(getencodinginstr);
    }

    @Override
    public void Array(Array array) {
        this.jvm.method().loadLocal(0);
        for (Operand operand : array.getElts()) {
            this.visit(operand);
        }
        this.jvm.method().array(array.getElts().length);
    }

    @Override
    public void AsString(AsString asstring) {
        this.visit(asstring.getSource());
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
    }

    @Override
    public void Backref(Backref backref) {
        super.Backref(backref);
    }

    @Override
    public void BacktickString(BacktickString backtickstring) {
        super.BacktickString(backtickstring);
    }

    @Override
    public void Bignum(Bignum bignum) {
        super.Bignum(bignum);
    }

    @Override
    public void BooleanLiteral(BooleanLiteral booleanliteral) {
        this.jvm.method().pushBoolean(booleanliteral.isTrue());
    }

    @Override
    public void ClosureLocalVariable(ClosureLocalVariable closurelocalvariable) {
        super.ClosureLocalVariable(closurelocalvariable);
    }

    @Override
    public void CompoundArray(CompoundArray compoundarray) {
        this.visit(compoundarray.getAppendingArg());
        if (compoundarray.isArgsPush()) {
            this.jvm.method().adapter.checkcast("org/jruby/RubyArray");
        }
        this.visit(compoundarray.getAppendedArg());
        if (compoundarray.isArgsPush()) {
            this.jvm.method().invokeHelper("argsPush", RubyArray.class, RubyArray.class, IRubyObject.class);
        } else {
            this.jvm.method().invokeHelper("argsCat", RubyArray.class, IRubyObject.class, IRubyObject.class);
        }
    }

    @Override
    public void CompoundString(CompoundString compoundstring) {
        super.CompoundString(compoundstring);
    }

    @Override
    public void CurrentScope(CurrentScope currentscope) {
        this.jvm.method().adapter.aload(1);
    }

    @Override
    public void DynamicSymbol(DynamicSymbol dynamicsymbol) {
        super.DynamicSymbol(dynamicsymbol);
    }

    @Override
    public void Fixnum(Fixnum fixnum) {
        this.jvm.method().pushFixnum(fixnum.getValue());
    }

    @Override
    public void Float(Float flote) {
        this.jvm.method().pushFloat(flote.getValue());
    }

    @Override
    public void GlobalVariable(GlobalVariable globalvariable) {
        super.GlobalVariable(globalvariable);
    }

    @Override
    public void Hash(Hash hash2) {
        super.Hash(hash2);
    }

    @Override
    public void IRException(IRException irexception) {
        super.IRException(irexception);
    }

    @Override
    public void MethAddr(MethAddr methaddr) {
        this.jvm.method().adapter.ldc(methaddr.getName());
    }

    @Override
    public void MethodHandle(MethodHandle methodhandle) {
        throw new RuntimeException("Unsupported operand: " + methodhandle);
    }

    @Override
    public void Nil(Nil nil) {
        this.jvm.method().pushNil();
    }

    @Override
    public void NthRef(NthRef nthref) {
        super.NthRef(nthref);
    }

    @Override
    public void ObjectClass(ObjectClass objectclass) {
        this.jvm.method().pushObjectClass();
    }

    @Override
    public void Range(Range range) {
        this.jvm.method().loadRuntime();
        this.jvm.method().loadContext();
        this.visit(range.getBegin());
        this.visit(range.getEnd());
        this.jvm.method().adapter.ldc(range.isExclusive());
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Boolean.TYPE));
    }

    @Override
    public void Regexp(Regexp regexp2) {
        super.Regexp(regexp2);
    }

    @Override
    public void ScopeModule(ScopeModule scopemodule) {
        this.jvm.method().adapter.aload(1);
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class, new Class[0]));
    }

    @Override
    public void Self(Self self2) {
        this.jvm.method().loadLocal(2);
    }

    @Override
    public void Splat(Splat splat) {
        this.jvm.method().loadContext();
        this.visit(splat.getArray());
        this.jvm.method().invokeHelper("irSplat", RubyArray.class, ThreadContext.class, IRubyObject.class);
    }

    @Override
    public void StandardError(StandardError standarderror) {
        this.jvm.method().loadRuntime();
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(Ruby.class), "getStandardError", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    @Override
    public void StringLiteral(StringLiteral stringliteral) {
        this.jvm.method().pushString(stringliteral.getByteList());
    }

    @Override
    public void SValue(SValue svalue) {
        super.SValue(svalue);
    }

    @Override
    public void Symbol(Symbol symbol) {
        this.jvm.method().pushSymbol(symbol.getName());
    }

    @Override
    public void TemporaryClosureVariable(TemporaryClosureVariable temporaryclosurevariable) {
        super.TemporaryClosureVariable(temporaryclosurevariable);
    }

    @Override
    public void TemporaryVariable(TemporaryVariable temporaryvariable) {
        this.jvmLoadLocal(temporaryvariable);
    }

    @Override
    public void UndefinedValue(UndefinedValue undefinedvalue) {
        this.jvm.method().pushUndefined();
    }

    @Override
    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should never be directly executed!");
    }

    @Override
    public void WrappedIRClosure(WrappedIRClosure wrappedirclosure) {
        super.WrappedIRClosure(wrappedirclosure);
    }
}

