/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.security.auth.login.CredentialException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTPacketIdGenerator;
import org.apache.activemq.transport.mqtt.MQTTProtocolException;
import org.apache.activemq.transport.mqtt.MQTTProtocolSupport;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.apache.activemq.transport.mqtt.strategy.MQTTSubscriptionStrategy;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.LRUCache;
import org.apache.activemq.util.LongSequenceGenerator;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.CONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PINGRESP;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBACK;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTProtocolConverter.class);
    public static final String QOS_PROPERTY_NAME = "ActiveMQ.MQTT.QoS";
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final MQTTFrame PING_RESP_FRAME = new PINGRESP().encode();
    private static final double MQTT_KEEP_ALIVE_GRACE_PERIOD = 0.5;
    static final int DEFAULT_CACHE_SIZE = 5000;
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator publisherIdGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();
    private final Map<String, ActiveMQDestination> activeMQDestinationMap = new LRUCache(5000);
    private final Map<Destination, String> mqttTopicMap = new LRUCache(5000);
    private final Map<Short, MessageAck> consumerAcks = new LRUCache(5000);
    private final Map<Short, PUBREC> publisherRecs = new LRUCache(5000);
    private final MQTTTransport mqttTransport;
    private final BrokerService brokerService;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final ConnectionInfo connectionInfo = new ConnectionInfo();
    private CONNECT connect;
    private String clientId;
    private long defaultKeepAlive;
    private int activeMQSubscriptionPrefetch = -1;
    private final MQTTPacketIdGenerator packetIdGenerator;
    private boolean publishDollarTopics;
    private final FactoryFinder STRATAGY_FINDER = new FactoryFinder("META-INF/services/org/apache/activemq/transport/strategies/");
    private String subscriptionStrategyName = "mqtt-default-subscriptions";
    private MQTTSubscriptionStrategy subsciptionStrategy;
    boolean willSent = false;

    public MQTTProtocolConverter(MQTTTransport mqttTransport, BrokerService brokerService) {
        this.mqttTransport = mqttTransport;
        this.brokerService = brokerService;
        this.packetIdGenerator = MQTTPacketIdGenerator.getMQTTPacketIdGenerator(brokerService);
        this.defaultKeepAlive = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    public void sendToActiveMQ(Command command, ResponseHandler handler) {
        block7: {
            if (command instanceof ActiveMQMessage) {
                ActiveMQMessage msg = (ActiveMQMessage)command;
                try {
                    if (this.getPublishDollarTopics() || !this.findSubscriptionStrategy().isControlTopic(msg.getDestination())) break block7;
                    if (handler != null) {
                        try {
                            handler.onResponse(this, new Response());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.getMQTTTransport().sendToActiveMQ(command);
    }

    void sendToMQTT(MQTTFrame frame) {
        try {
            this.mqttTransport.sendToMQTT(frame);
        }
        catch (IOException e) {
            LOG.warn("Failed to send frame " + frame, (Throwable)e);
        }
    }

    public void onMQTTCommand(MQTTFrame frame) throws IOException, JMSException {
        switch (frame.messageType()) {
            case 12: {
                LOG.debug("Received a ping from client: " + this.getClientId());
                this.sendToMQTT(PING_RESP_FRAME);
                LOG.debug("Sent Ping Response to " + this.getClientId());
                break;
            }
            case 1: {
                CONNECT connect = new CONNECT().decode(frame);
                this.onMQTTConnect(connect);
                LOG.debug("MQTT Client {} connected. (version: {})", (Object)this.getClientId(), (Object)connect.version());
                break;
            }
            case 14: {
                LOG.debug("MQTT Client {} disconnecting", (Object)this.getClientId());
                this.onMQTTDisconnect();
                break;
            }
            case 8: {
                this.onSubscribe(new SUBSCRIBE().decode(frame));
                break;
            }
            case 10: {
                this.onUnSubscribe(new UNSUBSCRIBE().decode(frame));
                break;
            }
            case 3: {
                this.onMQTTPublish(new PUBLISH().decode(frame));
                break;
            }
            case 4: {
                this.onMQTTPubAck(new PUBACK().decode(frame));
                break;
            }
            case 5: {
                this.onMQTTPubRec(new PUBREC().decode(frame));
                break;
            }
            case 6: {
                this.onMQTTPubRel(new PUBREL().decode(frame));
                break;
            }
            case 7: {
                this.onMQTTPubComp(new PUBCOMP().decode(frame));
                break;
            }
            default: {
                this.handleException(new MQTTProtocolException("Unknown MQTTFrame type: " + frame.messageType(), true), frame);
            }
        }
    }

    void onMQTTConnect(final CONNECT connect) throws MQTTProtocolException {
        if (this.connected.get()) {
            throw new MQTTProtocolException("Already connected.");
        }
        this.connect = connect;
        String clientId = "";
        if (connect.clientId() != null) {
            clientId = connect.clientId().toString();
        }
        String userName = null;
        if (connect.userName() != null) {
            userName = connect.userName().toString();
        }
        String passswd = null;
        if (connect.password() != null) {
            passswd = connect.password().toString();
        }
        this.configureInactivityMonitor(connect.keepAlive());
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        } else {
            if (!connect.cleanSession()) {
                CONNACK ack = new CONNACK();
                ack.code(CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
                try {
                    this.getMQTTTransport().sendToMQTT(ack.encode());
                    this.getMQTTTransport().onException(IOExceptionSupport.create((String)"Invalid Client ID", null));
                }
                catch (IOException e) {
                    this.getMQTTTransport().onException(IOExceptionSupport.create((Exception)e));
                }
                return;
            }
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(userName);
        this.connectionInfo.setPassword(passswd);
        this.connectionInfo.setTransportContext((Object)this.mqttTransport.getPeerCertificates());
        this.sendToActiveMQ((Command)this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    CONNACK ack = new CONNACK();
                    if (exception instanceof InvalidClientIDException) {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
                    } else if (exception instanceof SecurityException) {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_NOT_AUTHORIZED);
                    } else if (exception instanceof CredentialException) {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                    } else {
                        ack.code(CONNACK.Code.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
                    }
                    MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                    MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create((Throwable)exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(MQTTProtocolConverter.this.sessionId);
                MQTTProtocolConverter.this.sendToActiveMQ((Command)sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(MQTTProtocolConverter.this.producerId);
                MQTTProtocolConverter.this.sendToActiveMQ((Command)producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            CONNACK ack = new CONNACK();
                            ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                            MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                            MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create((Throwable)exception));
                            return;
                        }
                        CONNACK ack = new CONNACK();
                        ack.code(CONNACK.Code.CONNECTION_ACCEPTED);
                        MQTTProtocolConverter.this.connected.set(true);
                        MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                        if (connect.cleanSession()) {
                            MQTTProtocolConverter.this.packetIdGenerator.stopClientSession(MQTTProtocolConverter.this.getClientId());
                        } else {
                            MQTTProtocolConverter.this.packetIdGenerator.startClientSession(MQTTProtocolConverter.this.getClientId());
                        }
                        MQTTProtocolConverter.this.findSubscriptionStrategy().onConnect(connect);
                    }
                });
            }
        });
    }

    void onMQTTDisconnect() throws MQTTProtocolException {
        if (this.connected.get()) {
            this.connected.set(false);
            this.sendToActiveMQ((Command)this.connectionInfo.createRemoveCommand(), null);
            this.sendToActiveMQ((Command)new ShutdownInfo(), null);
        }
        this.stopTransport();
    }

    void onSubscribe(SUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        LOG.trace("MQTT SUBSCRIBE message:{} client:{} connection:{}", new Object[]{command.messageId(), this.clientId, this.connectionInfo.getConnectionId()});
        Topic[] topics = command.topics();
        if (topics != null) {
            byte[] qos = new byte[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                try {
                    qos[i] = this.findSubscriptionStrategy().onSubscribe(topics[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new MQTTProtocolException("Failed to process subscription request", true, e);
                }
            }
            SUBACK ack = new SUBACK();
            ack.messageId(command.messageId());
            ack.grantedQos(qos);
            try {
                this.getMQTTTransport().sendToMQTT(ack.encode());
            }
            catch (IOException e) {
                LOG.warn("Couldn't send SUBACK for " + command, (Throwable)e);
            }
        } else {
            LOG.warn("No topics defined for Subscription " + command);
        }
    }

    public void onUnSubscribe(UNSUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        UTF8Buffer[] topics = command.topics();
        if (topics != null) {
            for (UTF8Buffer topic : topics) {
                try {
                    this.findSubscriptionStrategy().onUnSubscribe(topic.toString());
                }
                catch (IOException e) {
                    throw new MQTTProtocolException("Failed to process unsubscribe request", true, e);
                }
            }
        }
        UNSUBACK ack = new UNSUBACK();
        ack.messageId(command.messageId());
        this.sendToMQTT(ack.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActiveMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            MQTTSubscription sub = this.findSubscriptionStrategy().getSubscription(md.getConsumerId());
            if (sub != null) {
                MessageAck ack = sub.createMessageAck(md);
                PUBLISH publish = sub.createPublish((ActiveMQMessage)md.getMessage());
                switch (publish.qos()) {
                    case AT_LEAST_ONCE: 
                    case EXACTLY_ONCE: {
                        publish.dup(publish.dup() ? true : md.getMessage().isRedelivered());
                    }
                }
                if (ack != null && sub.expectAck(publish)) {
                    Map<Short, MessageAck> map = this.consumerAcks;
                    synchronized (map) {
                        this.consumerAcks.put(publish.messageId(), ack);
                    }
                }
                LOG.trace("MQTT Snd PUBLISH message:{} client:{} connection:{}", new Object[]{publish.messageId(), this.clientId, this.connectionInfo.getConnectionId()});
                this.getMQTTTransport().sendToMQTT(publish.encode());
                if (ack != null && !sub.expectAck(publish)) {
                    this.getMQTTTransport().sendToActiveMQ((Command)ack);
                }
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process ActiveMQ Command {}", (Object)command);
        }
    }

    void onMQTTPublish(PUBLISH command) throws IOException, JMSException {
        this.checkConnected();
        LOG.trace("MQTT Rcv PUBLISH message:{} client:{} connection:{}", new Object[]{command.messageId(), this.clientId, this.connectionInfo.getConnectionId()});
        ActiveMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        message.onSend();
        this.sendToActiveMQ((Command)message, this.createResponseHandler(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubAck(PUBACK command) {
        MessageAck ack;
        short messageId = command.messageId();
        LOG.trace("MQTT Rcv PUBACK message:{} client:{} connection:{}", new Object[]{messageId, this.clientId, this.connectionInfo.getConnectionId()});
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToActiveMQ((Command)ack);
        }
    }

    void onMQTTPubRec(PUBREC commnand) {
        PUBREL pubrel = new PUBREL();
        pubrel.messageId(commnand.messageId());
        this.sendToMQTT(pubrel.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubRel(PUBREL command) {
        PUBREC ack;
        Map<Short, PUBREC> map = this.publisherRecs;
        synchronized (map) {
            ack = this.publisherRecs.remove(command.messageId());
        }
        if (ack == null) {
            LOG.warn("Unknown PUBREL: {} received", (Object)command.messageId());
        }
        PUBCOMP pubcomp = new PUBCOMP();
        pubcomp.messageId(command.messageId());
        this.sendToMQTT(pubcomp.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubComp(PUBCOMP command) {
        MessageAck ack;
        short messageId = command.messageId();
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToActiveMQ((Command)ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActiveMQMessage convertMessage(PUBLISH command) throws JMSException {
        ActiveMQDestination destination;
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        msg.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.publisherIdGenerator.getNextSequenceId());
        msg.setMessageId(id);
        LOG.trace("MQTT-->ActiveMQ: MQTT_MSGID:{} client:{} connection:{} ActiveMQ_MSGID:{}", new Object[]{command.messageId(), this.clientId, this.connectionInfo.getConnectionId(), msg.getMessageId()});
        msg.setTimestamp(System.currentTimeMillis());
        msg.setPriority((byte)4);
        msg.setPersistent(command.qos() != QoS.AT_MOST_ONCE && !command.retain());
        msg.setIntProperty(QOS_PROPERTY_NAME, command.qos().ordinal());
        if (command.retain()) {
            msg.setBooleanProperty("ActiveMQ.Retain", true);
        }
        Map<String, ActiveMQDestination> map = this.activeMQDestinationMap;
        synchronized (map) {
            destination = this.activeMQDestinationMap.get(command.topicName());
            if (destination == null) {
                String topicName = MQTTProtocolSupport.convertMQTTToActiveMQ(command.topicName().toString());
                try {
                    destination = this.findSubscriptionStrategy().onSend(topicName);
                }
                catch (IOException e) {
                    throw JMSExceptionSupport.create((Exception)e);
                }
                this.activeMQDestinationMap.put(command.topicName().toString(), destination);
            }
        }
        msg.setJMSDestination((Destination)destination);
        msg.writeBytes(command.payload().data, command.payload().offset, command.payload().length);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PUBLISH convertMessage(ActiveMQMessage message) throws IOException, JMSException, DataFormatException {
        ActiveMQTextMessage msg;
        String topicName;
        QoS qoS;
        PUBLISH result = new PUBLISH();
        if (message.propertyExists(QOS_PROPERTY_NAME)) {
            int ordinal = message.getIntProperty(QOS_PROPERTY_NAME);
            qoS = QoS.values()[ordinal];
        } else {
            qoS = message.isPersistent() ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE;
        }
        result.qos(qoS);
        if (message.getBooleanProperty("ActiveMQ.Retained")) {
            result.retain(true);
        }
        Map<Destination, String> map = this.mqttTopicMap;
        synchronized (map) {
            topicName = this.mqttTopicMap.get(message.getJMSDestination());
            if (topicName == null) {
                String amqTopicName = this.findSubscriptionStrategy().onSend(message.getDestination());
                topicName = MQTTProtocolSupport.convertActiveMQToMQTT(amqTopicName);
                this.mqttTopicMap.put(message.getJMSDestination(), topicName);
            }
        }
        result.topicName(new UTF8Buffer(topicName));
        if (message.getDataStructureType() == 28) {
            msg = (ActiveMQTextMessage)message.copy();
            msg.setReadOnlyBody(true);
            String messageText = msg.getText();
            if (messageText != null) {
                result.payload(new Buffer(messageText.getBytes("UTF-8")));
            }
        } else if (message.getDataStructureType() == 24) {
            msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            result.payload(new Buffer(data));
        } else if (message.getDataStructureType() == 25) {
            msg = (ActiveMQMapMessage)message.copy();
            msg.setReadOnlyBody(true);
            Map map2 = msg.getContentMap();
            if (map2 != null) {
                result.payload(new Buffer(map2.toString().getBytes("UTF-8")));
            }
        } else {
            ByteSequence byteSequence = message.getContent();
            if (byteSequence != null && byteSequence.getLength() > 0) {
                if (message.isCompressed()) {
                    int read;
                    Inflater inflater = new Inflater();
                    inflater.setInput(byteSequence.data, byteSequence.offset, byteSequence.length);
                    byte[] data = new byte[4096];
                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                    while ((read = inflater.inflate(data)) != 0) {
                        bytesOut.write(data, 0, read);
                    }
                    byteSequence = bytesOut.toByteSequence();
                    bytesOut.close();
                }
                result.payload(new Buffer(byteSequence.data, byteSequence.offset, byteSequence.length));
            }
        }
        LOG.trace("ActiveMQ-->MQTT:MQTT_MSGID:{} client:{} connection:{} ActiveMQ_MSGID:{}", new Object[]{result.messageId(), this.clientId, this.connectionInfo.getConnectionId(), message.getMessageId()});
        return result;
    }

    public MQTTTransport getMQTTTransport() {
        return this.mqttTransport;
    }

    public void onTransportError() {
        if (this.connect != null && this.connected.get()) {
            if (this.connect.willTopic() != null && this.connect.willMessage() != null && !this.willSent) {
                this.willSent = true;
                try {
                    PUBLISH publish = new PUBLISH();
                    publish.topicName(this.connect.willTopic());
                    publish.qos(this.connect.willQos());
                    publish.messageId(this.packetIdGenerator.getNextSequenceId(this.getClientId()));
                    publish.payload((Buffer)this.connect.willMessage());
                    ActiveMQMessage message = this.convertMessage(publish);
                    message.setProducerId(this.producerId);
                    message.onSend();
                    this.sendToActiveMQ((Command)message, null);
                }
                catch (Exception e) {
                    LOG.warn("Failed to publish Will Message " + this.connect.willMessage());
                }
            }
            this.sendToActiveMQ((Command)this.connectionInfo.createRemoveCommand(), null);
        }
    }

    void configureInactivityMonitor(short keepAliveSeconds) {
        MQTTInactivityMonitor monitor = this.getMQTTTransport().getInactivityMonitor();
        if (monitor == null) {
            return;
        }
        monitor.stopConnectChecker();
        long keepAliveMS = keepAliveSeconds * 1000;
        LOG.debug("MQTT Client {} requests heart beat of {} ms", (Object)this.getClientId(), (Object)keepAliveMS);
        try {
            if (keepAliveMS == 0L && this.defaultKeepAlive > 0L) {
                keepAliveMS = this.defaultKeepAlive;
            }
            long readGracePeriod = (long)((double)keepAliveMS * 0.5);
            monitor.setProtocolConverter(this);
            monitor.setReadKeepAliveTime(keepAliveMS);
            monitor.setReadGraceTime(readGracePeriod);
            monitor.startReadChecker();
            LOG.debug("MQTT Client {} established heart beat of  {} ms ({} ms + {} ms grace period)", new Object[]{this.getClientId(), keepAliveMS, keepAliveMS, readGracePeriod});
        }
        catch (Exception ex) {
            LOG.warn("Failed to start MQTT InactivityMonitor ", (Throwable)ex);
        }
    }

    void handleException(Throwable exception, MQTTFrame command) {
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        LOG.debug("Exception detail", exception);
        if (this.connected.get() && this.connectionInfo != null) {
            this.connected.set(false);
            this.sendToActiveMQ((Command)this.connectionInfo.createRemoveCommand(), null);
        }
        this.stopTransport();
    }

    void checkConnected() throws MQTTProtocolException {
        if (!this.connected.get()) {
            throw new MQTTProtocolException("Not connected.");
        }
    }

    private void stopTransport() {
        try {
            this.getMQTTTransport().stop();
        }
        catch (Throwable e) {
            LOG.debug("Failed to stop MQTT transport ", e);
        }
    }

    ResponseHandler createResponseHandler(final PUBLISH command) {
        if (command != null) {
            switch (command.qos()) {
                case AT_LEAST_ONCE: {
                    return new ResponseHandler(){

                        @Override
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT Publish: ", (Object)command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBACK ack = new PUBACK();
                                ack.messageId(command.messageId());
                                LOG.trace("MQTT Snd PUBACK message:{} client:{} connection:{}", new Object[]{command.messageId(), MQTTProtocolConverter.this.clientId, MQTTProtocolConverter.this.connectionInfo.getConnectionId()});
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
                case EXACTLY_ONCE: {
                    return new ResponseHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT Publish: ", (Object)command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBREC ack = new PUBREC();
                                ack.messageId(command.messageId());
                                Map map = MQTTProtocolConverter.this.publisherRecs;
                                synchronized (map) {
                                    MQTTProtocolConverter.this.publisherRecs.put(command.messageId(), ack);
                                }
                                LOG.trace("MQTT Snd PUBACK message:{} client:{} connection:{}", new Object[]{command.messageId(), MQTTProtocolConverter.this.clientId, MQTTProtocolConverter.this.connectionInfo.getConnectionId()});
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
            }
        }
        return null;
    }

    public long getDefaultKeepAlive() {
        return this.defaultKeepAlive;
    }

    public void setDefaultKeepAlive(long keepAlive) {
        this.defaultKeepAlive = keepAlive;
    }

    public int getActiveMQSubscriptionPrefetch() {
        return this.activeMQSubscriptionPrefetch;
    }

    public void setActiveMQSubscriptionPrefetch(int activeMQSubscriptionPrefetch) {
        this.activeMQSubscriptionPrefetch = activeMQSubscriptionPrefetch;
    }

    public MQTTPacketIdGenerator getPacketIdGenerator() {
        return this.packetIdGenerator;
    }

    public void setPublishDollarTopics(boolean publishDollarTopics) {
        this.publishDollarTopics = publishDollarTopics;
    }

    public boolean getPublishDollarTopics() {
        return this.publishDollarTopics;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public boolean isCleanSession() {
        return this.connect.cleanSession();
    }

    public String getSubscriptionStrategy() {
        return this.subscriptionStrategyName;
    }

    public void setSubscriptionStrategy(String name) {
        this.subscriptionStrategyName = name;
    }

    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.connect != null && this.connect.clientId() != null ? this.connect.clientId().toString() : "";
        }
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQTTSubscriptionStrategy findSubscriptionStrategy() throws IOException {
        if (this.subsciptionStrategy == null) {
            FactoryFinder factoryFinder = this.STRATAGY_FINDER;
            synchronized (factoryFinder) {
                if (this.subsciptionStrategy != null) {
                    return this.subsciptionStrategy;
                }
                MQTTSubscriptionStrategy strategy = null;
                if (this.subscriptionStrategyName != null && !this.subscriptionStrategyName.isEmpty()) {
                    try {
                        strategy = (MQTTSubscriptionStrategy)this.STRATAGY_FINDER.newInstance(this.subscriptionStrategyName);
                        LOG.debug("MQTT Using subscription strategy: {}", (Object)this.subscriptionStrategyName);
                        if (strategy instanceof BrokerServiceAware) {
                            ((BrokerServiceAware)strategy).setBrokerService(this.brokerService);
                        }
                        strategy.initialize(this);
                    }
                    catch (Exception e) {
                        throw IOExceptionSupport.create((Exception)e);
                    }
                } else {
                    throw new IOException("Invalid subscription strategy name given: " + this.subscriptionStrategyName);
                }
                this.subsciptionStrategy = strategy;
            }
        }
        return this.subsciptionStrategy;
    }
}

