/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.util.Properties;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class NatsConfiguration {
    @UriPath
    @Metadata(required="true")
    private String servers;
    @UriParam
    @Metadata(required="true")
    private String topic;
    @UriParam(defaultValue="true")
    private boolean reconnect = true;
    @UriParam(defaultValue="false")
    private boolean pedantic;
    @UriParam(defaultValue="false")
    private boolean verbose;
    @UriParam(defaultValue="false")
    private boolean ssl;
    @UriParam(defaultValue="2000")
    private int reconnectTimeWait = 2000;
    @UriParam(defaultValue="3")
    private int maxReconnectAttempts = 3;
    @UriParam(defaultValue="4000")
    private int pingInterval = 4000;
    @UriParam(label="producer")
    private String replySubject;
    @UriParam(defaultValue="false")
    private boolean noRandomizeServers;
    @UriParam(label="consumer")
    private String queueName;
    @UriParam(label="consumer")
    private String maxMessages;
    @UriParam(label="consumer", defaultValue="10")
    private int poolSize = 10;

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public boolean getReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public boolean getPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public int getReconnectTimeWait() {
        return this.reconnectTimeWait;
    }

    public void setReconnectTimeWait(int reconnectTimeWait) {
        this.reconnectTimeWait = reconnectTimeWait;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    public String getReplySubject() {
        return this.replySubject;
    }

    public void setReplySubject(String replySubject) {
        this.replySubject = replySubject;
    }

    public boolean getNoRandomizeServers() {
        return this.noRandomizeServers;
    }

    public void setNoRandomizeServers(boolean noRandomizeServers) {
        this.noRandomizeServers = noRandomizeServers;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(String maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    private static <T> void addPropertyIfNotNull(Properties props, String key, T value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    public Properties createProperties() {
        Properties props = new Properties();
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.url", this.splitServers());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.verbose", this.getVerbose());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.pedantic", this.getPedantic());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.secure", this.getSsl());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.reconnect.allowed", this.getReconnect());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.reconnect.max", this.getMaxReconnectAttempts());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.reconnect.wait", this.getReconnectTimeWait());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.pinginterval", this.getPingInterval());
        NatsConfiguration.addPropertyIfNotNull(props, "io.nats.client.norandomize", this.getNoRandomizeServers());
        return props;
    }

    private String splitServers() {
        StringBuilder servers = new StringBuilder();
        String prefix = "nats://";
        String[] pieces = this.getServers().split(",");
        for (int i = 0; i < pieces.length; ++i) {
            if (i < pieces.length - 1) {
                servers.append(prefix + pieces[i] + ",");
                continue;
            }
            servers.append(prefix + pieces[i]);
        }
        return servers.toString();
    }
}

