/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.InputStream;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.SalesforceHttpRequest;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceSecurityHandler
implements ProtocolHandler {
    static final String CLIENT_ATTRIBUTE = SalesforceSecurityHandler.class.getName().concat("camel-salesforce-client");
    static final String AUTHENTICATION_REQUEST_ATTRIBUTE = SalesforceSecurityHandler.class.getName().concat(".request");
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceSecurityHandler.class);
    private static final String AUTHENTICATION_RETRIES_ATTRIBUTE = SalesforceSecurityHandler.class.getName().concat(".retries");
    private final SalesforceHttpClient httpClient;
    private final SalesforceSession session;
    private final int maxAuthenticationRetries;
    private final int maxContentLength;
    private final ResponseNotifier notifier;

    public SalesforceSecurityHandler(SalesforceHttpClient httpClient) {
        this.httpClient = httpClient;
        this.session = httpClient.getSession();
        this.maxAuthenticationRetries = httpClient.getMaxRetries();
        this.maxContentLength = httpClient.getMaxContentLength();
        this.notifier = new ResponseNotifier();
    }

    public boolean accept(Request request, Response response) {
        HttpConversation conversation = ((SalesforceHttpRequest)request).getConversation();
        Integer retries = (Integer)conversation.getAttribute(AUTHENTICATION_RETRIES_ATTRIBUTE);
        if (conversation.getAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE) != null && (retries == null || retries <= this.maxAuthenticationRetries)) {
            return true;
        }
        int status = response.getStatus();
        return !(status != 401 && status != 400 || retries != null && retries > this.maxAuthenticationRetries);
    }

    public Response.Listener getResponseListener() {
        return new SecurityListener(this.maxContentLength);
    }

    private class SecurityListener
    extends BufferingResponseListener {
        SecurityListener(int maxLength) {
            super(maxLength);
        }

        public void onComplete(Result result) {
            SalesforceHttpRequest request = (SalesforceHttpRequest)result.getRequest();
            HttpContentResponse response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            HttpConversation conversation = request.getConversation();
            Integer retries = (Integer)conversation.getAttribute(AUTHENTICATION_RETRIES_ATTRIBUTE);
            if (retries == null) {
                retries = 0;
            }
            AbstractClientBase client = (AbstractClientBase)conversation.getAttribute(CLIENT_ATTRIBUTE);
            if (result.isFailed()) {
                Throwable failure = result.getFailure();
                this.retryOnFailure(request, conversation, retries, client, failure);
                return;
            }
            SalesforceHttpRequest origRequest = (SalesforceHttpRequest)((Object)conversation.getAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE));
            if (origRequest != null) {
                try {
                    SalesforceSecurityHandler.this.session.parseLoginResponse((ContentResponse)response, response.getContentAsString());
                }
                catch (SalesforceException e) {
                    if (retries < SalesforceSecurityHandler.this.maxAuthenticationRetries) {
                        this.retryOnFailure(request, conversation, retries, client, (Throwable)((Object)e));
                    } else {
                        this.forwardFailureComplete(origRequest, null, (Response)response, (Throwable)((Object)e));
                    }
                    return;
                }
                conversation.removeAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE);
                this.retryRequest(origRequest, client, retries, conversation, true);
                return;
            }
            int status = response.getStatus();
            String reason = response.getReason();
            if (retries >= SalesforceSecurityHandler.this.maxAuthenticationRetries) {
                this.forwardSuccessComplete(request, (Response)response);
                return;
            }
            if (status == 401) {
                LOG.warn("Retrying on Salesforce authentication error [{}]: [{}]", (Object)status, (Object)reason);
                this.retryLogin(request, retries);
            } else if (status < 200 || status >= 300) {
                SalesforceException cause;
                InputStream inputStream = this.getContent().length == 0 ? null : this.getContentAsInputStream();
                SalesforceException salesforceException = cause = client != null ? client.createRestException((Response)response, inputStream) : null;
                if (status == 400 && cause != null && this.isInvalidSessionError(cause)) {
                    LOG.warn("Retrying on Bulk API Salesforce authentication error [{}]: [{}]", (Object)status, (Object)reason);
                    this.retryLogin(request, retries);
                } else {
                    this.forwardSuccessComplete(request, (Response)response);
                }
            }
        }

        protected void retryOnFailure(SalesforceHttpRequest request, HttpConversation conversation, Integer retries, AbstractClientBase client, Throwable failure) {
            LOG.warn("Retrying on Salesforce authentication failure " + failure.getMessage(), failure);
            this.retryRequest(request, client, retries, conversation, true);
        }

        private boolean isInvalidSessionError(SalesforceException e) {
            return e.getErrors() != null && e.getErrors().size() == 1 && "InvalidSessionId".equals(e.getErrors().get(0).getErrorCode());
        }

        private void retryLogin(SalesforceHttpRequest request, Integer retries) {
            HttpConversation conversation = request.getConversation();
            conversation.setAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE, (Object)request);
            this.retryRequest((SalesforceHttpRequest)SalesforceSecurityHandler.this.session.getLoginRequest(conversation), null, retries, conversation, false);
        }

        private void retryRequest(SalesforceHttpRequest request, AbstractClientBase client, Integer retries, HttpConversation conversation, boolean copy) {
            SalesforceHttpRequest newRequest;
            if (copy) {
                newRequest = SalesforceSecurityHandler.this.httpClient.copyRequest(request, request.getURI());
                newRequest.method(request.getMethod());
                HttpFields headers = newRequest.getHeaders();
                for (HttpField field : request.getHeaders()) {
                    HttpHeader header = field.getHeader();
                    if (!HttpHeader.COOKIE.equals((Object)header) && !HttpHeader.HOST.equals((Object)header)) continue;
                    headers.add(header, field.getValue());
                }
            } else {
                newRequest = request;
            }
            retries = retries + 1;
            conversation.setAttribute(AUTHENTICATION_RETRIES_ATTRIBUTE, (Object)retries);
            Object originalRequest = conversation.getAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE);
            LOG.debug("Retry attempt {} on authentication error for {}", (Object)retries, originalRequest != null ? originalRequest : newRequest);
            if (originalRequest == null) {
                String currentToken = SalesforceSecurityHandler.this.session.getAccessToken();
                if (client != null) {
                    client.setAccessToken(currentToken);
                    client.setInstanceUrl(SalesforceSecurityHandler.this.session.getInstanceUrl());
                    client.setAccessToken((Request)newRequest);
                } else {
                    newRequest.header(HttpHeader.AUTHORIZATION, "OAuth " + currentToken);
                }
            }
            conversation.updateResponseListeners(null);
            newRequest.onRequestBegin(this.getRequestAbortListener(request));
            newRequest.send(null);
        }

        private Request.BeginListener getRequestAbortListener(final SalesforceHttpRequest request) {
            return new Request.BeginListener(){

                public void onBegin(Request redirect) {
                    Throwable cause = request.getAbortCause();
                    if (cause != null) {
                        redirect.abort(cause);
                    }
                }
            };
        }

        private void forwardSuccessComplete(SalesforceHttpRequest request, Response response) {
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            SalesforceSecurityHandler.this.notifier.forwardSuccessComplete(conversation.getResponseListeners(), (Request)request, response);
        }

        private void forwardFailureComplete(SalesforceHttpRequest request, Throwable requestFailure, Response response, Throwable responseFailure) {
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            SalesforceSecurityHandler.this.notifier.forwardFailureComplete(conversation.getResponseListeners(), (Request)request, requestFailure, response, responseFailure);
        }
    }
}

