/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.util.ObjectHelper;

public abstract class ServiceNowProducerProcessor<T>
implements Processor {
    protected final ServiceNowEndpoint endpoint;
    protected final ServiceNowConfiguration config;
    protected final T client;
    protected final ObjectMapper mapper;
    private final JavaTypeCache javaTypeCache = new JavaTypeCache();

    protected ServiceNowProducerProcessor(ServiceNowEndpoint endpoint, Class<T> type) throws Exception {
        this.endpoint = endpoint;
        this.config = endpoint.getConfiguration();
        this.client = endpoint.createClient(type);
        this.mapper = (ObjectMapper)ObjectHelper.notNull((Object)this.config.getMapper(), (String)"mapper");
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = (String)in.getHeader("CamelServiceNowTable", (Object)this.config.getTable(), String.class);
        Class model = (Class)in.getHeader("CamelServiceNowModel", this.config.getModel(tableName, Map.class), Class.class);
        String action = (String)in.getHeader("CamelServiceNowAction", String.class);
        String sysId = (String)in.getHeader("CamelServiceNowSysId", String.class);
        this.doProcess(exchange, (Class)ObjectHelper.notNull((Object)model, (String)"model"), (String)ObjectHelper.notNull((Object)action, (String)"action"), (String)ObjectHelper.notNull((Object)tableName, (String)"tableName"), sysId);
    }

    protected abstract void doProcess(Exchange var1, Class<?> var2, String var3, String var4, String var5) throws Exception;

    protected ServiceNowProducerProcessor<T> validateBody(Message message, Class<?> model) {
        return this.validateBody(message.getBody(), model);
    }

    protected ServiceNowProducerProcessor<T> validateBody(Object body, Class<?> model) {
        ObjectHelper.notNull((Object)body, (String)"body");
        if (!body.getClass().isAssignableFrom(model)) {
            throw new IllegalArgumentException("Body is not compatible with model (body=" + body.getClass() + ", model=" + model);
        }
        return this;
    }

    protected ServiceNowProducerProcessor<T> setBody(Message message, Class<?> model, JsonNode answer) throws Exception {
        message.setBody(this.unwrap(answer, model));
        return this;
    }

    protected Object unwrap(JsonNode answer, Class<?> model) throws Exception {
        JsonNode node;
        Object result = null;
        if (answer != null && (node = answer.get("result")) != null) {
            result = node.isArray() ? (model.isInstance(Map.class) ? this.mapper.treeToValue((TreeNode)node, List.class) : this.mapper.readValue(node.traverse(), (JavaType)this.javaTypeCache.get(model))) : this.mapper.treeToValue((TreeNode)node, model);
        }
        return result;
    }

    public static interface Supplier {
        public Processor get(ServiceNowEndpoint var1) throws Exception;
    }

    private class JavaTypeCache
    extends ClassValue<JavaType> {
        private JavaTypeCache() {
        }

        @Override
        protected JavaType computeValue(Class<?> type) {
            return ServiceNowProducerProcessor.this.mapper.getTypeFactory().constructCollectionType(List.class, type);
        }
    }
}

