/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.model;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowProducerProcessor;
import org.apache.camel.component.servicenow.model.ServiceNowAggregate;
import org.apache.camel.util.ObjectHelper;

public class ServiceNowAggregateProcessor
extends ServiceNowProducerProcessor<ServiceNowAggregate> {
    public static final ServiceNowProducerProcessor.Supplier SUPPLIER = new ServiceNowProducerProcessor.Supplier(){

        @Override
        public Processor get(ServiceNowEndpoint endpoint) throws Exception {
            return new ServiceNowAggregateProcessor(endpoint);
        }
    };

    public ServiceNowAggregateProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint, ServiceNowAggregate.class);
    }

    @Override
    protected void doProcess(Exchange exchange, Class<?> model, String action, String tableName, String sysId) throws Exception {
        if (!ObjectHelper.equal((Object)"retrieve", (Object)action, (boolean)true)) {
            throw new IllegalArgumentException("Unknown action " + action);
        }
        this.retrieveStats(exchange.getIn(), model, tableName);
    }

    private void retrieveStats(Message in, Class<?> model, String tableName) throws Exception {
        this.setBody(in, model, ((ServiceNowAggregate)this.client).retrieveStats(tableName, (String)in.getHeader("CamelServiceNowQuery", String.class), (String)in.getHeader("CamelServiceNowAvgFields", String.class), (String)in.getHeader("CamelServiceNowCount", String.class), (String)in.getHeader("CamelServiceNowMinFields", String.class), (String)in.getHeader("CamelServiceNowMaxFields", String.class), (String)in.getHeader("CamelServiceNowSumFields", String.class), (String)in.getHeader("CamelServiceGroupBy", String.class), (String)in.getHeader("CamelServiceOrderBy", String.class), (String)in.getHeader("CamelServiceHaving", String.class), (String)in.getHeader("CamelServiceNowDisplayValue", (Object)this.config.getDisplayValue(), String.class)));
    }
}

