/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.model;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowProducerProcessor;
import org.apache.camel.component.servicenow.model.ServiceNowImportSet;
import org.apache.camel.util.ObjectHelper;

public class ServiceNowImportSetProcessor
extends ServiceNowProducerProcessor<ServiceNowImportSet> {
    public static final ServiceNowProducerProcessor.Supplier SUPPLIER = new ServiceNowProducerProcessor.Supplier(){

        @Override
        public Processor get(ServiceNowEndpoint endpoint) throws Exception {
            return new ServiceNowImportSetProcessor(endpoint);
        }
    };

    public ServiceNowImportSetProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint, ServiceNowImportSet.class);
    }

    @Override
    protected void doProcess(Exchange exchange, Class<?> model, String action, String tableName, String sysId) throws Exception {
        if (ObjectHelper.equal((Object)"retrieve", (Object)action, (boolean)true)) {
            this.retrieveRecord(exchange.getIn(), model, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"create", (Object)action, (boolean)true)) {
            this.createRecord(exchange.getIn(), model, tableName);
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
    }

    private void retrieveRecord(Message in, Class<?> model, String tableName, String sysId) throws Exception {
        this.setBody(in, model, ((ServiceNowImportSet)this.client).retrieveRecordById(tableName, (String)ObjectHelper.notNull((Object)sysId, (String)"sysId")));
    }

    private void createRecord(Message in, Class<?> model, String tableName) throws Exception {
        this.validateBody(in, model);
        this.setBody(in, model, ((ServiceNowImportSet)this.client).createRecord(tableName, this.mapper.writeValueAsString(in.getBody())));
    }
}

