/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import twitter4j.Paging;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public abstract class TwitterConsumer {
    protected final TwitterEndpoint endpoint;
    private long lastId;

    protected TwitterConsumer(TwitterEndpoint endpoint) {
        this.endpoint = endpoint;
        this.lastId = -1L;
    }

    public abstract List<Exchange> pollConsume() throws TwitterException;

    public abstract List<Exchange> directConsume() throws TwitterException;

    protected void setLastIdIfGreater(long newId) {
        if (newId > this.lastId) {
            this.lastId = newId;
        }
    }

    public void setLastId(long sinceId) {
        this.lastId = sinceId;
    }

    protected Twitter getTwitter() {
        return this.endpoint.getProperties().getTwitter();
    }

    protected long getLastId() {
        return this.lastId;
    }

    protected Paging getLastIdPaging() {
        return new Paging(this.lastId);
    }
}

