/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.search;

import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.GeoLocation;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class SearchConsumer
extends TwitterConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SearchConsumer.class);

    public SearchConsumer(TwitterEndpoint te) {
        super(te);
    }

    @Override
    public List<Exchange> pollConsume() throws TwitterException {
        Query query;
        String keywords = this.endpoint.getProperties().getKeywords();
        if (keywords != null && keywords.trim().length() > 0) {
            query = new Query(keywords);
            LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        } else {
            query = new Query();
            LOG.debug("Searching twitter without keywords.");
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            query.setSinceId(this.getLastId());
        }
        return this.search(query);
    }

    @Override
    public List<Exchange> directConsume() throws TwitterException {
        String keywords = this.endpoint.getProperties().getKeywords();
        if (keywords == null || keywords.trim().length() == 0) {
            return Collections.emptyList();
        }
        Query query = new Query(keywords);
        LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        return this.search(query);
    }

    private List<Exchange> search(Query query) throws TwitterException {
        int i;
        Integer numberOfPages = 1;
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getLang())) {
            query.setLang(this.endpoint.getProperties().getLang());
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getCount())) {
            query.setCount(this.endpoint.getProperties().getCount().intValue());
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getNumberOfPages())) {
            numberOfPages = this.endpoint.getProperties().getNumberOfPages();
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getLatitude()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getLongitude()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getRadius())) {
            GeoLocation location = new GeoLocation(this.endpoint.getProperties().getLatitude().doubleValue(), this.endpoint.getProperties().getLongitude().doubleValue());
            query.setGeoCode(location, this.endpoint.getProperties().getRadius().doubleValue(), Query.Unit.valueOf((String)this.endpoint.getProperties().getDistanceMetric()));
            LOG.debug("Searching with additional geolocation parameters.");
        }
        LOG.debug("Searching with {} pages.", (Object)numberOfPages);
        Twitter twitter = this.getTwitter();
        QueryResult qr = twitter.search(query);
        List tweets = qr.getTweets();
        for (i = 1; i < numberOfPages && qr.hasNext(); ++i) {
            qr = twitter.search(qr.nextQuery());
            tweets.addAll(qr.getTweets());
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            for (i = 0; i < tweets.size(); ++i) {
                this.setLastIdIfGreater(((Status)tweets.get(i)).getId());
            }
        }
        return TwitterEventType.STATUS.createExchangeList(this.endpoint, tweets);
    }
}

