/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelContextFactory;
import org.wildfly.extension.camel.WildFlyCamelContext;
import org.wildfly.extension.camel.handler.ModuleClassLoaderAssociationHandler;
import org.wildfly.extension.gravia.GraviaConstants;

public class CamelContextFactoryService
extends AbstractService<CamelContextFactory> {
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private ServiceRegistration<CamelContextFactory> registration;
    private CamelContextFactory contextFactory;

    public static ServiceController<CamelContextFactory> addService(ServiceTarget serviceTarget) {
        CamelContextFactoryService service = new CamelContextFactoryService();
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_CONTEXT_FACTORY_SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        return builder.install();
    }

    private CamelContextFactoryService() {
    }

    public void start(StartContext startContext) throws StartException {
        this.contextFactory = new CamelContextFactoryImpl();
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        ModuleContext syscontext = runtime.getModuleContext();
        this.registration = syscontext.registerService(CamelContextFactory.class, (Object)this.contextFactory, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public CamelContextFactory getValue() {
        return this.contextFactory;
    }

    static final class CamelContextFactoryImpl
    implements CamelContextFactory {
        CamelContextFactoryImpl() {
        }

        @Override
        public WildFlyCamelContext createCamelContext() throws Exception {
            return new WildFlyCamelContext();
        }

        @Override
        public WildFlyCamelContext createCamelContext(ClassLoader classLoader) throws Exception {
            IllegalArgumentAssertion.assertTrue((Boolean)(classLoader instanceof ModuleClassLoader), (String)("ModuleClassLoader required: " + classLoader));
            ModuleClassLoaderAssociationHandler.associate((ModuleClassLoader)classLoader);
            try {
                WildFlyCamelContext wildFlyCamelContext = new WildFlyCamelContext();
                return wildFlyCamelContext;
            }
            finally {
                ModuleClassLoaderAssociationHandler.disassociate();
            }
        }
    }
}

