/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public final class ClusterShardHealth
implements Streamable {
    private int shardId;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    private int activeShards = 0;
    private int relocatingShards = 0;
    private int initializingShards = 0;
    private int unassignedShards = 0;
    private boolean primaryActive = false;

    private ClusterShardHealth() {
    }

    public ClusterShardHealth(int shardId, IndexShardRoutingTable shardRoutingTable) {
        this.shardId = shardId;
        for (ShardRouting shardRouting : shardRoutingTable) {
            if (shardRouting.active()) {
                ++this.activeShards;
                if (shardRouting.relocating()) {
                    ++this.relocatingShards;
                }
                if (!shardRouting.primary()) continue;
                this.primaryActive = true;
                continue;
            }
            if (shardRouting.initializing()) {
                ++this.initializingShards;
                continue;
            }
            if (!shardRouting.unassigned()) continue;
            ++this.unassignedShards;
        }
        this.status = this.primaryActive ? (this.activeShards == shardRoutingTable.size() ? ClusterHealthStatus.GREEN : ClusterHealthStatus.YELLOW) : ClusterHealthStatus.RED;
    }

    public int getId() {
        return this.shardId;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public boolean isPrimaryActive() {
        return this.primaryActive;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    static ClusterShardHealth readClusterShardHealth(StreamInput in) throws IOException {
        ClusterShardHealth ret = new ClusterShardHealth();
        ret.readFrom(in);
        return ret;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.primaryActive = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardId);
        out.writeByte(this.status.value());
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeBoolean(this.primaryActive);
    }
}

