/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.util.HexUtil;
import org.jsmpp.util.OctetUtil;

public abstract class OptionalParameter {
    public final short tag;

    public OptionalParameter(short tag) {
        this.tag = tag;
    }

    public byte[] serialize() {
        byte[] value = this.serializeValue();
        ByteBuffer buffer = ByteBuffer.allocate(value.length + 4);
        buffer.putShort(this.tag);
        buffer.putShort((short)value.length);
        buffer.put(value);
        return buffer.array();
    }

    protected abstract byte[] serializeValue();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tag;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionalParameter other = (OptionalParameter)obj;
        return this.tag == other.tag;
    }

    public static enum Tag {
        DEST_ADDR_SUBUNIT(5, Dest_addr_subunit.class),
        DEST_NETWORK_TYPE(6, Dest_network_type.class),
        DEST_BEARER_TYPE(7, Dest_bearer_type.class),
        DEST_TELEMATICS_ID(8, Dest_telematics_id.class),
        SOURCE_ADDR_SUBUNIT(13, Source_addr_subunit.class),
        SOURCE_NETWORK_TYPE(14, Source_network_type.class),
        SOURCE_BEARER_TYPE(15, Source_bearer_type.class),
        SOURCE_TELEMATICS_ID(16, Source_telematics_id.class),
        QOS_TIME_TO_LIVE(23, Qos_time_to_live.class),
        PAYLOAD_TYPE(25, Payload_type.class),
        ADDITIONAL_STATUS_INFO_TEXT(29, Additional_status_info_text.class),
        RECEIPTED_MESSAGE_ID(30, Receipted_message_id.class),
        MS_MSG_WAIT_FACILITIES(48, Ms_msg_wait_facilities.class),
        PRIVACY_INDICATOR(513, Privacy_indicator.class),
        SOURCE_SUBADDRESS(514, Source_subaddress.class),
        DEST_SUBADDRESS(515, Dest_subaddress.class),
        USER_MESSAGE_REFERENCE(516, User_message_reference.class),
        USER_RESPONSE_CODE(517, User_response_code.class),
        SOURCE_PORT(522, Source_port.class),
        DESTINATION_PORT(523, Destination_port.class),
        SAR_MSG_REF_NUM(524, Sar_msg_ref_num.class),
        LANGUAGE_INDICATOR(525, Language_indicator.class),
        SAR_TOTAL_SEGMENTS(526, Sar_total_segments.class),
        SAR_SEGMENT_SEQNUM(527, Sar_segment_seqnum.class),
        SC_INTERFACE_VERSION(528, Sc_interface_version.class),
        CALLBACK_NUM_PRES_IND(770, Callback_num_pres_ind.class),
        CALLBACK_NUM_ATAG(771, Callback_num_atag.class),
        NUMBER_OF_MESSAGES(772, Number_of_messages.class),
        CALLBACK_NUM(897, Callback_num.class),
        DPF_RESULT(1056, Dpf_result.class),
        SET_DPF(1057, Set_dpf.class),
        MS_AVAILABILITY_STATUS(1058, Ms_availability_status.class),
        NETWORK_ERROR_CODE(1059, Network_error_code.class),
        MESSAGE_PAYLOAD(1060, Message_payload.class),
        DELIVERY_FAILURE_REASON(1061, Delivery_failure_reason.class),
        MORE_MESSAGES_TO_SEND(1062, More_messages_to_send.class),
        MESSAGE_STATE(1063, Message_state.class),
        USSD_SERVICE_OP(1281, Ussd_service_op.class),
        BILLING_IDENTIFICATION(1547, Billing_identification.class),
        DISPLAY_TIME(4609, Display_time.class),
        SMS_SIGNAL(4611, Sms_signal.class),
        MS_VALIDITY(4612, Ms_validity.class),
        ALERT_ON_MESSAGE_DELIVERY(4876, Alert_on_message_delivery.class),
        ITS_REPLY_TYPE(4992, Its_reply_type.class),
        ITS_SESSION_INFO(4995, Its_session_info.class),
        VENDOR_SPECIFIC_SOURCE_MSC_ADDR(5377, Vendor_specific_source_msc_addr.class),
        VENDOR_SPECIFIC_DEST_MSC_ADDR(5378, Vendor_specific_dest_msc_addr.class);

        private final short code;
        final Class<? extends OptionalParameter> type;

        private Tag(int code, Class<? extends OptionalParameter> type) {
            this.code = (short)code;
            this.type = type;
        }

        @Deprecated
        public short value() {
            return this.code;
        }

        public short code() {
            return this.code;
        }

        public Class<? extends OptionalParameter> type() {
            return this.type;
        }

        public static Tag valueOf(short code) {
            for (Tag tag : Tag.values()) {
                if (tag.code != code) continue;
                return tag;
            }
            return null;
        }
    }

    private static class Vendor_specific_msc_addr
    extends OctetString {
        String address;

        private Vendor_specific_msc_addr(short tag, byte[] value) {
            super(tag, value);
            try {
                if (value.length >= 2) {
                    this.address = new String(value, 2, value.length - 2, "ISO-8859-1");
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public byte getTon() {
            return this.getValue()[0];
        }

        public byte getNpi() {
            return this.getValue()[1];
        }

        public String getAddress() {
            return this.address;
        }
    }

    public static class Vendor_specific_dest_msc_addr
    extends Vendor_specific_msc_addr {
        public Vendor_specific_dest_msc_addr(byte[] value) {
            super(Tag.VENDOR_SPECIFIC_DEST_MSC_ADDR.code, value);
        }
    }

    public static class Vendor_specific_source_msc_addr
    extends Vendor_specific_msc_addr {
        public Vendor_specific_source_msc_addr(byte[] value) {
            super(Tag.VENDOR_SPECIFIC_SOURCE_MSC_ADDR.code, value);
        }
    }

    public static class Its_session_info
    extends Short {
        public Its_session_info(short value) {
            super(Tag.ITS_SESSION_INFO, value);
        }

        public Its_session_info(byte[] content) {
            super(Tag.ITS_SESSION_INFO.code, content);
        }
    }

    public static class Its_reply_type
    extends Byte {
        public Its_reply_type(byte value) {
            super(Tag.ITS_REPLY_TYPE, value);
        }

        public Its_reply_type(byte[] content) {
            super(Tag.ITS_REPLY_TYPE.code, content);
        }
    }

    public static class Alert_on_message_delivery
    extends Byte {
        public Alert_on_message_delivery(byte value) {
            super(Tag.ALERT_ON_MESSAGE_DELIVERY, value);
        }

        public Alert_on_message_delivery(byte[] content) {
            this(content.length == 0 ? (byte)0 : content[0]);
        }
    }

    public static class Ms_validity
    extends Byte {
        public Ms_validity(byte value) {
            super(Tag.MS_VALIDITY, value);
        }

        public Ms_validity(byte[] content) {
            super(Tag.MS_VALIDITY.code, content);
        }
    }

    public static class Sms_signal
    extends Short {
        public Sms_signal(short value) {
            super(Tag.SMS_SIGNAL, value);
        }

        public Sms_signal(byte[] content) {
            super(Tag.SMS_SIGNAL.code, content);
        }
    }

    public static class Display_time
    extends Byte {
        public Display_time(byte value) {
            super(Tag.DISPLAY_TIME, value);
        }

        public Display_time(byte[] content) {
            super(Tag.DISPLAY_TIME.code, content);
        }
    }

    public static class Billing_identification
    extends OctetString {
        public Billing_identification(byte[] value) {
            super(Tag.BILLING_IDENTIFICATION.code, value);
        }
    }

    public static class Ussd_service_op
    extends Byte {
        public Ussd_service_op(byte value) {
            super(Tag.USSD_SERVICE_OP, value);
        }

        public Ussd_service_op(byte[] content) {
            super(Tag.USSD_SERVICE_OP.code, content);
        }
    }

    public static class Message_state
    extends Byte {
        public Message_state(byte value) {
            super(Tag.MESSAGE_STATE, value);
        }

        public Message_state(byte[] content) {
            super(Tag.MESSAGE_STATE.code, content);
        }

        public Message_state_enum getMessageState() {
            return Message_state_enum.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getMessageState().toString();
        }

        public static enum Message_state_enum {
            ENROUTE(1),
            DELIVERED(2),
            EXPIRED(3),
            DELETED(4),
            UNDELIVERABLE(5),
            ACCEPTED(6),
            UNKNOWN(7),
            REJECTED(8);

            private byte value;

            private Message_state_enum(int value) {
                this.value = (byte)value;
            }

            public byte byteValue() {
                return this.value;
            }

            public static Message_state_enum toEnum(short value) {
                for (Message_state_enum v : Message_state_enum.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return null;
            }
        }
    }

    public static class More_messages_to_send
    extends Byte {
        public More_messages_to_send(More_messages_to_send_enum status) {
            this(status.value);
        }

        public More_messages_to_send(byte value) {
            super(Tag.MORE_MESSAGES_TO_SEND, value);
        }

        public More_messages_to_send(byte[] content) {
            super(Tag.MORE_MESSAGES_TO_SEND.code, content);
        }

        public More_messages_to_send_enum getDeliveryFailureReason() {
            return More_messages_to_send_enum.toEnum(this.value);
        }

        public static enum More_messages_to_send_enum {
            NO_MORE_MESSAGES_TO_FOLLOW(0),
            MORE_MESSAGES_TO_FOLLOW(1),
            RESERVED(2);

            protected byte value;

            private More_messages_to_send_enum(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static More_messages_to_send_enum toEnum(byte value) {
                for (More_messages_to_send_enum v : More_messages_to_send_enum.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Delivery_failure_reason
    extends Byte {
        public Delivery_failure_reason(Delivery_failure_reason_enum status) {
            this(status.value);
        }

        public Delivery_failure_reason(byte value) {
            super(Tag.DELIVERY_FAILURE_REASON, value);
        }

        public Delivery_failure_reason(byte[] content) {
            super(Tag.DELIVERY_FAILURE_REASON.code, content);
        }

        public Delivery_failure_reason_enum getDeliveryFailureReason() {
            return Delivery_failure_reason_enum.toEnum(this.value);
        }

        public static enum Delivery_failure_reason_enum {
            DESTINATION_UNAVAILABLE(0),
            DESTINATION_ADDRESS_INVALID(1),
            PERMANENT_NETWORK_ERROR(2),
            TEMPORARY_NETWORK_ERROR(3),
            RESERVED(4);

            protected byte value;

            private Delivery_failure_reason_enum(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Delivery_failure_reason_enum toEnum(byte value) {
                for (Delivery_failure_reason_enum v : Delivery_failure_reason_enum.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Message_payload
    extends OctetString {
        public Message_payload(byte[] value) {
            super(Tag.MESSAGE_PAYLOAD.code(), value);
        }
    }

    public static class Network_error_code
    extends OctetString {
        public Network_error_code(Network_error_code_type network_type, short error_code) {
            super(Tag.NETWORK_ERROR_CODE.code, new byte[]{network_type.value, (byte)(error_code >> 8 & 0xFF), (byte)(error_code & 0xFF)});
        }

        public Network_error_code(byte[] content) {
            super(Tag.NETWORK_ERROR_CODE.code, content);
        }

        public Network_error_code_type getNetworkType() {
            return Network_error_code_type.toEnum(this.value[0]);
        }

        public short getErrorCode() {
            return (short)((this.value[1] & 0xFF) << 8 | this.value[2] & 0xFF);
        }

        public static enum Network_error_code_type {
            ANSI_136(1),
            IS_95(2),
            GSM(3),
            ANSI_136_CAUSE_CODE(4),
            IS_95_CAUSE_CODE(5),
            ANSI_41_ERROR(6),
            SMPP_ERROR(7),
            MESSAGE_CENTER_SPECIFIC(8),
            RESERVED(9);

            protected byte value;

            private Network_error_code_type(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Network_error_code_type toEnum(byte value) {
                for (Network_error_code_type v : Network_error_code_type.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Ms_availability_status
    extends Byte {
        public Ms_availability_status(Ms_availability_status_enum status) {
            this(status.value);
        }

        public Ms_availability_status(byte value) {
            super(Tag.MS_AVAILABILITY_STATUS, value);
        }

        public Ms_availability_status(byte[] content) {
            super(Tag.MS_AVAILABILITY_STATUS.code, content);
        }

        public Ms_availability_status_enum getMsAvailabilityStatus() {
            return Ms_availability_status_enum.toEnum(this.value);
        }

        public static enum Ms_availability_status_enum {
            AVAILABLE(0),
            DENIED(1),
            UNAVAILABLE(2),
            RESERVED(3);

            protected byte value;

            private Ms_availability_status_enum(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Ms_availability_status_enum toEnum(byte value) {
                for (Ms_availability_status_enum v : Ms_availability_status_enum.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Set_dpf
    extends Byte {
        public Set_dpf(boolean set_dpf) {
            this(set_dpf ? (byte)1 : 0);
        }

        public Set_dpf(byte value) {
            super(Tag.SET_DPF, value);
        }

        public Set_dpf(byte[] content) {
            super(Tag.SET_DPF.code, content);
        }

        public boolean isDpfSet() {
            return this.value == 1;
        }
    }

    public static class Dpf_result
    extends Byte {
        public Dpf_result(boolean dpf_result) {
            this(dpf_result ? (byte)1 : 0);
        }

        public Dpf_result(byte value) {
            super(Tag.DPF_RESULT, value);
        }

        public Dpf_result(byte[] content) {
            super(Tag.DPF_RESULT.code, content);
        }

        public boolean getDpfResult() {
            return this.value == 1;
        }
    }

    public static class Callback_num
    extends OctetString {
        public Callback_num(byte[] content) {
            super(Tag.CALLBACK_NUM.code, content);
        }
    }

    public static class Number_of_messages
    extends Byte {
        public Number_of_messages(byte value) {
            super(Tag.NUMBER_OF_MESSAGES, value);
        }

        public Number_of_messages(byte[] content) {
            super(Tag.NUMBER_OF_MESSAGES.code, content);
        }
    }

    public static class Callback_num_atag
    extends OctetString {
        public Callback_num_atag(byte[] content) {
            super(Tag.CALLBACK_NUM_ATAG.code, content);
        }
    }

    public static class Callback_num_pres_ind
    extends Byte {
        public Callback_num_pres_ind(Presentation_Indicator presentation_indicator, Screening_Indicator screening_indicator) {
            this((byte)(presentation_indicator.value << 2 | screening_indicator.value));
        }

        public Callback_num_pres_ind(byte value) {
            super(Tag.CALLBACK_NUM_PRES_IND, value);
        }

        public Callback_num_pres_ind(byte[] content) {
            super(Tag.CALLBACK_NUM_PRES_IND.code, content);
        }

        public Presentation_Indicator getPresentationIndicator() {
            return Presentation_Indicator.toEnum((byte)(this.value >> 2 & 3));
        }

        public Screening_Indicator getScreeningIndicator() {
            return Screening_Indicator.toEnum((byte)(this.value & 3));
        }

        public static enum Screening_Indicator {
            USER_PROVIDED_VERIFIED_NOT_SCREENED(0),
            USER_PROVIDED_VERIFIED_AND_PASSED(1),
            USER_PROVIDED_VERIFIED_AND_FAILED(2),
            NETWORK_PROVIDED(3);

            protected byte value;

            private Screening_Indicator(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Screening_Indicator toEnum(byte value) {
                for (Screening_Indicator v : Screening_Indicator.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                throw new IllegalArgumentException("Screening indicator value " + value + " is invalid");
            }
        }

        public static enum Presentation_Indicator {
            PRESENTATION_ALLOWED(0),
            PRESENTATION_RESTRICTED(1),
            NUMBER_NOT_AVAILABLE(2),
            RESERVED(3);

            protected byte value;

            private Presentation_Indicator(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Presentation_Indicator toEnum(byte value) {
                for (Presentation_Indicator v : Presentation_Indicator.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Sc_interface_version
    extends Byte {
        public Sc_interface_version(InterfaceVersion interface_version) {
            this(interface_version.value());
        }

        public Sc_interface_version(byte value) {
            super(Tag.SC_INTERFACE_VERSION, value);
        }

        public Sc_interface_version(byte[] content) {
            super(Tag.SC_INTERFACE_VERSION.code, content);
        }
    }

    public static class Sar_segment_seqnum
    extends Byte {
        public Sar_segment_seqnum(byte value) {
            super(Tag.SAR_SEGMENT_SEQNUM, value);
        }

        public Sar_segment_seqnum(byte[] content) {
            super(Tag.SAR_SEGMENT_SEQNUM.code, content);
        }
    }

    public static class Sar_total_segments
    extends Byte {
        public Sar_total_segments(byte value) {
            super(Tag.SAR_TOTAL_SEGMENTS, value);
        }

        public Sar_total_segments(byte[] content) {
            super(Tag.SAR_TOTAL_SEGMENTS.code, content);
        }
    }

    public static class Language_indicator
    extends Byte {
        public Language_indicator(Language_indicator_enum value) {
            this(value.value);
        }

        public Language_indicator(byte value) {
            super(Tag.LANGUAGE_INDICATOR, value);
        }

        public Language_indicator(byte[] content) {
            super(Tag.LANGUAGE_INDICATOR.code, content);
        }

        public Language_indicator_enum getLanguageIndicator() {
            return Language_indicator_enum.toEnum(this.value);
        }

        public static enum Language_indicator_enum {
            UNSPECIFIED_DEFAULT(0),
            ENGLISH(1),
            FRENCH(2),
            SPANISH(3),
            GERMAN(4),
            PORTUGUESE(5),
            RESERVED(255);

            protected byte value;

            private Language_indicator_enum(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Language_indicator_enum toEnum(byte value) {
                for (Language_indicator_enum v : Language_indicator_enum.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Sar_msg_ref_num
    extends Short {
        public Sar_msg_ref_num(short value) {
            super(Tag.SAR_MSG_REF_NUM, value);
        }

        public Sar_msg_ref_num(byte[] content) {
            super(Tag.SAR_MSG_REF_NUM.code, content);
        }
    }

    public static class Destination_port
    extends Short {
        public Destination_port(short value) {
            super(Tag.DESTINATION_PORT, value);
        }

        public Destination_port(byte[] content) {
            super(Tag.DESTINATION_PORT.code, content);
        }
    }

    public static class Source_port
    extends Short {
        public Source_port(short value) {
            super(Tag.SOURCE_PORT, value);
        }

        public Source_port(byte[] content) {
            super(Tag.SOURCE_PORT.code, content);
        }
    }

    public static class User_response_code
    extends Byte {
        public User_response_code(byte value) {
            super(Tag.USER_MESSAGE_REFERENCE, value);
        }

        public User_response_code(byte[] content) {
            super(Tag.USER_MESSAGE_REFERENCE.code, content);
        }
    }

    public static class User_message_reference
    extends Short {
        public User_message_reference(short value) {
            super(Tag.USER_MESSAGE_REFERENCE, value);
        }

        public User_message_reference(byte[] content) {
            super(Tag.USER_MESSAGE_REFERENCE.code, content);
        }
    }

    public static class Dest_subaddress
    extends OctetString {
        public Dest_subaddress(byte[] content) {
            super(Tag.DEST_SUBADDRESS.code, content);
        }
    }

    public static class Source_subaddress
    extends OctetString {
        public Source_subaddress(byte[] content) {
            super(Tag.SOURCE_SUBADDRESS.code, content);
        }
    }

    public static class Privacy_indicator
    extends Byte {
        public Privacy_indicator(byte value) {
            super(Tag.PRIVACY_INDICATOR, value);
        }

        public Privacy_indicator(byte[] content) {
            super(Tag.PRIVACY_INDICATOR.code, content);
        }
    }

    public static class Ms_msg_wait_facilities
    extends Byte {
        public Ms_msg_wait_facilities(boolean indicatorActive, Ms_msg_wait_facilities_type message_type) {
            this((byte)(message_type.value() | (indicatorActive ? 128 : 0)));
        }

        public Ms_msg_wait_facilities(byte value) {
            super(Tag.MS_MSG_WAIT_FACILITIES, value);
        }

        public Ms_msg_wait_facilities(byte[] content) {
            super(Tag.MS_MSG_WAIT_FACILITIES.code, content);
        }

        public boolean isIndicatorActive() {
            return (this.value & 0x80) != 0;
        }

        public Ms_msg_wait_facilities_type getMessageType() {
            return Ms_msg_wait_facilities_type.toEnum((byte)(this.value & 3));
        }

        @Override
        public String toString() {
            String endString = this.isIndicatorActive() ? "active" : "inactive";
            return this.getMessageType().toString() + " set as " + endString;
        }

        public static enum Ms_msg_wait_facilities_type {
            VOICEMAIL_MESSAGE_WAITING(0),
            FAX_MESSAGE_WAITING(1),
            ELECTRONIC_MAIL_MESSAGE_WAITING(2),
            OTHER_MESSAGE_WAITING(3),
            UNKNOWN(4);

            protected byte value;

            private Ms_msg_wait_facilities_type(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Ms_msg_wait_facilities_type toEnum(byte value) {
                for (Ms_msg_wait_facilities_type v : Ms_msg_wait_facilities_type.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return UNKNOWN;
            }
        }
    }

    public static class Receipted_message_id
    extends COctetString {
        public Receipted_message_id(byte[] value) {
            super(Tag.RECEIPTED_MESSAGE_ID.code(), value);
        }

        public Receipted_message_id(String value) {
            super(Tag.RECEIPTED_MESSAGE_ID.code(), value);
        }
    }

    public static class Additional_status_info_text
    extends COctetString {
        public Additional_status_info_text(byte[] value) {
            super(Tag.ADDITIONAL_STATUS_INFO_TEXT.code(), value);
        }

        public Additional_status_info_text(String value) {
            super(Tag.ADDITIONAL_STATUS_INFO_TEXT.code(), value);
        }
    }

    public static class Payload_type
    extends Byte {
        public Payload_type(Payload_type_enum payload_type) {
            this(payload_type.value);
        }

        public Payload_type(byte value) {
            super(Tag.PAYLOAD_TYPE, value);
        }

        public Payload_type(byte[] content) {
            super(Tag.PAYLOAD_TYPE.code, content);
        }

        public Payload_type_enum getPayloadType() {
            return Payload_type_enum.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getPayloadType().toString();
        }

        public static enum Payload_type_enum {
            DEFAULT(0),
            WCMP(1),
            RESERVED(255);

            protected byte value;

            private Payload_type_enum(int value) {
                this.value = (byte)value;
            }

            public byte value() {
                return this.value;
            }

            public static Payload_type_enum toEnum(byte value) {
                for (Payload_type_enum v : Payload_type_enum.values()) {
                    if (v.value != value) continue;
                    return v;
                }
                return RESERVED;
            }
        }
    }

    public static class Qos_time_to_live
    extends Int {
        public Qos_time_to_live(int value) {
            super(Tag.QOS_TIME_TO_LIVE, value);
        }

        public Qos_time_to_live(byte[] content) {
            super(Tag.QOS_TIME_TO_LIVE.code, content);
        }
    }

    public static class Source_telematics_id
    extends Byte {
        public Source_telematics_id(byte value) {
            super(Tag.SOURCE_TELEMATICS_ID, value);
        }

        public Source_telematics_id(byte[] content) {
            super(Tag.SOURCE_TELEMATICS_ID.code, content);
        }
    }

    public static class Source_bearer_type
    extends Byte {
        public Source_bearer_type(Bearer_type bearer_type) {
            this(bearer_type.value);
        }

        public Source_bearer_type(byte value) {
            super(Tag.SOURCE_BEARER_TYPE, value);
        }

        public Source_bearer_type(byte[] content) {
            super(Tag.SOURCE_BEARER_TYPE.code, content);
        }

        public Bearer_type getSourceBearerType() {
            return Bearer_type.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getSourceBearerType().toString();
        }
    }

    public static class Source_network_type
    extends Byte {
        public Source_network_type(Network_type network_type) {
            this(network_type.value);
        }

        public Source_network_type(byte value) {
            super(Tag.SOURCE_NETWORK_TYPE, value);
        }

        public Source_network_type(byte[] content) {
            super(Tag.SOURCE_NETWORK_TYPE.code, content);
        }

        public Network_type getSourceNetworkType() {
            return Network_type.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getSourceNetworkType().toString();
        }
    }

    public static class Source_addr_subunit
    extends Byte {
        public Source_addr_subunit(Addr_subunit addr_subunit) {
            this(addr_subunit.value());
        }

        public Source_addr_subunit(byte value) {
            super(Tag.SOURCE_ADDR_SUBUNIT, value);
        }

        public Source_addr_subunit(byte[] content) {
            super(Tag.SOURCE_ADDR_SUBUNIT.code, content);
        }

        public Addr_subunit getSourceAddrSubunit() {
            return Addr_subunit.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getSourceAddrSubunit().toString();
        }
    }

    public static class Dest_telematics_id
    extends Short {
        public Dest_telematics_id(short value) {
            super(Tag.DEST_TELEMATICS_ID, value);
        }

        public Dest_telematics_id(byte[] content) {
            super(Tag.DEST_TELEMATICS_ID.code, content);
        }
    }

    public static class Dest_bearer_type
    extends Byte {
        public Dest_bearer_type(Bearer_type bearer_type) {
            this(bearer_type.value);
        }

        public Dest_bearer_type(byte value) {
            super(Tag.DEST_BEARER_TYPE, value);
        }

        public Dest_bearer_type(byte[] content) {
            super(Tag.DEST_BEARER_TYPE.code, content);
        }

        public Bearer_type getDestBearerType() {
            return Bearer_type.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getDestBearerType().toString();
        }
    }

    public static enum Bearer_type {
        UNKNOWN(0),
        SMS(1),
        CIRCUIT_SWITCHED_DATA(2),
        PACKET_DATA(3),
        USSD(4),
        CDPD(5),
        DATATAC(6),
        FLEX_REFLEX(7),
        CELL_BROADCAST_CELLCAST(8),
        RESERVED(9);

        protected byte value;

        private Bearer_type(int value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }

        public static Bearer_type toEnum(byte value) {
            for (Bearer_type v : Bearer_type.values()) {
                if (v.value != value) continue;
                return v;
            }
            return RESERVED;
        }
    }

    public static class Dest_network_type
    extends Byte {
        public Dest_network_type(Network_type network_type) {
            this(network_type.value);
        }

        public Dest_network_type(byte value) {
            super(Tag.DEST_NETWORK_TYPE, value);
        }

        public Dest_network_type(byte[] content) {
            super(Tag.DEST_NETWORK_TYPE.code, content);
        }

        public Network_type getDestNetworkType() {
            return Network_type.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getDestNetworkType().toString();
        }
    }

    public static enum Network_type {
        UNKNOWN(0),
        GSM(1),
        ANSI_136_TDMA(2),
        IS_95_CDMA(3),
        PDC(4),
        PHS(5),
        IDEN(6),
        AMPS(7),
        PAGING_NETWORK(8),
        RESERVED(9);

        protected byte value;

        private Network_type(int value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }

        public static Network_type toEnum(byte value) {
            for (Network_type v : Network_type.values()) {
                if (v.value != value) continue;
                return v;
            }
            return RESERVED;
        }
    }

    public static class Dest_addr_subunit
    extends Byte {
        public Dest_addr_subunit(Addr_subunit addr_subunit) {
            this(addr_subunit.value());
        }

        public Dest_addr_subunit(byte value) {
            super(Tag.DEST_ADDR_SUBUNIT, value);
        }

        public Dest_addr_subunit(byte[] content) {
            super(Tag.DEST_ADDR_SUBUNIT.code, content);
        }

        public Addr_subunit getDestAddrSubunit() {
            return Addr_subunit.toEnum(this.value);
        }

        @Override
        public String toString() {
            return this.getDestAddrSubunit().toString();
        }
    }

    public static enum Addr_subunit {
        UNKNOWN_DEFAULT(0),
        MS_DISPLAY(1),
        MOBILE_EQUIPMENT(2),
        SMART_CARD_1(3),
        EXTERNAL_UNIT_1(4),
        RESERVED(5);

        protected byte value;

        private Addr_subunit(int value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }

        public static Addr_subunit toEnum(byte value) {
            for (Addr_subunit v : Addr_subunit.values()) {
                if (v.value != value) continue;
                return v;
            }
            return RESERVED;
        }
    }

    public static class COctetString
    extends OctetString {
        public COctetString(short tag, String value, String charsetName) throws UnsupportedEncodingException {
            super(tag, new byte[value.getBytes(charsetName).length + 1]);
            byte[] bytes = value.getBytes(charsetName);
            System.arraycopy(bytes, 0, this.value, 0, bytes.length);
            this.value[bytes.length] = 0;
        }

        public COctetString(short tag, String value) {
            super(tag, new byte[value.getBytes().length + 1]);
            byte[] bytes = value.getBytes();
            System.arraycopy(bytes, 0, this.value, 0, bytes.length);
            this.value[bytes.length] = 0;
        }

        public COctetString(short tag, byte[] value) {
            super(tag, value);
        }

        @Override
        public String getValueAsString() {
            byte[] s = new byte[this.value.length > 0 ? this.value.length - 1 : 0];
            System.arraycopy(this.value, 0, s, 0, s.length);
            return new String(s);
        }
    }

    public static class OctetString
    extends OptionalParameter {
        protected final byte[] value;

        public OctetString(short tag, String value) {
            super(tag);
            this.value = value.getBytes();
        }

        public OctetString(Tag tag, String value) {
            this(tag.code(), value);
        }

        public OctetString(short tag, String value, String charsetName) throws UnsupportedEncodingException {
            super(tag);
            this.value = value.getBytes(charsetName);
        }

        public OctetString(short tag, byte[] value) {
            super(tag);
            this.value = value;
        }

        public OctetString(short tag, byte[] value, int offset, int length) {
            super(tag);
            this.value = new byte[length];
            System.arraycopy(value, offset, this.value, offset, length);
        }

        public byte[] getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return new String(this.value);
        }

        @Override
        protected byte[] serializeValue() {
            return this.value;
        }
    }

    public static class Byte
    extends OptionalParameter {
        protected final byte value;

        public Byte(short tag, byte value) {
            super(tag);
            this.value = value;
        }

        public Byte(Tag tag, byte value) {
            this(tag.code(), value);
        }

        public Byte(short tag, byte[] content) {
            this(tag, content[0]);
        }

        public byte getValue() {
            return this.value;
        }

        @Override
        protected byte[] serializeValue() {
            return new byte[]{this.value};
        }

        public String toString() {
            return HexUtil.conventBytesToHexString(new byte[]{this.getValue()});
        }
    }

    public static class Int
    extends OptionalParameter {
        protected final int value;

        public Int(short tag, int value) {
            super(tag);
            this.value = value;
        }

        public Int(Tag tag, int value) {
            this(tag.code(), value);
        }

        public Int(short tag, byte[] content) {
            this(tag, OctetUtil.bytesToInt(content));
        }

        public int getValue() {
            return this.value;
        }

        @Override
        protected byte[] serializeValue() {
            return OctetUtil.intToBytes(this.value);
        }

        public String toString() {
            return HexUtil.conventBytesToHexString(OctetUtil.intToBytes(this.value));
        }
    }

    public static class Short
    extends OptionalParameter {
        protected final short value;

        public Short(short tag, short value) {
            super(tag);
            this.value = value;
        }

        public Short(Tag tag, short value) {
            this(tag.code(), value);
        }

        public Short(short tag, byte[] value) {
            this(tag, OctetUtil.bytesToShort(value));
        }

        public short getValue() {
            return this.value;
        }

        @Override
        protected byte[] serializeValue() {
            return OctetUtil.shortToBytes(this.value);
        }

        public String toString() {
            return HexUtil.conventBytesToHexString(OctetUtil.shortToBytes(this.value));
        }
    }

    public static class Null
    extends OptionalParameter {
        public Null(short tag) {
            super(tag);
        }

        public Null(Tag tag) {
            this(tag.code());
        }

        @Override
        protected byte[] serializeValue() {
            return new byte[0];
        }
    }
}

