/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.SpringCamelContextFactory;

public class CamelContextCreateProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        if (depUnit.getParent() != null) {
            return;
        }
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        String runtimeName = depUnit.getName();
        ArrayList<URL> contextURLs = new ArrayList<URL>();
        try {
            if (runtimeName.endsWith("-camel-context.xml")) {
                contextURLs.add(((VirtualFile)depUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS)).asFileURL());
            } else {
                VirtualFileFilter filter = new VirtualFileFilter(){

                    public boolean accepts(VirtualFile child) {
                        return child.isFile() && child.getName().endsWith("-camel-context.xml");
                    }
                };
                VirtualFile rootFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
                for (VirtualFile contextFile : rootFile.getChildrenRecursively(filter)) {
                    contextURLs.add(contextFile.asFileURL());
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create camel context: " + runtimeName, ex);
        }
        for (URL contextURL : contextURLs) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
                CamelContext camelctx = SpringCamelContextFactory.createSpringCamelContext(contextURL, (ClassLoader)module.getClassLoader());
                depUnit.addToAttachmentList(CamelConstants.CAMEL_CONTEXT_KEY, (Object)camelctx);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create camel context: " + runtimeName, ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

