/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.util.AnnotationModelLoader;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BindyAbstractFactory
implements BindyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BindyAbstractFactory.class);
    protected final Map<String, List<Field>> annotatedLinkFields = new LinkedHashMap<String, List<Field>>();
    protected Set<Class<?>> models;
    protected Set<String> modelClassNames;
    protected String crlf;
    private AnnotationModelLoader modelsLoader;
    private String[] packageNames;
    private String locale;
    private Class<?> type;

    public BindyAbstractFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        this.modelsLoader = new AnnotationModelLoader(resolver);
        this.packageNames = packageNames;
        if (LOG.isDebugEnabled()) {
            for (String str : this.packageNames) {
                LOG.debug("Package name: {}", (Object)str);
            }
        }
        this.initModel();
    }

    public BindyAbstractFactory(PackageScanClassResolver resolver, Class<?> type) throws Exception {
        this.modelsLoader = new AnnotationModelLoader(resolver);
        this.type = type;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class name: {}", (Object)type.getName());
        }
        this.initModel();
    }

    public BindyAbstractFactory(PackageScanClassResolver resolver, Class<?> type, PackageScanFilter scanFilter) throws Exception {
        this.modelsLoader = new AnnotationModelLoader(resolver, scanFilter);
        this.type = type;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class name: {}", (Object)type.getName());
        }
        this.initModel();
    }

    public BindyAbstractFactory(PackageScanClassResolver resolver, String[] packageNames, PackageScanFilter scanFilter) throws Exception {
        this.modelsLoader = new AnnotationModelLoader(resolver, scanFilter);
        this.packageNames = packageNames;
        if (LOG.isDebugEnabled()) {
            for (String str : this.packageNames) {
                LOG.debug("Package name: {}", (Object)str);
            }
        }
        this.initModel();
    }

    @Override
    public void initModel() throws Exception {
        if (this.packageNames != null) {
            this.initModelClasses(this.packageNames);
        } else if (this.type != null) {
            String pckName = this.type.getPackage().getName();
            this.initModelClasses(pckName);
        } else {
            throw new IllegalArgumentException("Either packagenames or type should be configured");
        }
        this.modelClassNames = new HashSet<String>();
        for (Class<?> clazz : this.models) {
            this.modelClassNames.add(clazz.getName());
        }
    }

    private void initModelClasses(String ... packageNames) throws Exception {
        this.models = this.modelsLoader.loadModels(packageNames);
    }

    public abstract void initAnnotatedFields() throws Exception;

    @Override
    public abstract void bind(List<String> var1, Map<String, Object> var2, int var3) throws Exception;

    @Override
    public abstract String unbind(Map<String, Object> var1) throws Exception;

    public void link(Map<String, Object> model) throws Exception {
        for (String link : this.annotatedLinkFields.keySet()) {
            List<Field> linkFields = this.annotatedLinkFields.get(link);
            for (Field field : linkFields) {
                field.setAccessible(true);
                String toClassName = field.getType().getName();
                Object to = model.get(toClassName);
                ObjectHelper.notNull((Object)to, (String)"No @link annotation has been defined for the object to link");
                field.set(model.get(field.getDeclaringClass().getName()), to);
            }
        }
    }

    public Map<String, Object> factory() throws Exception {
        HashMap<String, Object> mapModel = new HashMap<String, Object>();
        for (Class<?> cl : this.models) {
            Object obj = ObjectHelper.newInstance(cl);
            mapModel.put(obj.getClass().getName(), obj);
        }
        return mapModel;
    }

    public boolean supportsModel(Set<String> classes) {
        return this.modelClassNames.containsAll(classes);
    }

    protected static Integer generateKey(Integer key1, Integer key2) {
        if (key1 == null || key2 == null) {
            throw new IllegalArgumentException("@Section and/or @KeyValuePairDataField have not been defined");
        }
        String key2Formatted = BindyAbstractFactory.getNumberFormat().format(key2.intValue());
        String keyGenerated = String.valueOf(key1) + key2Formatted;
        return Integer.valueOf(keyGenerated);
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(3);
        nf.setMinimumIntegerDigits(3);
        return nf;
    }

    public static Object getDefaultValueForPrimitive(Class<?> clazz) throws Exception {
        if (clazz == Byte.TYPE) {
            return (byte)-128;
        }
        if (clazz == Short.TYPE) {
            return (short)Short.MIN_VALUE;
        }
        if (clazz == Integer.TYPE) {
            return Integer.MIN_VALUE;
        }
        if (clazz == Long.TYPE) {
            return Long.MIN_VALUE;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        if (clazz == Double.TYPE) {
            return Double.MIN_VALUE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public String getCarriageReturn() {
        return this.crlf;
    }

    public String formatString(Format<?> format, Object value) throws Exception {
        String strValue = "";
        if (value != null) {
            try {
                strValue = format.format(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Formatting error detected for the value: " + value, e);
            }
        }
        return strValue;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

