/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.jgroups.Address;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JGroupsFilters {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsFilters.class);
    private static final int COORDINATOR_NODE_INDEX = 0;

    private JGroupsFilters() {
    }

    public static Predicate dropNonCoordinatorViews() {
        return new Predicate(){

            public boolean matches(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                LOG.debug("Filtering message {}.", body);
                if (body instanceof View) {
                    View view = (View)body;
                    Address coordinatorNodeAddress = (Address)view.getMembers().get(0);
                    Address channelAddress = (Address)exchange.getIn().getHeader("JGROUPS_CHANNEL_ADDRESS", Address.class);
                    LOG.debug("Comparing endpoint channel address {} against the coordinator node address {}.", (Object)channelAddress, (Object)coordinatorNodeAddress);
                    return channelAddress.equals(coordinatorNodeAddress);
                }
                LOG.debug("Body {} is not an instance of org.jgroups.View . Skipping filter.", body);
                return true;
            }
        };
    }
}

