/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fusesource.camel.component.sap.SapConsumer;
import org.fusesource.camel.component.sap.SapSynchronousRfcServerEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Request;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapSynchronousRfcConsumer
extends SapConsumer
implements JCoServerFunctionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SapSynchronousRfcConsumer.class);

    public SapSynchronousRfcConsumer(SapSynchronousRfcServerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public SapSynchronousRfcServerEndpoint getEndpoint() {
        return (SapSynchronousRfcServerEndpoint)super.getEndpoint();
    }

    public void handleRequest(JCoServerContext serverContext, JCoFunction jcoFunction) throws AbapException, AbapClassException {
        Message message;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling request for RFC '{}'", (Object)jcoFunction.getName());
        }
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOut);
        Request request = RfcUtil.getRequest(serverContext.getRepository(), jcoFunction.getName());
        RfcUtil.extractJCoParameterListsIntoRequest(jcoFunction, request);
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Request: " + (request == null ? request : RfcUtil.marshal(request)));
            }
            catch (IOException e) {
                LOG.warn("Failed to log request", (Throwable)e);
            }
        }
        try {
            message = exchange.getIn();
            if (this.isStateful()) {
                exchange.setProperty("org.fusesource.camel.component.sap.sessionContext", (Object)this.sessionContext);
            }
            message.setBody((Object)request);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new AbapException("ROUTE_EXCEPTION", e.getMessage());
        }
        if (exchange.getException() != null) {
            throw new AbapException("ROUTE_EXCEPTION", exchange.getException().getMessage());
        }
        message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        Structure response = (Structure)message.getBody(Structure.class);
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Response: " + (response == null ? response : RfcUtil.marshal(response)));
            }
            catch (Exception e) {
                LOG.warn("Failed to log response", (Throwable)e);
            }
        }
        RfcUtil.fillJCoParameterListsFromResponse(response, jcoFunction);
    }
}

