/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.fusesource.camel.component.sap.DestinationSapStatefulSessionHandler;
import org.fusesource.camel.component.sap.DestinationSapTransactionHandler;
import org.fusesource.camel.component.sap.SapSynchronousRfcDestinationEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapSynchronousRfcProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SapSynchronousRfcProducer.class);

    public SapSynchronousRfcProducer(SapSynchronousRfcDestinationEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isTransacted()) {
            DestinationSapTransactionHandler.ensureSapTransactionHasBegunAndIsHandled(exchange, this.getEndpoint().getDestination());
        } else if (this.getEndpoint().isStateful()) {
            DestinationSapStatefulSessionHandler.ensureSapStatefulSessionHasBegunAndIsHandled(exchange, this.getEndpoint().getDestination());
        }
        Structure request = (Structure)exchange.getIn().getBody(Structure.class);
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Calling '{}' RFC", (Object)this.getEndpoint().getRfcName());
                LOG.debug("Request: " + (request == null ? request : RfcUtil.marshal(request)));
            }
            catch (Exception e) {
                LOG.warn("Failed to log request", (Throwable)e);
            }
        }
        Structure response = RfcUtil.executeFunction(this.getEndpoint().getDestination(), this.getEndpoint().getRfcName(), request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response: " + (response == null ? response : RfcUtil.marshal(response)));
        }
        exchange.setOut(exchange.getIn().copy());
        exchange.getOut().setBody((Object)response);
    }

    public SapSynchronousRfcDestinationEndpoint getEndpoint() {
        return (SapSynchronousRfcDestinationEndpoint)super.getEndpoint();
    }
}

