/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.jco.server.JCoServerContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fusesource.camel.component.sap.SapConsumer;
import org.fusesource.camel.component.sap.SapTransactionalIDocListServerEndpoint;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransactionalIDocListConsumer
extends SapConsumer
implements JCoIDocHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocListConsumer.class);

    public SapTransactionalIDocListConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public SapTransactionalIDocListServerEndpoint getEndpoint() {
        return (SapTransactionalIDocListServerEndpoint)super.getEndpoint();
    }

    public void handleRequest(JCoServerContext serverContext, IDocDocumentList idocDocumentList) {
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOnly);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handling IDoc document {}", (Object)idocDocumentList.toString());
            }
            DocumentList documentList = IDocUtil.createDocumentList(this.getEndpoint().getServer().getIDocRepository(), idocDocumentList.getIDocType(), idocDocumentList.getIDocTypeExtension(), idocDocumentList.getSystemRelease(), idocDocumentList.getApplicationRelease());
            IDocUtil.extractIDocDocumentListIntoDocumentList(idocDocumentList, documentList);
            Message message = exchange.getIn();
            if (this.isStateful()) {
                exchange.setProperty("org.fusesource.camel.component.sap.sessionContext", (Object)this.sessionContext);
            }
            message.setBody((Object)documentList);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            if (this.getEndpoint().isPropagateExceptions()) {
                throw new IDocRuntimeException(e.getMessage(), (Throwable)e);
            }
            this.getExceptionHandler().handleException("Failed to process document list", (Throwable)e);
        }
        if (exchange.getException() != null && this.getEndpoint().isPropagateExceptions()) {
            throw new IDocRuntimeException(exchange.getException().getMessage(), (Throwable)exchange.getException());
        }
    }
}

