/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.model.idoc.impl;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.model.idoc.IdocPackage;
import org.fusesource.camel.component.sap.model.idoc.Segment;
import org.fusesource.camel.component.sap.model.idoc.SegmentChildren;
import org.fusesource.camel.component.sap.model.idoc.SegmentList;
import org.fusesource.camel.component.sap.model.idoc.impl.SegmentChildrenImpl;

public class SegmentImpl
extends EObjectImpl
implements Segment {
    protected Segment parent;
    protected Document document;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected static final String TYPE_EDEFAULT = null;
    protected static final String DEFINITION_EDEFAULT = null;
    protected static final int HIERARCHY_LEVEL_EDEFAULT = -1;
    protected static final String IDOC_TYPE_EDEFAULT = "";
    protected static final String IDOC_TYPE_EXTENSION_EDEFAULT = "";
    protected static final String SYSTEM_RELEASE_EDEFAULT = "";
    protected static final String APPLICATION_RELEASE_EDEFAULT = "";
    protected static final int NUM_FIELDS_EDEFAULT = 0;
    protected static final long MAX_OCCURRENCE_EDEFAULT = 0L;
    protected static final long MIN_OCCURRENCE_EDEFAULT = 0L;
    protected static final boolean MANDATORY_EDEFAULT = false;
    protected static final boolean QUALIFIED_EDEFAULT = false;
    protected static final int RECORD_LENGTH_EDEFAULT = 0;
    private volatile transient EntrySet entrySet = null;
    private volatile transient KeySet keySet = null;
    private volatile transient Values values = null;
    private volatile transient Map<String, EStructuralFeature> filteredFeatureMap;

    protected SegmentImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return IdocPackage.Literals.SEGMENT;
    }

    @Override
    public Segment getParent() {
        if (this.parent != null && this.parent.eIsProxy()) {
            InternalEObject oldParent = (InternalEObject)((Object)this.parent);
            this.parent = (Segment)this.eResolveProxy(oldParent);
            if (this.parent != oldParent && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldParent, (Object)this.parent));
            }
        }
        return this.parent;
    }

    public Segment basicGetParent() {
        return this.parent;
    }

    public void setParent(Segment newParent) {
        Segment oldParent = this.parent;
        this.parent = newParent;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldParent, (Object)this.parent));
        }
    }

    @Override
    public <S extends Segment> EList<S> getChildren() {
        SegmentChildren segmentChildren = this.getSegmentChildren();
        FeatureMap segments = segmentChildren.getSegments();
        BasicEList<Segment> list = new BasicEList<Segment>();
        for (FeatureMap.Entry entry : segments) {
            list.add((Segment)entry.getValue());
        }
        return ECollections.unmodifiableEList(list);
    }

    public SegmentChildren getSegmentChildren() {
        EStructuralFeature feature = this.eClass().getEStructuralFeature("segmentChildren");
        if (feature == null) {
            return null;
        }
        Object value = this.eGet(feature);
        if (value == null) {
            EClass eClass = ((EReference)feature).getEReferenceType();
            value = eClass.getEPackage().getEFactoryInstance().create(eClass);
            ((SegmentChildrenImpl)value).setParent(this);
            this.eSet(feature, value);
        }
        return (SegmentChildren)value;
    }

    @Override
    public <S extends Segment> SegmentList<S> getChildren(String segmentType) {
        SegmentChildren segmentChildren = this.getSegmentChildren();
        return segmentChildren.get(segmentType);
    }

    @Override
    public EList<String> getTypes() {
        return this.getSegmentChildren().getTypes();
    }

    @Override
    public Document getDocument() {
        if (this.document != null && this.document.eIsProxy()) {
            InternalEObject oldDocument = (InternalEObject)((Object)this.document);
            this.document = (Document)this.eResolveProxy(oldDocument);
            if (this.document != oldDocument && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldDocument, (Object)this.document));
            }
        }
        return this.document;
    }

    public Document basicGetDocument() {
        return this.document;
    }

    public void setDocument(Document newDocument) {
        Document oldDocument = this.document;
        this.document = newDocument;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDocument, (Object)this.document));
        }
    }

    @Override
    public String getDescription() {
        String description = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            description = idocAnnotation.getDetails().get("description");
        }
        return description;
    }

    public void setDescription(String newDescription) {
    }

    @Override
    public String getType() {
        String type = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            type = idocAnnotation.getDetails().get("type");
        }
        return type;
    }

    public void setType(String newType) {
    }

    @Override
    public String getDefinition() {
        String definition = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            definition = idocAnnotation.getDetails().get("definition");
        }
        return definition;
    }

    public void setDefinition(String newDefinition) {
    }

    @Override
    public int getHierarchyLevel() {
        int hierarchyLevel = -1;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String hierarchyLevelString = idocAnnotation.getDetails().get("hierarchyLevel");
            try {
                hierarchyLevel = Integer.parseInt(hierarchyLevelString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return hierarchyLevel;
    }

    public void setHierarchyLevel(int newHierarchyLevel) {
    }

    @Override
    public String getIdocType() {
        String idocType = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            idocType = idocAnnotation.getDetails().get("idocType");
        }
        return idocType;
    }

    public void setIdocType(String newIdocType) {
    }

    @Override
    public String getIdocTypeExtension() {
        String idocTypeExtension = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            idocTypeExtension = idocAnnotation.getDetails().get("idocTypeExtension");
        }
        return idocTypeExtension;
    }

    public void setIdocTypeExtension(String newIdocTypeExtension) {
    }

    @Override
    public String getSystemRelease() {
        String systemRelease = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            systemRelease = idocAnnotation.getDetails().get("systemRelease");
        }
        return systemRelease;
    }

    public void setSystemRelease(String newSystemRelease) {
    }

    @Override
    public String getApplicationRelease() {
        String applicationRelease = null;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            applicationRelease = idocAnnotation.getDetails().get("applicationRelease");
        }
        return applicationRelease;
    }

    public void setApplicationRelease(String newApplicationRelease) {
    }

    @Override
    public int getNumFields() {
        int numFields = -1;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String numFieldsString = idocAnnotation.getDetails().get("numFields");
            try {
                numFields = Integer.parseInt(numFieldsString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return numFields;
    }

    public void setNumFields(int newNumFields) {
    }

    @Override
    public long getMaxOccurrence() {
        long maxOccurrence = -1L;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String maxOccurrenceString = idocAnnotation.getDetails().get("maxOccurrence");
            try {
                maxOccurrence = Long.parseLong(maxOccurrenceString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxOccurrence;
    }

    public void setMaxOccurrence(long newMaxOccurrence) {
    }

    @Override
    public long getMinOccurrence() {
        long minOccurrence = -1L;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String minOccurrenceString = idocAnnotation.getDetails().get("minOccurrence");
            try {
                minOccurrence = Long.parseLong(minOccurrenceString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return minOccurrence;
    }

    public void setMinOccurrence(long newMinOccurrence) {
    }

    @Override
    public boolean isMandatory() {
        boolean isMandatory = false;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String isManadatoryString = idocAnnotation.getDetails().get("isMandatory");
            try {
                isMandatory = Boolean.parseBoolean(isManadatoryString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return isMandatory;
    }

    public void setMandatory(boolean newMandatory) {
    }

    @Override
    public boolean isQualified() {
        boolean isQualified = false;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String isQualifiedString = idocAnnotation.getDetails().get("isQualified");
            try {
                isQualified = Boolean.parseBoolean(isQualifiedString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return isQualified;
    }

    public void setQualified(boolean newQualified) {
    }

    @Override
    public int getRecordLength() {
        int recordLength = -1;
        EAnnotation idocAnnotation = this.eClass().getEAnnotation("http://sap.fusesource.org/idoc");
        if (idocAnnotation != null) {
            String recordLengthString = idocAnnotation.getDetails().get("recordLength");
            try {
                recordLength = Integer.parseInt(recordLengthString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return recordLength;
    }

    public void setRecordLength(int newRecordLength) {
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getParent();
                }
                return this.basicGetParent();
            }
            case 1: {
                if (resolve) {
                    return this.getDocument();
                }
                return this.basicGetDocument();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getType();
            }
            case 4: {
                return this.getDefinition();
            }
            case 5: {
                return this.getHierarchyLevel();
            }
            case 6: {
                return this.getIdocType();
            }
            case 7: {
                return this.getIdocTypeExtension();
            }
            case 8: {
                return this.getSystemRelease();
            }
            case 9: {
                return this.getApplicationRelease();
            }
            case 10: {
                return this.getNumFields();
            }
            case 11: {
                return this.getMaxOccurrence();
            }
            case 12: {
                return this.getMinOccurrence();
            }
            case 13: {
                return this.isMandatory();
            }
            case 14: {
                return this.isQualified();
            }
            case 15: {
                return this.getRecordLength();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setParent((Segment)newValue);
                return;
            }
            case 1: {
                this.setDocument((Document)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 3: {
                this.setType((String)newValue);
                return;
            }
            case 4: {
                this.setDefinition((String)newValue);
                return;
            }
            case 5: {
                this.setHierarchyLevel((Integer)newValue);
                return;
            }
            case 6: {
                this.setIdocType((String)newValue);
                return;
            }
            case 7: {
                this.setIdocTypeExtension((String)newValue);
                return;
            }
            case 8: {
                this.setSystemRelease((String)newValue);
                return;
            }
            case 9: {
                this.setApplicationRelease((String)newValue);
                return;
            }
            case 10: {
                this.setNumFields((Integer)newValue);
                return;
            }
            case 11: {
                this.setMaxOccurrence((Long)newValue);
                return;
            }
            case 12: {
                this.setMinOccurrence((Long)newValue);
                return;
            }
            case 13: {
                this.setMandatory((Boolean)newValue);
                return;
            }
            case 14: {
                this.setQualified((Boolean)newValue);
                return;
            }
            case 15: {
                this.setRecordLength((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setParent(null);
                return;
            }
            case 1: {
                this.setDocument(null);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 3: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 4: {
                this.setDefinition(DEFINITION_EDEFAULT);
                return;
            }
            case 5: {
                this.setHierarchyLevel(-1);
                return;
            }
            case 6: {
                this.setIdocType("");
                return;
            }
            case 7: {
                this.setIdocTypeExtension("");
                return;
            }
            case 8: {
                this.setSystemRelease("");
                return;
            }
            case 9: {
                this.setApplicationRelease("");
                return;
            }
            case 10: {
                this.setNumFields(0);
                return;
            }
            case 11: {
                this.setMaxOccurrence(0L);
                return;
            }
            case 12: {
                this.setMinOccurrence(0L);
                return;
            }
            case 13: {
                this.setMandatory(false);
                return;
            }
            case 14: {
                this.setQualified(false);
                return;
            }
            case 15: {
                this.setRecordLength(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.parent != null;
            }
            case 1: {
                return this.document != null;
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.getDescription() != null : !DESCRIPTION_EDEFAULT.equals(this.getDescription());
            }
            case 3: {
                return TYPE_EDEFAULT == null ? this.getType() != null : !TYPE_EDEFAULT.equals(this.getType());
            }
            case 4: {
                return DEFINITION_EDEFAULT == null ? this.getDefinition() != null : !DEFINITION_EDEFAULT.equals(this.getDefinition());
            }
            case 5: {
                return this.getHierarchyLevel() != -1;
            }
            case 6: {
                return "" == null ? this.getIdocType() != null : !"".equals(this.getIdocType());
            }
            case 7: {
                return "" == null ? this.getIdocTypeExtension() != null : !"".equals(this.getIdocTypeExtension());
            }
            case 8: {
                return "" == null ? this.getSystemRelease() != null : !"".equals(this.getSystemRelease());
            }
            case 9: {
                return "" == null ? this.getApplicationRelease() != null : !"".equals(this.getApplicationRelease());
            }
            case 10: {
                return this.getNumFields() != 0;
            }
            case 11: {
                return this.getMaxOccurrence() != 0L;
            }
            case 12: {
                return this.getMinOccurrence() != 0L;
            }
            case 13: {
                return this.isMandatory();
            }
            case 14: {
                return this.isQualified();
            }
            case 15: {
                return this.getRecordLength() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new IllegalArgumentException("The value is not of type: " + type + " but is : " + value.getClass().getCanonicalName());
    }

    @Override
    public int size() {
        return this.getFilteredFeatureMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String featureName = (String)key;
        return this.getFilteredFeatureMap().get(featureName) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (EStructuralFeature eFeature : this.getFilteredFeatureMap().values()) {
            if (!this.eGet(eFeature).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String featureName = (String)key;
        EStructuralFeature eFeature = this.getFilteredFeatureMap().get(featureName);
        if (eFeature == null) {
            return null;
        }
        Object value = this.eGet(eFeature);
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        EStructuralFeature eFeature = this.getFilteredFeatureMap().get(key);
        if (eFeature == null) {
            throw new IllegalArgumentException("Key '" + key + "' is not valid for this segment");
        }
        Object returnValue = this.eGet(eFeature);
        this.eSet(eFeature, value);
        return returnValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String featureName = (String)key;
        EStructuralFeature eFeature = this.getFilteredFeatureMap().get(featureName);
        if (eFeature == null) {
            return null;
        }
        Object returnValue = this.eGet(eFeature);
        this.eUnset(eFeature);
        return returnValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            Object value = m.get(string);
            this.put(string, value);
        }
    }

    @Override
    public void clear() {
        for (EStructuralFeature eFeature : this.getFilteredFeatureMap().values()) {
            this.eUnset(eFeature);
        }
    }

    @Override
    public Set<String> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Object> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void initFilteredFeatures() {
        LinkedHashMap<String, EStructuralFeature> map = new LinkedHashMap<String, EStructuralFeature>();
        for (EStructuralFeature feature : this.eClass().getEStructuralFeatures()) {
            EStructuralFeature duplicate;
            String key = feature.getName();
            if ("segmentChildren".equals(key) || (duplicate = map.put(key, feature)) == null) continue;
            System.out.println("Adding " + key);
            map.put(key, duplicate);
        }
        this.filteredFeatureMap = map;
    }

    protected Map<String, EStructuralFeature> getFilteredFeatureMap() {
        if (this.filteredFeatureMap == null) {
            this.initFilteredFeatures();
        }
        return this.filteredFeatureMap;
    }

    public static class Entry
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends FeatureIterator<Map.Entry<String, Object>> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            EStructuralFeature feature = this.nextEntry();
            Object value = SegmentImpl.this.get(feature.getName());
            return new Entry(feature.getName(), value);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return SegmentImpl.this.containsKey(e.getKey());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object value = SegmentImpl.this.remove(e.getKey());
            return value != null;
        }

        @Override
        public int size() {
            return SegmentImpl.this.size();
        }

        @Override
        public void clear() {
            SegmentImpl.this.clear();
        }
    }

    private abstract class FeatureIterator<E>
    implements Iterator<E> {
        private final Iterator<EStructuralFeature> iterator;
        private EStructuralFeature current;

        public FeatureIterator() {
            this.iterator = SegmentImpl.this.getFilteredFeatureMap().values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        EStructuralFeature nextEntry() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            String key = this.current.getName();
            this.current = null;
            SegmentImpl.this.remove(key);
        }
    }

    private class KeyIterator
    extends FeatureIterator<String> {
        private KeyIterator() {
        }

        @Override
        public String next() {
            return this.nextEntry().getName();
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SegmentImpl.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return SegmentImpl.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            if (SegmentImpl.this.containsKey(key)) {
                SegmentImpl.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SegmentImpl.this.clear();
        }
    }

    private class ValueIterator
    extends FeatureIterator<Object> {
        private ValueIterator() {
        }

        @Override
        public Object next() {
            EStructuralFeature feature = this.nextEntry();
            return SegmentImpl.this.get(feature.getName());
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SegmentImpl.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return SegmentImpl.this.containsValue(o);
        }

        @Override
        public void clear() {
            SegmentImpl.this.clear();
        }
    }
}

