/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.util;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocFactory;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRecordMetaData;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.model.idoc.IdocFactory;
import org.fusesource.camel.component.sap.model.idoc.IdocPackage;
import org.fusesource.camel.component.sap.model.idoc.Segment;
import org.fusesource.camel.component.sap.model.idoc.SegmentChildren;
import org.fusesource.camel.component.sap.model.idoc.impl.DocumentImpl;
import org.fusesource.camel.component.sap.model.idoc.impl.DocumentListImpl;
import org.fusesource.camel.component.sap.model.idoc.impl.SegmentImpl;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDocUtil
extends Util {
    private static final Logger LOG = LoggerFactory.getLogger(IDocUtil.class);
    public static final String GenNS_URI = "http://www.eclipse.org/emf/2002/GenModel";
    public static final String GenNS_DOCUMENTATION_KEY = "documentation";
    public static final String IDocNS_COMPOUND_TYPE_KEY = "compoundType";
    public static final String IDocNS_NAME_KEY = "name";
    public static final String IDocNS_DEFINITION_KEY = "definition";
    public static final String IDocNS_HIERARCHY_LEVEL_KEY = "hierarchyLevel";
    public static final String IDocNS_IDOC_TYPE_KEY = "idocType";
    public static final String IDocNS_IDOC_TYPE_EXTENSION_KEY = "idocTypeExtension";
    public static final String IDocNS_KEY_KEY = "key";
    public static final String IDocNS_SYSTEM_RELEASE_KEY = "systemRelease";
    public static final String IDocNS_APPLICATION_RELEASE_KEY = "applicationRelease";
    public static final String IDocNS_TYPE_KEY = "type";
    public static final String IDocNS_MAX_OCCURRENCE_KEY = "maxOccurrence";
    public static final String IDocNS_MIN_OCCURRENCE_KEY = "minOccurrence";
    public static final String IDocNS_IS_MANDATORY_KEY = "isMandatory";
    public static final String IDocNS_IS_QUALIFIED_KEY = "isQualified";
    public static final String IDocNS_NUM_FIELDS_KEY = "numFields";
    public static final String IDocNS_IS_LOCKED_KEY = "isLocked";
    public static final String IDocNS_RECORD_LENGTH_KEY = "recordLength";
    public static final String IDocNS_DESCRIPTION_KEY = "description";
    public static final String IDocNS_CLASS_NAME_OF_FIELD_KEY = "classNameOfField";
    public static final String IDocNS_CHECK_TABLE_NAME_KEY = "checkTableName";
    public static final String IDocNS_DATA_ELEMENT_NAME_KEY = "dataElementName";
    public static final String IDocNS_DATA_TYPE_KEY = "dataType";
    public static final String IDocNS_DATA_TYPE_NAME_KEY = "dataTypeName";
    public static final String IDocNS_DOMAIN_NAME_KEY = "domainName";
    public static final String IDocNS_INTERNAL_LENGTH_KEY = "internalLength";
    public static final String IDocNS_LENGTH_KEY = "length";
    public static final String IDocNS_OFFSET_KEY = "offset";
    public static final String IDocNS_OUTPUT_LENGTH_KEY = "outputLength";
    public static final String IDocNS_RECORD_TYPE_KEY = "recordType";
    public static final String IDocNS_TYPE_AS_STRING_KEY = "typeAsString";
    public static final String IDocNS_VALUE_DESCRIPTIONS_KEY = "valueDescriptions";
    public static final String IDocNS_VALUE_RANGES_KEY = "valueRanges";
    public static final String IDocNS_VALUES_KEY = "values";
    public static final String IDocNS_IS_ISO_CODE_KEY = "isoCode";
    public static final String IDocNS_POSITION_KEY = "position";

    public static void sendDocument(JCoDestination destination, Document document, String tid) throws JCoException, IDocMetaDataUnavailableException {
        IDocRepository iDocRepository = JCoIDoc.getIDocRepository((JCoDestination)destination);
        IDocFactory iDocFactory = JCoIDoc.getIDocFactory();
        Segment rootSegment = document.getRootSegment();
        IDocDocument iDocDocument = iDocFactory.createIDocDocument(iDocRepository, rootSegment.getIdocType(), rootSegment.getIdocTypeExtension(), rootSegment.getSystemRelease(), rootSegment.getApplicationRelease());
        IDocUtil.fillIDocDocumentFromDocument(document, iDocDocument);
        JCoIDoc.send((IDocDocument)iDocDocument, (char)'0', (JCoDestination)destination, (String)tid);
    }

    public static void sendDocument(JCoDestination destination, Document document, String tid, String queueName) throws JCoException, IDocMetaDataUnavailableException {
        IDocRepository iDocRepository = JCoIDoc.getIDocRepository((JCoDestination)destination);
        IDocFactory iDocFactory = JCoIDoc.getIDocFactory();
        Segment rootSegment = document.getRootSegment();
        IDocDocument iDocDocument = iDocFactory.createIDocDocument(iDocRepository, rootSegment.getIdocType(), rootSegment.getIdocTypeExtension(), rootSegment.getSystemRelease(), rootSegment.getApplicationRelease());
        IDocUtil.fillIDocDocumentFromDocument(document, iDocDocument);
        JCoIDoc.send((IDocDocument)iDocDocument, (char)'0', (JCoDestination)destination, (String)tid, (String)queueName);
    }

    public static void sendDocumentList(JCoDestination destination, DocumentList documentList, String tid) throws Exception {
        IDocRepository iDocRepository = JCoIDoc.getIDocRepository((JCoDestination)destination);
        IDocFactory iDocFactory = JCoIDoc.getIDocFactory();
        IDocDocumentList iDocDocumentList = iDocFactory.createIDocDocumentList(iDocRepository, documentList.getIdocType(), documentList.getIdocTypeExtension(), documentList.getSystemRelease(), documentList.getApplicationRelease());
        IDocUtil.fillIDocDocumentListFromDocumentList(documentList, iDocDocumentList);
        JCoIDoc.send((IDocDocumentList)iDocDocumentList, (char)'0', (JCoDestination)destination, (String)tid);
    }

    public static void sendDocumentList(JCoDestination destination, DocumentList documentList, String tid, String queueName) throws Exception {
        IDocRepository iDocRepository = JCoIDoc.getIDocRepository((JCoDestination)destination);
        IDocFactory iDocFactory = JCoIDoc.getIDocFactory();
        IDocDocumentList iDocDocumentList = iDocFactory.createIDocDocumentList(iDocRepository, documentList.getIdocType(), documentList.getIdocTypeExtension(), documentList.getSystemRelease(), documentList.getApplicationRelease());
        IDocUtil.fillIDocDocumentListFromDocumentList(documentList, iDocDocumentList);
        JCoIDoc.send((IDocDocumentList)iDocDocumentList, (char)'0', (JCoDestination)destination, (String)tid, (String)queueName);
    }

    public static void fillIDocDocumentListFromDocumentList(DocumentList documentList, IDocDocumentList idocDocumentList) throws Exception {
        if (idocDocumentList == null || documentList == null) {
            LOG.warn("IDoc document list '" + idocDocumentList + "' not filled from document list '" + documentList + "'");
            return;
        }
        for (Document document : documentList) {
            IDocDocument idocDocument = idocDocumentList.addNew();
            IDocUtil.fillIDocDocumentFromDocument(document, idocDocument);
        }
    }

    public static void fillIDocDocumentFromDocument(Document document, IDocDocument idocDocument) {
        if (idocDocument == null || document == null) {
            LOG.warn("IDoc Document '" + idocDocument + "' not filled from document '" + document + "'");
            return;
        }
        try {
            idocDocument.setArchiveKey(document.getArchiveKey());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill ArchiveKey attribute with value '" + document.getArchiveKey() + "' of IDoc Document");
        }
        try {
            idocDocument.setClient(document.getClient());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill Client attribute with value '" + document.getClient() + "' of IDoc Document");
        }
        try {
            idocDocument.setCreationDate(document.getCreationDate());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill CreationDate attribute with value '" + document.getCreationDate() + "' of IDoc Document");
        }
        try {
            idocDocument.setCreationTime(document.getCreationTime());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill CreationTime attribute with value '" + document.getCreationTime() + "' of IDoc Document");
        }
        try {
            idocDocument.setDirection(document.getDirection());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill Direction attribute with value '" + document.getDirection() + "' of IDoc Document");
        }
        try {
            idocDocument.setEDIMessage(document.getEDIMessage());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill EDIMessage attribute with value '" + document.getEDIMessage() + "' of IDoc Document");
        }
        try {
            idocDocument.setEDIMessageGroup(document.getEDIMessageGroup());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill EDIMessageGroup attribute with value '" + document.getEDIMessageGroup() + "' of IDoc Document");
        }
        try {
            idocDocument.setEDIMessageType(document.getEDIMessageType());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill EDIMessageType attribute with value '" + document.getEDIMessageType() + "' of IDoc Document");
        }
        try {
            idocDocument.setEDIStandardFlag(document.getEDIStandardFlag());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill EDIStandardFlag attribute with value '" + document.getEDIStandardFlag() + "' of IDoc Document");
        }
        try {
            idocDocument.setEDIStandardVersion(document.getEDIStandardVersion());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill EDIStandardVersion attribute with value '" + document.getEDIStandardVersion() + "' of IDoc Document");
        }
        try {
            idocDocument.setEDITransmissionFile(document.getEDITransmissionFile());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill EDITransmissionFile attribute with value '" + document.getEDITransmissionFile() + "' of IDoc Document");
        }
        try {
            idocDocument.setIDocCompoundType(document.getIDocCompoundType());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill IDocCompoundType attribute with value '" + document.getIDocCompoundType() + "' of IDoc Document");
        }
        try {
            idocDocument.setIDocNumber(document.getIDocNumber());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill IDocNumber attribute with value '" + document.getIDocNumber() + "' of IDoc Document");
        }
        try {
            idocDocument.setIDocSAPRelease(document.getIDocSAPRelease());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill IDocSAPRelease attribute with value '" + document.getIDocSAPRelease() + "' of IDoc Document");
        }
        try {
            idocDocument.setIDocType(document.getIDocType());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill IDocType attribute with value '" + document.getIDocType() + "' of IDoc Document");
        }
        try {
            idocDocument.setIDocTypeExtension(document.getIDocTypeExtension());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill IDocTypeExtension attribute with value '" + document.getIDocTypeExtension() + "' of IDoc Document");
        }
        try {
            idocDocument.setMessageCode(document.getMessageCode());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill MessageCode attribute with value '" + document.getMessageCode() + "' of IDoc Document");
        }
        try {
            idocDocument.setMessageFunction(document.getMessageFunction());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill MessageFunction attribute with value '" + document.getMessageFunction() + "' of IDoc Document");
        }
        try {
            idocDocument.setMessageType(document.getMessageType());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill MessageType attribute with value '" + document.getMessageType() + "' of IDoc Document");
        }
        try {
            idocDocument.setOutputMode(document.getOutputMode());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill OutputMode attribute with value '" + document.getOutputMode() + "' of IDoc Document");
        }
        try {
            idocDocument.setRecipientAddress(document.getRecipientAddress());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill RecipientAddress attribute with value '" + document.getRecipientAddress() + "' of IDoc Document");
        }
        try {
            idocDocument.setRecipientLogicalAddress(document.getRecipientLogicalAddress());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill RecipientLogicalAddress attribute with value '" + document.getRecipientLogicalAddress() + "' of IDoc Document");
        }
        try {
            idocDocument.setRecipientPartnerFunction(document.getRecipientPartnerFunction());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill RecipientPartnerFunction attribute with value '" + document.getRecipientPartnerFunction() + "' of IDoc Document");
        }
        try {
            idocDocument.setRecipientPartnerType(document.getRecipientPartnerType());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill RecipientPartnerType attribute with value '" + document.getRecipientPartnerType() + "' of IDoc Document");
        }
        try {
            idocDocument.setRecipientPartnerNumber(document.getRecipientPartnerNumber());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill RecipientPartnerNumber attribute with value '" + document.getRecipientPartnerNumber() + "' of IDoc Document");
        }
        try {
            idocDocument.setRecipientPort(document.getRecipientPort());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill RecipientPort attribute with value '" + document.getRecipientPort() + "' of IDoc Document");
        }
        try {
            idocDocument.setSenderAddress(document.getSenderAddress());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill SenderAddress attribute with value '" + document.getSenderAddress() + "' of IDoc Document");
        }
        try {
            idocDocument.setSenderLogicalAddress(document.getSenderLogicalAddress());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill SenderLogicalAddress attribute with value '" + document.getSenderLogicalAddress() + "' of IDoc Document");
        }
        try {
            idocDocument.setSenderPartnerFunction(document.getSenderPartnerFunction());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill SenderPartnerFunction attribute with value '" + document.getSenderPartnerFunction() + "' of IDoc Document");
        }
        try {
            idocDocument.setSenderPartnerNumber(document.getSenderPartnerNumber());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill SenderPartnerNumber attribute with value '" + document.getSenderPartnerNumber() + "' of IDoc Document");
        }
        try {
            idocDocument.setSenderPartnerType(document.getSenderPartnerType());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill SenderPartnerType attribute with value '" + document.getSenderPartnerType() + "' of IDoc Document");
        }
        try {
            idocDocument.setSenderPort(document.getSenderPort());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill SenderPort attribute with value '" + document.getSenderPort() + "' of IDoc Document");
        }
        try {
            idocDocument.setSerialization(document.getSerialization());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill Serialization attribute with value '" + document.getSerialization() + "' of IDoc Document");
        }
        try {
            idocDocument.setStatus(document.getStatus());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill Status attribute with value '" + document.getStatus() + "' of IDoc Document");
        }
        try {
            idocDocument.setTestFlag(document.getTestFlag());
        }
        catch (IDocConversionException | IDocSyntaxException throwable) {
            LOG.warn("Failed to fill TestFlag attribute with value '" + document.getTestFlag() + "' of IDoc Document");
        }
        IDocUtil.fillIDocSegmentFromSegment(document.getRootSegment(), idocDocument.getRootSegment());
    }

    public static void fillIDocSegmentFromSegment(Segment segment, IDocSegment idocSegment) {
        if (segment == null || idocSegment == null) {
            LOG.warn("IDoc Segment '" + idocSegment + "' not filled from segment '" + segment + "'");
            return;
        }
        for (String fieldName : segment.keySet()) {
            Object value = segment.get(fieldName);
            try {
                idocSegment.setValue(fieldName, value);
            }
            catch (Exception exception) {
                LOG.warn("Failed to fill '" + fieldName + "' attribute with value '" + value + "' of IDoc Document");
            }
        }
        SegmentChildren segmentChildren = ((SegmentImpl)segment).getSegmentChildren();
        for (String segmentType : segmentChildren.getTypes()) {
            for (Segment childSegment : segmentChildren.get(segmentType)) {
                try {
                    IDocSegment childIDocSegment = idocSegment.addChild(segmentType);
                    IDocUtil.fillIDocSegmentFromSegment(childSegment, childIDocSegment);
                }
                catch (Exception exception) {
                    LOG.warn("Failed to create and fill child IDoc segment '" + segmentType + "' with child segment '" + childSegment + "'");
                }
            }
        }
    }

    public static void extractIDocDocumentListIntoDocumentList(IDocDocumentList idocDocumentList, DocumentList documentList) {
        if (documentList == null || idocDocumentList == null) {
            LOG.warn("IDoc document list '" + idocDocumentList + "' not extracted to document list '" + documentList + "'");
            return;
        }
        for (IDocDocument idocDocument : idocDocumentList) {
            Document document = documentList.add();
            IDocUtil.extractIDocDocumentIntoDocument(idocDocument, document);
        }
    }

    public static void extractIDocDocumentIntoDocument(IDocDocument idocDocument, Document document) {
        if (document == null || idocDocument == null) {
            LOG.warn("IDoc Document '" + idocDocument + "' not extracted to document '" + document + "'");
            return;
        }
        document.setArchiveKey(idocDocument.getArchiveKey());
        document.setClient(idocDocument.getClient());
        document.setCreationDate(idocDocument.getCreationDate());
        document.setCreationTime(idocDocument.getCreationTime());
        document.setDirection(idocDocument.getDirection());
        document.setEDIMessage(idocDocument.getEDIMessage());
        document.setEDIMessageGroup(idocDocument.getEDIMessageGroup());
        document.setEDIMessageType(idocDocument.getEDIMessageType());
        document.setEDIStandardFlag(idocDocument.getEDIStandardFlag());
        document.setEDIStandardVersion(idocDocument.getEDIStandardVersion());
        document.setEDITransmissionFile(idocDocument.getEDITransmissionFile());
        document.setIDocCompoundType(idocDocument.getIDocCompoundType());
        document.setIDocNumber(idocDocument.getIDocNumber());
        document.setIDocSAPRelease(idocDocument.getIDocSAPRelease());
        document.setIDocType(idocDocument.getIDocType());
        document.setIDocTypeExtension(idocDocument.getIDocTypeExtension());
        document.setMessageCode(idocDocument.getMessageCode());
        document.setMessageFunction(idocDocument.getMessageFunction());
        document.setMessageType(idocDocument.getMessageType());
        document.setOutputMode(idocDocument.getOutputMode());
        document.setRecipientAddress(idocDocument.getRecipientAddress());
        document.setRecipientLogicalAddress(idocDocument.getRecipientLogicalAddress());
        document.setRecipientPartnerFunction(idocDocument.getRecipientPartnerFunction());
        document.setRecipientPartnerType(idocDocument.getRecipientPartnerType());
        document.setRecipientPartnerNumber(idocDocument.getRecipientPartnerNumber());
        document.setRecipientPort(idocDocument.getRecipientPort());
        document.setSenderAddress(idocDocument.getSenderAddress());
        document.setSenderLogicalAddress(idocDocument.getSenderLogicalAddress());
        document.setSenderPartnerFunction(idocDocument.getSenderPartnerFunction());
        document.setSenderPartnerNumber(idocDocument.getSenderPartnerNumber());
        document.setSenderPartnerType(idocDocument.getSenderPartnerType());
        document.setSenderPort(idocDocument.getSenderPort());
        document.setSerialization(idocDocument.getSerialization());
        document.setStatus(idocDocument.getStatus());
        document.setTestFlag(idocDocument.getTestFlag());
        IDocUtil.extractIDocSegmentIntoSegment(idocDocument.getRootSegment(), document.getRootSegment());
    }

    public static void extractIDocSegmentIntoSegment(IDocSegment idocSegment, Segment segment) {
        if (segment == null || idocSegment == null) {
            LOG.warn("IDoc Document '" + idocSegment + "' not extracted to segment '" + segment + "'");
            return;
        }
        for (String fieldName : segment.keySet()) {
            try {
                Object value = idocSegment.getValue(fieldName);
                IDocUtil.setValue((EObject)segment, fieldName, value);
            }
            catch (Exception exception) {
                LOG.warn("Failed to extract value from field '" + fieldName + "' from IDoc segment to segment");
            }
        }
        SegmentChildren segmentChildren = ((SegmentImpl)segment).getSegmentChildren();
        for (String segmentType : segmentChildren.getTypes()) {
            IDocSegment[] iDocSegmentArray = idocSegment.getChildren(segmentType);
            int n = iDocSegmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocSegment childIDocSegment = iDocSegmentArray[n2];
                Object childSegment = segmentChildren.get(segmentType).add();
                IDocUtil.extractIDocSegmentIntoSegment(childIDocSegment, childSegment);
                ++n2;
            }
        }
    }

    public static DocumentList createDocumentList(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            throw new IllegalArgumentException("IDoc Type must be specified");
        }
        iDocTypeExtension = iDocTypeExtension == null ? "" : iDocTypeExtension;
        systemRelease = systemRelease == null ? "" : systemRelease;
        applicationRelease = applicationRelease == null ? "" : applicationRelease;
        IDocID iDocID = new IDocID(repository.getName(), iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        EPackage ePackage = IDocUtil.getEPackage(repository, iDocID.getPackageNamespaceURI());
        if (ePackage == null) {
            throw new RuntimeException("Can not create Document list: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClassifier classifier = ePackage.getEClassifier("ROOT");
        if (classifier == null || !(classifier instanceof EClass)) {
            throw new RuntimeException("Can not create Document list: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClass rootSegmentClass = (EClass)classifier;
        if (!IdocPackage.eINSTANCE.getSegment().isSuperTypeOf(rootSegmentClass)) {
            throw new RuntimeException("Can not create Document list: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        DocumentListImpl documentList = (DocumentListImpl)IdocFactory.eINSTANCE.createDocumentList();
        documentList.setRootSegmentClass(rootSegmentClass);
        return documentList;
    }

    public static DocumentList createDocumentList(String repositoryName, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            throw new IllegalArgumentException("IDoc Type must be specified");
        }
        IDocID iDocID = new IDocID(repositoryName, iDocType, iDocTypeExtension = iDocTypeExtension == null ? "" : iDocTypeExtension, systemRelease = systemRelease == null ? "" : systemRelease, applicationRelease = applicationRelease == null ? "" : applicationRelease);
        EPackage ePackage = registry.getEPackage(iDocID.getPackageNamespaceURI());
        if (ePackage == null) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClassifier classifier = ePackage.getEClassifier("ROOT");
        if (classifier == null || !(classifier instanceof EClass)) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClass rootSegmentClass = (EClass)classifier;
        if (!IdocPackage.eINSTANCE.getSegment().isSuperTypeOf(rootSegmentClass)) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        DocumentListImpl documentList = (DocumentListImpl)IdocFactory.eINSTANCE.createDocumentList();
        documentList.setRootSegmentClass(rootSegmentClass);
        return documentList;
    }

    public static Document createDocument(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            throw new IllegalArgumentException("IDoc Type must be specified");
        }
        iDocTypeExtension = iDocTypeExtension == null ? "" : iDocTypeExtension;
        systemRelease = systemRelease == null ? "" : systemRelease;
        applicationRelease = applicationRelease == null ? "" : applicationRelease;
        IDocID iDocID = new IDocID(repository.getName(), iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        EPackage ePackage = IDocUtil.getEPackage(repository, iDocID.getPackageNamespaceURI());
        if (ePackage == null) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClassifier classifier = ePackage.getEClassifier("ROOT");
        if (classifier == null || !(classifier instanceof EClass)) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClass eClass = (EClass)classifier;
        if (!IdocPackage.eINSTANCE.getSegment().isSuperTypeOf(eClass)) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        Segment segment = (Segment)ePackage.getEFactoryInstance().create(eClass);
        DocumentImpl iDoc = (DocumentImpl)IdocFactory.eINSTANCE.createDocument();
        iDoc.setRootSegment(segment);
        ((SegmentImpl)segment).setDocument(iDoc);
        iDoc.setIDocType(iDocType);
        iDoc.setIDocTypeExtension(iDocTypeExtension);
        Date now = new Date();
        iDoc.setCreationDate(now);
        iDoc.setCreationTime(now);
        String idocCompoundType = IDocUtil.getAnnotation(segment.eClass(), "http://sap.fusesource.org/idoc", IDocNS_COMPOUND_TYPE_KEY);
        if (idocCompoundType == null) {
            iDoc.setIDocCompoundType(idocCompoundType);
        }
        return iDoc;
    }

    public static Document createDocument(EClass rootSegmentClass) {
        Segment segment = (Segment)rootSegmentClass.getEPackage().getEFactoryInstance().create(rootSegmentClass);
        DocumentImpl iDoc = (DocumentImpl)IdocFactory.eINSTANCE.createDocument();
        iDoc.setRootSegment(segment);
        ((SegmentImpl)segment).setDocument(iDoc);
        iDoc.setIDocType(segment.getIdocType());
        iDoc.setIDocTypeExtension(segment.getIdocTypeExtension());
        Date now = new Date();
        iDoc.setCreationDate(now);
        iDoc.setCreationTime(now);
        String idocCompoundType = IDocUtil.getAnnotation(segment.eClass(), "http://sap.fusesource.org/idoc", IDocNS_COMPOUND_TYPE_KEY);
        if (idocCompoundType == null) {
            iDoc.setIDocCompoundType(idocCompoundType);
        }
        return iDoc;
    }

    public static Document createDocument(String repositoryName, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            throw new IllegalArgumentException("IDoc Type must be specified");
        }
        IDocID iDocID = new IDocID(repositoryName, iDocType, iDocTypeExtension = iDocTypeExtension == null ? "" : iDocTypeExtension, systemRelease = systemRelease == null ? "" : systemRelease, applicationRelease = applicationRelease == null ? "" : applicationRelease);
        EPackage ePackage = registry.getEPackage(iDocID.getPackageNamespaceURI());
        if (ePackage == null) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClassifier classifier = ePackage.getEClassifier("ROOT");
        if (classifier == null || !(classifier instanceof EClass)) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        EClass eClass = (EClass)classifier;
        if (!IdocPackage.eINSTANCE.getSegment().isSuperTypeOf(eClass)) {
            throw new RuntimeException("Can not create IDoc: meta-data for IDoc type '" + iDocID.getPackageName() + "' does not exist");
        }
        Segment segment = (Segment)ePackage.getEFactoryInstance().create(eClass);
        DocumentImpl iDoc = (DocumentImpl)IdocFactory.eINSTANCE.createDocument();
        iDoc.setRootSegment(segment);
        iDoc.setIDocType(iDocType);
        iDoc.setIDocTypeExtension(iDocTypeExtension);
        Date now = new Date();
        iDoc.setCreationDate(now);
        iDoc.setCreationTime(now);
        String idocCompoundType = IDocUtil.getAnnotation(segment.eClass(), "http://sap.fusesource.org/idoc", IDocNS_COMPOUND_TYPE_KEY);
        if (idocCompoundType == null) {
            iDoc.setIDocCompoundType(idocCompoundType);
        }
        return iDoc;
    }

    public static EPackage getEPackage(IDocRepository repository, String nsURI) {
        IDocID iDocID;
        EPackage ePackage;
        block5: {
            ePackage = (EPackage)registry.get(nsURI);
            if (ePackage != null) {
                return ePackage;
            }
            try {
                iDocID = new IDocID(nsURI);
                if (repository.getName().equals(iDocID.repositoryName)) break block5;
                LOG.warn("Repository '" + repository.getName() + "' does not match requested repository '" + iDocID.repositoryName + "' for IDoc type : " + iDocID.iDocType + ", IDoc type extension : " + iDocID.iDocTypeExtension + ", system release : " + iDocID.systemRelease + ", application release : " + iDocID.applicationRelease);
                return null;
            }
            catch (Exception e) {
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        IDocSegmentMetaData rootSegmentMetaData = repository.getRootSegmentMetaData(iDocID.iDocType, iDocID.iDocTypeExtension, iDocID.systemRelease, iDocID.applicationRelease);
        if (rootSegmentMetaData == null) {
            LOG.warn("Repository '" + repository.getName() + "' does not contain meta data for IDoc type : " + iDocID.iDocType + ", IDoc type extension : " + iDocID.iDocTypeExtension + ", system release : " + iDocID.systemRelease + ", application release : " + iDocID.applicationRelease);
            return null;
        }
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        ePackage = ecoreFactory.createEPackage();
        ePackage.setName(iDocID.getPackageName());
        ePackage.setNsPrefix(iDocID.getPackageNamespacePrefix());
        ePackage.setNsURI(iDocID.getPackageNamespaceURI());
        EClass rootClass = ecoreFactory.createEClass();
        ePackage.getEClassifiers().add(rootClass);
        rootClass.setName("ROOT");
        rootClass.getESuperTypes().add(IdocPackage.eINSTANCE.getSegment());
        IDocUtil.addSegmentMetaData(rootClass, rootSegmentMetaData);
        IDocUtil.addAnnotation(rootClass, GenNS_URI, GenNS_DOCUMENTATION_KEY, "Segment type for " + iDocID.getPackageName());
        IDocUtil.addAnnotation(rootClass, "http://sap.fusesource.org/idoc", IDocNS_COMPOUND_TYPE_KEY, repository.getIDocCompoundType(iDocID.getiDocType(), iDocID.getiDocTypeExtension()));
        registry.put(nsURI, ePackage);
        return ePackage;
    }

    public static void addSegmentMetaData(EClass eClass, IDocSegmentMetaData idocSegmentMetaData) {
        if (idocSegmentMetaData == null) {
            return;
        }
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EPackage ePackage = eClass.getEPackage();
        IDocRecordMetaData idocRecordMetaData = idocSegmentMetaData.getRecordMetaData();
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_NAME_KEY, idocRecordMetaData.getName());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_TYPE_KEY, idocSegmentMetaData.getType());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_KEY_KEY, idocSegmentMetaData.getKey());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_DEFINITION_KEY, idocSegmentMetaData.getDefinition());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_DESCRIPTION_KEY, idocSegmentMetaData.getDescription());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_HIERARCHY_LEVEL_KEY, Integer.toString(idocSegmentMetaData.getHierarchyLevel()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_IDOC_TYPE_KEY, idocSegmentMetaData.getIDocType());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_IDOC_TYPE_EXTENSION_KEY, idocSegmentMetaData.getIDocTypeExtension());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_SYSTEM_RELEASE_KEY, idocSegmentMetaData.getSystemRelease());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_APPLICATION_RELEASE_KEY, idocSegmentMetaData.getApplicationRelease());
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_NUM_FIELDS_KEY, Integer.toString(idocRecordMetaData.getNumFields()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_MAX_OCCURRENCE_KEY, Long.toString(idocSegmentMetaData.getMaxOccurrence()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_MIN_OCCURRENCE_KEY, Long.toString(idocSegmentMetaData.getMinOccurrence()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_IS_LOCKED_KEY, Boolean.toString(idocRecordMetaData.isLocked()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_IS_MANDATORY_KEY, Boolean.toString(idocSegmentMetaData.isMandatory()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_IS_QUALIFIED_KEY, Boolean.toString(idocSegmentMetaData.isQualified()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_IS_LOCKED_KEY, Boolean.toString(idocSegmentMetaData.isLocked()));
        IDocUtil.addAnnotation(eClass, "http://sap.fusesource.org/idoc", IDocNS_RECORD_LENGTH_KEY, Integer.toString(idocRecordMetaData.getRecordLength()));
        int i = 0;
        while (i < idocRecordMetaData.getNumFields()) {
            EAttribute attribute = ecoreFactory.createEAttribute();
            attribute.setEType(IDocUtil.getEDataType(idocRecordMetaData.getType(i)));
            attribute.setName(idocRecordMetaData.getName(i));
            IDocUtil.addAnnotation(attribute, GenNS_URI, GenNS_DOCUMENTATION_KEY, idocRecordMetaData.getDescription(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_CLASS_NAME_OF_FIELD_KEY, IDocUtil.getClassName(idocRecordMetaData.getType(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_POSITION_KEY, Integer.toString(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_DESCRIPTION_KEY, idocRecordMetaData.getDescription(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_CHECK_TABLE_NAME_KEY, idocRecordMetaData.getCheckTableName(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_DATA_ELEMENT_NAME_KEY, idocRecordMetaData.getDataElementName(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_DATA_TYPE_KEY, Integer.toString(idocRecordMetaData.getDatatype(i).ordinal()));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_DATA_TYPE_NAME_KEY, idocRecordMetaData.getDataTypeName(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_DOMAIN_NAME_KEY, idocRecordMetaData.getDomainName(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_INTERNAL_LENGTH_KEY, Integer.toString(idocRecordMetaData.getInternalLength(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_LENGTH_KEY, Integer.toString(idocRecordMetaData.getLength(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_OFFSET_KEY, Integer.toString(idocRecordMetaData.getOffset(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_OUTPUT_LENGTH_KEY, Integer.toString(idocRecordMetaData.getOutputLength(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_RECORD_TYPE_KEY, Integer.toString(idocRecordMetaData.getType(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_TYPE_AS_STRING_KEY, idocRecordMetaData.getTypeAsString(i));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_VALUES_KEY, Arrays.toString(idocRecordMetaData.getValues(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_VALUE_DESCRIPTIONS_KEY, Arrays.toString(idocRecordMetaData.getValueDescriptions(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_VALUE_RANGES_KEY, Arrays.deepToString((Object[])idocRecordMetaData.getValueRanges(i)));
            IDocUtil.addAnnotation(attribute, "http://sap.fusesource.org/idoc", IDocNS_IS_ISO_CODE_KEY, Boolean.toString(idocRecordMetaData.isISOCode(i)));
            eClass.getEStructuralFeatures().add(i, attribute);
            ++i;
        }
        EClass segmentListsClass = IDocUtil.getSegmentChildrenClass(ePackage, idocSegmentMetaData);
        EReference childrenReference = ecoreFactory.createEReference();
        childrenReference.setEType(segmentListsClass);
        childrenReference.setName("segmentChildren");
        childrenReference.setContainment(true);
        childrenReference.setLowerBound(0);
        childrenReference.setUpperBound(1);
        eClass.getEStructuralFeatures().add(childrenReference);
    }

    public static EClass getSegmentChildrenClass(EPackage ePackage, IDocSegmentMetaData iDocSegmentMetaData) {
        EClassifier segmentListsClass = ePackage.getEClassifier(String.valueOf(iDocSegmentMetaData.getName()) + "_CHILDREN");
        if (!(segmentListsClass instanceof EClass)) {
            EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
            segmentListsClass = ecoreFactory.createEClass();
            ePackage.getEClassifiers().add(segmentListsClass);
            segmentListsClass.setName(String.valueOf(iDocSegmentMetaData.getType()) + "_CHILDREN");
            ((EClass)segmentListsClass).getESuperTypes().add(IdocPackage.eINSTANCE.getSegmentChildren());
            EAttribute segmentsAttribute = IdocPackage.eINSTANCE.getSegmentChildren_Segments();
            IDocSegmentMetaData[] iDocSegmentMetaDataArray = iDocSegmentMetaData.getChildren();
            int n = iDocSegmentMetaDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocSegmentMetaData childIDocSegmentMetaData = iDocSegmentMetaDataArray[n2];
                EClass childSegmentClass = IDocUtil.getSegmentClass(ePackage, childIDocSegmentMetaData);
                EReference reference = ecoreFactory.createEReference();
                ((EClass)segmentListsClass).getEStructuralFeatures().add(reference);
                reference.setName(childIDocSegmentMetaData.getType());
                reference.setUpperBound(-1);
                reference.setEType(childSegmentClass);
                reference.setContainment(true);
                reference.setVolatile(true);
                reference.setTransient(true);
                reference.setDerived(true);
                ExtendedMetaData.INSTANCE.setGroup(reference, segmentsAttribute);
                ++n2;
            }
        }
        return (EClass)segmentListsClass;
    }

    public static EClass getSegmentClass(EPackage ePackage, IDocSegmentMetaData idocSegmentMetaData) {
        EClassifier structureClass = ePackage.getEClassifier(idocSegmentMetaData.getName());
        if (!(structureClass instanceof EClass)) {
            structureClass = EcoreFactory.eINSTANCE.createEClass();
            ePackage.getEClassifiers().add(structureClass);
            structureClass.setName(idocSegmentMetaData.getType());
            ((EClass)structureClass).getESuperTypes().add(IdocPackage.eINSTANCE.getSegment());
            IDocUtil.addSegmentMetaData((EClass)structureClass, idocSegmentMetaData);
        }
        return (EClass)structureClass;
    }

    public static EClassifier getEDataType(int segmentFieldType) {
        switch (segmentFieldType) {
            case 8: 
            case 9: 
            case 10: {
                return EcorePackage.Literals.EINT;
            }
            case 0: {
                return EcorePackage.Literals.ESTRING;
            }
            case 6: {
                return EcorePackage.Literals.ESTRING;
            }
            case 2: {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
            case 1: {
                return EcorePackage.Literals.EDATE;
            }
            case 3: {
                return EcorePackage.Literals.EDATE;
            }
            case 7: {
                return EcorePackage.Literals.EDOUBLE;
            }
            case 4: {
                return EcorePackage.Literals.EBYTE_ARRAY;
            }
            case 29: {
                return EcorePackage.Literals.ESTRING;
            }
            case 30: {
                return EcorePackage.Literals.EBYTE_ARRAY;
            }
        }
        return EcorePackage.Literals.EBYTE_ARRAY;
    }

    public static String getClassName(int segmentFieldType) {
        switch (segmentFieldType) {
            case 8: 
            case 9: 
            case 10: {
                return Integer.class.getName();
            }
            case 0: {
                return String.class.getName();
            }
            case 6: {
                return String.class.getName();
            }
            case 2: {
                return BigDecimal.class.getName();
            }
            case 1: {
                return Date.class.getName();
            }
            case 3: {
                return Date.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 4: {
                return byte[].class.getName();
            }
            case 29: {
                return String.class.getName();
            }
            case 30: {
                return byte[].class.getName();
            }
        }
        return byte[].class.getName();
    }

    public static int segmentOccurrences(long longValue) {
        if (longValue > Integer.MAX_VALUE) {
            return -1;
        }
        if (longValue < 0L) {
            return 0;
        }
        return (int)longValue;
    }

    public static void readReferences(EObject eobject, Set<EObject> preventCycles, List<EObject> rootList) {
        if (preventCycles.contains(eobject)) {
            return;
        }
        preventCycles.add(eobject);
        if (eobject.eContainer() != null) {
            IDocUtil.readReferences(eobject.eContainer(), preventCycles, rootList);
        } else {
            rootList.add(eobject);
        }
        for (Object e : eobject.eClass().getEAllReferences()) {
            EReference eref = (EReference)e;
            Object value = eobject.eGet(eref);
            if (value == null) continue;
            if (value instanceof List) {
                for (Object obj : (List)value) {
                    IDocUtil.readReferences((EObject)obj, preventCycles, rootList);
                }
                continue;
            }
            IDocUtil.readReferences((EObject)value, preventCycles, rootList);
        }
    }

    public static class IDocID {
        private String repositoryName;
        private String iDocType;
        private String iDocTypeExtension;
        private String systemRelease;
        private String applicationRelease;

        public IDocID(String uri) throws Exception {
            if (uri == null || !uri.startsWith("http://sap.fusesource.org/idoc")) {
                throw new IllegalArgumentException("Invalid IDoc namespace uri: " + uri);
            }
            String[] components = (uri = uri.substring("http://sap.fusesource.org/idoc".length())).split("/", 6);
            if (components.length != 6) {
                throw new IllegalArgumentException("Invalid IDoc namespace uri: " + uri);
            }
            this.repositoryName = components[1];
            this.iDocType = components[2];
            this.iDocTypeExtension = components[3];
            this.systemRelease = components[4];
            this.applicationRelease = components[5];
        }

        public IDocID(String repositoryName, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            this.repositoryName = repositoryName;
            this.iDocType = iDocType;
            this.iDocTypeExtension = iDocTypeExtension;
            this.systemRelease = systemRelease;
            this.applicationRelease = applicationRelease;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public String getiDocType() {
            return this.iDocType;
        }

        public void setiDocType(String iDocType) {
            this.iDocType = iDocType;
        }

        public String getiDocTypeExtension() {
            return this.iDocTypeExtension;
        }

        public void setiDocTypeExtension(String iDocTypeExtension) {
            this.iDocTypeExtension = iDocTypeExtension;
        }

        public String getSystemRelease() {
            return this.systemRelease;
        }

        public void setSystemRelease(String systemRelease) {
            this.systemRelease = systemRelease;
        }

        public String getApplicationRelease() {
            return this.applicationRelease;
        }

        public void setApplicationRelease(String applicationRelease) {
            this.applicationRelease = applicationRelease;
        }

        public String getPackageName() {
            return String.valueOf(this.iDocType) + "_" + this.iDocTypeExtension + "_" + this.systemRelease + "_" + this.applicationRelease;
        }

        public String getPackageNamespacePrefix() {
            return String.valueOf(this.iDocType) + "-" + this.iDocTypeExtension + "-" + this.systemRelease + "-" + this.applicationRelease;
        }

        public String getPackageNamespaceURI() {
            return "http://sap.fusesource.org/idoc/" + this.repositoryName + "/" + this.iDocType + "/" + this.iDocTypeExtension + "/" + this.systemRelease + "/" + this.applicationRelease;
        }
    }
}

