/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trans.XPathException;

public class GroupVariableReference
extends LocalVariableReference {
    private ForEachGroup controllingExpression;

    public GroupVariableReference() {
    }

    public GroupVariableReference(Binding binding) {
        super(binding);
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        return super.optimize(visitor, contextItemType);
    }

    public Expression copy() {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        GroupVariableReference ref = new GroupVariableReference();
        ref.binding = this.binding;
        ref.staticType = this.staticType;
        ref.slotNumber = this.slotNumber;
        ref.constantValue = this.constantValue;
        ref.displayName = this.displayName;
        ref.controllingExpression = this.controllingExpression;
        this.binding.addReference(this.isInLoop());
        ExpressionTool.copyLocationInfo(this, ref);
        return ref;
    }

    public void setControllingExpression(ForEachGroup feg) {
        this.controllingExpression = feg;
        this.resetLocalStaticProperties();
    }

    public ForEachGroup getControllingExpression() {
        return this.controllingExpression;
    }

    public int computeSpecialProperties() {
        if (this.controllingExpression == null) {
            return 0;
        }
        return this.controllingExpression.getSelectExpression().getSpecialProperties();
    }

    public int computeCardinality() {
        return 49152;
    }
}

