/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.CipherOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedByteArrayOutputStream;
import org.apache.camel.converter.stream.CipherPair;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedOutputStream
extends OutputStream {
    @Deprecated
    public static final String THRESHOLD = "CamelCachedOutputStreamThreshold";
    @Deprecated
    public static final String BUFFER_SIZE = "CamelCachedOutputStreamBufferSize";
    @Deprecated
    public static final String TEMP_DIR = "CamelCachedOutputStreamOutputDirectory";
    @Deprecated
    public static final String CIPHER_TRANSFORMATION = "CamelCachedOutputStreamCipherTransformation";
    private static final Logger LOG = LoggerFactory.getLogger(CachedOutputStream.class);
    private final StreamCachingStrategy strategy;
    private OutputStream currentStream;
    private boolean inMemory = true;
    private int totalLength;
    private File tempFile;
    private FileInputStreamCache fileInputStreamCache;
    private final FileInputStreamCache.FileInputStreamCloser fileInputStreamCloser = new FileInputStreamCache.FileInputStreamCloser();
    private CipherPair ciphers;
    private final boolean closedOnCompletion;

    public CachedOutputStream(Exchange exchange) {
        this(exchange, true);
    }

    public CachedOutputStream(Exchange exchange, boolean closedOnCompletion) {
        this.closedOnCompletion = closedOnCompletion;
        this.strategy = exchange.getContext().getStreamCachingStrategy();
        this.currentStream = new CachedByteArrayOutputStream(this.strategy.getBufferSize());
        if (closedOnCompletion) {
            SynchronizationAdapter onCompletion = new SynchronizationAdapter(){

                @Override
                public void onDone(Exchange exchange) {
                    try {
                        CachedOutputStream.this.closeFileInputStreams();
                        CachedOutputStream.this.close();
                        try {
                            CachedOutputStream.this.cleanUpTempFile();
                        }
                        catch (Exception e) {
                            LOG.warn("Error deleting temporary cache file: " + CachedOutputStream.this.tempFile + ". This exception will be ignored.", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error closing streams. This exception will be ignored.", (Throwable)e);
                    }
                }

                public String toString() {
                    return "OnCompletion[CachedOutputStream]";
                }
            };
            UnitOfWork streamCacheUnitOfWork = exchange.getProperty("CamelStreamCacheUnitOfWork", UnitOfWork.class);
            if (streamCacheUnitOfWork != null) {
                streamCacheUnitOfWork.addSynchronization(onCompletion);
            } else {
                exchange.addOnCompletion(onCompletion);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
        if (!this.closedOnCompletion) {
            this.closeFileInputStreams();
            try {
                this.cleanUpTempFile();
            }
            catch (Exception e) {
                LOG.warn("Error deleting temporary cache file: " + this.tempFile + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public boolean equals(Object obj) {
        return this.currentStream.equals(obj);
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public OutputStream getCurrentStream() {
        return this.currentStream;
    }

    public String toString() {
        return "CachedOutputStream[size: " + this.totalLength + "]";
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.totalLength += len;
        if (this.inMemory && this.currentStream instanceof ByteArrayOutputStream && this.strategy.shouldSpoolCache(this.totalLength)) {
            this.pageToFileStream();
        }
        this.currentStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.totalLength += b.length;
        if (this.inMemory && this.currentStream instanceof ByteArrayOutputStream && this.strategy.shouldSpoolCache(this.totalLength)) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.totalLength;
        if (this.inMemory && this.currentStream instanceof ByteArrayOutputStream && this.strategy.shouldSpoolCache(this.totalLength)) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    public InputStream getInputStream() throws IOException {
        return (InputStream)((Object)this.newStreamCache());
    }

    public InputStream getWrappedInputStream() throws IOException {
        return new WrappedInputStream(this, (InputStream)((Object)this.newStreamCache()));
    }

    @Deprecated
    public StreamCache getStreamCache() throws IOException {
        return this.newStreamCache();
    }

    public StreamCache newStreamCache() throws IOException {
        this.flush();
        if (this.inMemory) {
            if (this.currentStream instanceof CachedByteArrayOutputStream) {
                return ((CachedByteArrayOutputStream)this.currentStream).newInputStreamCache();
            }
            throw new IllegalStateException("CurrentStream should be an instance of CachedByteArrayOutputStream but is: " + this.currentStream.getClass().getName());
        }
        try {
            if (this.fileInputStreamCache == null) {
                this.fileInputStreamCache = new FileInputStreamCache(this.tempFile, this.ciphers, this.fileInputStreamCloser);
            }
            return this.fileInputStreamCache;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file " + this.tempFile + " not found", e);
        }
    }

    private void closeFileInputStreams() {
        this.fileInputStreamCloser.close();
        this.fileInputStreamCache = null;
    }

    private void cleanUpTempFile() {
        if (this.tempFile != null) {
            FileUtil.deleteFile(this.tempFile);
            this.tempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageToFileStream() throws IOException {
        this.flush();
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        this.tempFile = FileUtil.createTempFile("cos", ".tmp", this.strategy.getSpoolDirectory());
        LOG.trace("Creating temporary stream cache file: {}", (Object)this.tempFile);
        try {
            this.currentStream = this.createOutputStream(this.tempFile);
            bout.writeTo(this.currentStream);
        }
        finally {
            this.inMemory = false;
        }
    }

    @Deprecated
    public int getBufferSize() {
        return this.getStrategyBufferSize();
    }

    public int getStrategyBufferSize() {
        return this.strategy.getBufferSize();
    }

    private OutputStream createOutputStream(File file) throws IOException {
        FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        if (ObjectHelper.isNotEmpty(this.strategy.getSpoolChiper())) {
            try {
                if (this.ciphers == null) {
                    this.ciphers = new CipherPair(this.strategy.getSpoolChiper());
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
            out = new CipherOutputStream(out, this.ciphers.getEncryptor()){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        this.closed = true;
                    }
                }
            };
        }
        return out;
    }

    private static class WrappedInputStream
    extends InputStream {
        private CachedOutputStream cachedOutputStream;
        private InputStream inputStream;

        WrappedInputStream(CachedOutputStream cos, InputStream is) {
            this.cachedOutputStream = cos;
            this.inputStream = is;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
            this.cachedOutputStream.close();
        }
    }
}

